<?php
namespace App;

use PDO;

class Db
{
    public static function pdo(): PDO
    {
        $cfg = require __DIR__ . '/../config.php';
        $dsn = $cfg['db']['dsn'];
        $user = $cfg['db']['user'];
        $pass = $cfg['db']['pass'];

        $pdo = new PDO($dsn, $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);

        return $pdo;
    }
}
