<?php
require __DIR__ . '/../vendor/autoload.php';

$reportId = isset($_GET['report_id']) ? (int)$_GET['report_id'] : 0;
if (!$reportId) { http_response_code(400); echo "Missing report_id"; exit; }

$autoprint = isset($_GET['autoprint']) && $_GET['autoprint'] == '1';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Receipt View</title>
  <style>
    body{font-family:system-ui, -apple-system, Segoe UI, Roboto, Arial; background:#0b1220; color:#e8eefc; margin:0; padding:16px;}
    a{color:#8ab4ff}
    .top{max-width:980px; margin:0 auto 12px auto; display:flex; gap:10px; align-items:center; flex-wrap:wrap;}
    .btn{display:inline-block; padding:10px 12px; border-radius:10px; border:1px solid rgba(255,255,255,.15); background:#0d1528; color:#e8eefc; text-decoration:none;}
    .btn:hover{opacity:.9}
    .frame{max-width:980px; margin:0 auto;}
    iframe{width:100%; height:85vh; border:1px solid rgba(255,255,255,.12); border-radius:14px; background:#fff;}
  </style>
</head>
<body>
  <div class="top">
    <a class="btn" href="index.php">← Back</a>
    <a class="btn" href="download.php?report_id=<?= (int)$reportId ?>">Download PDF</a>
    <a class="btn" href="#" onclick="printReceipt(); return false;">Print</a>
  </div>

  <div class="frame">
    <iframe id="rcpt" src="receipt.php?report_id=<?= (int)$reportId ?>"></iframe>
  </div>

  <script>
    function printReceipt(){
      const f = document.getElementById('rcpt');
      if (!f) return;
      f.contentWindow.focus();
      f.contentWindow.print();
    }
    <?php if($autoprint): ?>
    window.addEventListener('load', () => {
      setTimeout(() => printReceipt(), 400);
    });
    <?php endif; ?>
  </script>
</body>
</html>
