<?php
require __DIR__ . '/../vendor/autoload.php';

use App\Db;

$pdo = Db::pdo();
$stores = $pdo->query("SELECT id, name FROM stores ORDER BY name")->fetchAll();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Upload Excel</title>
<style>
  body{font-family:system-ui, -apple-system, Segoe UI, Roboto, Arial; background:#0b1220; color:#e8eefc; margin:0;}
  a{color:#8ab4ff}
  .wrap{max-width:760px; margin:32px auto; padding:0 16px;}
  .card{background:#111a2e; border:1px solid rgba(255,255,255,.08); border-radius:14px; padding:16px;}
  input, select, button{width:100%; padding:12px; border-radius:10px; border:1px solid rgba(255,255,255,.15); background:#0d1528; color:#e8eefc;}
  label{display:block; margin:12px 0 6px; opacity:.9;}
</style>
</head>
<body>
<div class="wrap">
  <h1 style="margin:0 0 10px;">Upload Excel</h1>
  <div style="opacity:.8; margin-bottom:18px;">
    Upload your monthly sheet (single month file) OR the multi-month workbook (like Tonypandy.xlsx).
  </div>

  <div class="card">
    <form action="import.php" method="post" enctype="multipart/form-data">
      <label>Excel file (.xlsx)</label>
      <input type="file" name="xlsx" accept=".xlsx" required>

      <label>Select Store (from database)</label>
      <select name="store_id">
        <option value="">Select…</option>
        <?php foreach($stores as $s): ?>
          <option value="<?= (int)$s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
        <?php endforeach; ?>
      </select>

      <label>Or add a new store name (optional)</label>
      <input type="text" name="new_store_name" placeholder="e.g., Store 1 - Tonypandy">

      <label>Total Walkins (you can type this while uploading)</label>
      <input type="number" step="0.01" min="0" name="walkins" placeholder="e.g., 3.00" value="0">

      <div style="height:12px;"></div>
      <button type="submit">Upload & Import</button>
    </form>

    <div style="margin-top:14px;"><a href="index.php">← Back</a></div>
  </div>
</div>
</body>
</html>
