<?php
require __DIR__ . '/../vendor/autoload.php';

use App\Db;

$pdo = Db::pdo();

// Fetch stores + years + months
$stores = $pdo->query("SELECT id, name FROM stores ORDER BY name")->fetchAll();
$selStore = isset($_GET['store_id']) ? (int)$_GET['store_id'] : 0;
$selYear  = isset($_GET['year']) ? (int)$_GET['year'] : 0;
$selMonth = isset($_GET['month']) ? (int)$_GET['month'] : 0;

$where = [];
$params = [];
if ($selStore) { $where[] = "mr.store_id=?"; $params[] = $selStore; }
if ($selYear)  { $where[] = "mr.year=?"; $params[] = $selYear; }
if ($selMonth) { $where[] = "mr.month=?"; $params[] = $selMonth; }

$sql = "SELECT mr.id, mr.year, mr.month, s.name AS store_name, mr.imported_at
        FROM monthly_reports mr
        JOIN stores s ON s.id = mr.store_id";
if ($where) $sql .= " WHERE " . implode(" AND ", $where);
$sql .= " ORDER BY s.name, mr.year DESC, mr.month DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$reports = $stmt->fetchAll();

$years = $pdo->query("SELECT DISTINCT year FROM monthly_reports ORDER BY year DESC")->fetchAll(PDO::FETCH_COLUMN);
$months = range(1,12);
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>POS Reports</title>
<style>
  body{font-family:system-ui, -apple-system, Segoe UI, Roboto, Arial; background:#0b1220; color:#e8eefc; margin:0;}
  a{color:#8ab4ff}
  .wrap{max-width:980px; margin:32px auto; padding:0 16px;}
  .card{background:#111a2e; border:1px solid rgba(255,255,255,.08); border-radius:14px; padding:16px; margin-bottom:16px;}
  select, button{padding:10px 12px; border-radius:10px; border:1px solid rgba(255,255,255,.15); background:#0d1528; color:#e8eefc;}
  table{width:100%; border-collapse:collapse;}
  th,td{padding:10px 8px; border-bottom:1px solid rgba(255,255,255,.08); font-size:14px;}
  .row{display:flex; gap:10px; flex-wrap:wrap; align-items:center;}
  .pill{display:inline-block; padding:3px 10px; border-radius:999px; background:rgba(255,255,255,.08); font-size:12px;}
</style>
</head>
<body>
<div class="wrap">
  <h1 style="margin:0 0 10px;">POS Monthly Reports</h1>
  <div style="opacity:.8; margin-bottom:18px;">Upload Excel → filter by Store / Year / Month → download 58mm receipt PDF.</div>

  <div class="card">
    <div class="row" style="justify-content:space-between;">
      <form method="get" class="row">
        <select name="store_id">
          <option value="0">All Stores</option>
          <?php foreach($stores as $s): ?>
            <option value="<?= (int)$s['id'] ?>" <?= $selStore===(int)$s['id']?'selected':'' ?>><?= htmlspecialchars($s['name']) ?></option>
          <?php endforeach; ?>
        </select>

        <select name="year">
          <option value="0">All Years</option>
          <?php foreach($years as $y): ?>
            <option value="<?= (int)$y ?>" <?= $selYear===(int)$y?'selected':'' ?>><?= (int)$y ?></option>
          <?php endforeach; ?>
        </select>

        <select name="month">
          <option value="0">All Months</option>
          <?php foreach($months as $m): ?>
            <option value="<?= (int)$m ?>" <?= $selMonth===(int)$m?'selected':'' ?>><?= date('M', mktime(0,0,0,$m,1,2025)) ?></option>
          <?php endforeach; ?>
        </select>

        <button type="submit">Filter</button>
      </form>

      <div class="row">
        <a class="pill" href="upload.php">+ Upload Excel</a>
      </div>
    </div>
  </div>

  <div class="card">
    <table>
      <thead>
        <tr>
          <th>Store</th>
          <th>Period</th>
          <th>Imported</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php if(!$reports): ?>
        <tr><td colspan="4" style="opacity:.8;">No reports yet. Upload an Excel file.</td></tr>
      <?php endif; ?>
      <?php foreach($reports as $r): ?>
        <tr>
          <td><?= htmlspecialchars($r['store_name']) ?></td>
          <td><?= htmlspecialchars(date('M', mktime(0,0,0,(int)$r['month'],1,(int)$r['year'])) . ' ' . (int)$r['year']) ?></td>
          <td style="opacity:.8;"><?= htmlspecialchars($r['imported_at']) ?></td>
          <td style="text-align:right; white-space:nowrap;">
            <a href="view.php?report_id=<?= (int)$r['id'] ?>">View</a>
            &nbsp;|&nbsp;
            <a href="view.php?report_id=<?= (int)$r['id'] ?>&autoprint=1">Print</a>
            &nbsp;|&nbsp;
            <a href="download.php?report_id=<?= (int)$r['id'] ?>">Download PDF</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
