<?php
require __DIR__ . '/../vendor/autoload.php';

use App\Db;
use App\ExcelImporter;

if (!isset($_FILES['xlsx']) || $_FILES['xlsx']['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    echo "Upload failed";
    exit;
}

$tmp = $_FILES['xlsx']['tmp_name'];
$name = $_FILES['xlsx']['name'] ?? 'upload.xlsx';

$destDir = __DIR__ . '/../storage';
@mkdir($destDir, 0777, true);
$destPath = $destDir . '/' . time() . '_' . preg_replace('/[^a-zA-Z0-9_\-\.]/','_', $name);

if (!move_uploaded_file($tmp, $destPath)) {
    http_response_code(500);
    echo "Could not save file";
    exit;
}


$pdo = Db::pdo();
$importer = new ExcelImporter($pdo);

$walkins = isset($_POST['walkins']) ? (float)$_POST['walkins'] : 0.0;

$newStoreName = trim($_POST['new_store_name'] ?? '');
$storeId = isset($_POST['store_id']) ? (int)$_POST['store_id'] : 0;

// Store must come from DB, but allow creating a new store on the spot.
if ($newStoreName !== '') {
    $pdo->prepare("INSERT IGNORE INTO stores (name) VALUES (?)")->execute([$newStoreName]);
    $stmt = $pdo->prepare("SELECT id, name FROM stores WHERE name=?");
    $stmt->execute([$newStoreName]);
    $row = $stmt->fetch();
    if (!$row) { http_response_code(400); echo "Could not create store"; exit; }
    $storeId = (int)$row['id'];
    $forcedStore = (string)$row['name'];
} else {
    if (!$storeId) { http_response_code(400); echo "Missing store"; exit; }
    $stmt = $pdo->prepare("SELECT id, name FROM stores WHERE id=?");
    $stmt->execute([$storeId]);
    $row = $stmt->fetch();
    if (!$row) { http_response_code(400); echo "Unknown store"; exit; }
    $forcedStore = (string)$row['name'];
}

try {
    $results = $importer->import($destPath, $forcedStore, $walkins);
} catch (Throwable $e) {
    http_response_code(500);
    echo "Import error: " . htmlspecialchars($e->getMessage());
    exit;
}

header('Location: index.php');
exit;
