# POS Monthly Receipt Reports (PHP)

A small PHP + MySQL demo that:

- Uploads an Excel file (`.xlsx`)
- Imports monthly department sales (works with your **Tonypandy** format: single-month file *or* multi-month workbook)
- Lets you select **Store / Year / Month**
- Downloads a **58mm thermal receipt-style PDF** (like your sample).

> Note: Your photo receipt includes extra fields (walk-ins, tender split, till float, etc.).  
> This starter imports **Department + VAT Summary** from your Excel, and lets you type **Walkins** during upload.

---

## 1) Requirements

- PHP 8.1+
- MySQL / MariaDB
- Composer

---

## 2) Install dependencies

```bash
cd pos-receipt-reports
composer install
```

---

## 3) Create database tables

Create a DB (example: `pos_reports`), then run:

```bash
mysql -u root -p pos_reports < schema.sql
```

If you already installed the older version, run this once:

```sql
ALTER TABLE monthly_reports ADD COLUMN walkins DECIMAL(10,2) NOT NULL DEFAULT 0;
```

Edit `config.php` with your DB credentials.

If you already created tables from an older version, run this once:

```sql
ALTER TABLE monthly_reports ADD COLUMN walkins DECIMAL(10,2) NOT NULL DEFAULT 0;
```

---

## 4) Run locally

```bash
php -S localhost:8080 -t public
```

Open:

`http://localhost:8080`

---

## 5) Upload

Click **Upload Excel** and upload your workbook.

---

## How the importer works (your file)

Your workbook has:
- Row 1: month headings like `Store 1 - Tonypandy - Jan 2021` (start of each month block)
- Row 2: labels like `Total Sale (Gross Sale), VAT, NET Sale, VAT Percentages, Category Sales %`
- Rows 3+: department lines

The importer detects month blocks automatically and stores them as `store + year + month`.

---

## Next upgrades (easy)

1. Add a “Daily Z Report” Excel template:
   - Date, Walkins, FirstTxn, LastTxn
   - Department totals
   - Cash/Card/Credit totals
   - Till float / cash lift
2. Add those fields to DB + include them in the 58mm receipt.

If you want, paste your exact Excel columns (or upload the final template) and I’ll adapt the importer & PDF layout.
