<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <title>EZY LEND</title>
</head>
<body>
  <div class="container-scroller">
    <!-- navbar -->
    <?php include '../../partials/navbar.php'; ?>  
    <!-- navbar -->
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- settings -->
      <?php include '../../partials/settings.php'; ?>  
      <!-- settings -->
      <!-- sidebar-->
      <?php include '../../partials/sidebar.php'; ?>   
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body"></div>
            </div>
          </div>

          <div class="col-12 grid-margin">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">New Staff</h4>
                <form class="form-sample" id="newStaffForm" enctype="multipart/form-data">
                  <p class="card-description">Personal info</p>
                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="prefix">Prefix</label>
                      <select id="prefix" class="form-control" name="prefix">
                        <option value="Mr">Mr</option>
                        <option value="Ms">Ms</option>
                        <option value="Mrs">Mrs</option>
                      </select>
                    </div>

                    <div class="form-group col-md-5">
                      <label for="firstName">First Name</label>
                      <input type="text" class="form-control" id="firstName" name="firstName" placeholder="First Name">
                    </div>

                    <div class="form-group col-md-5">
                      <label for="lastName">Last Name</label>
                      <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Last Name">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="gender">Gender</label>
                      <select class="form-control" id="gender" name="gender">
                        <option>Male</option>
                        <option>Female</option>
                      </select>
                    </div>

                    <div class="form-group col-md-2">
                      <label for="dob">Date of Birth</label>
                      <input type="text" class="form-control" id="dob" name="dob" placeholder="dd/mm/yyyy" />
                    </div>

                    <div class="form-group col-md-4">
                      <label for="mobile">Mobile</label>
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <select class="form-control" style="max-width: 180px;  " id="mobileCountry" name="mobileCountry">
  <!-- Country options will be populated dynamically here -->
</select>
                        </div>
                        <input type="text" class="form-control" id="mobile" name="mobile" placeholder="Mobile number">
                      </div>
                    </div>

                    <div class="form-group col-md-4">
                      <label for="email">Email</label>
                      <input type="text" class="form-control" id="email" name="email" />
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <label>File upload</label>
                      <input type="file" name="img" class="file-upload-default" />
                      <div class="input-group col-xs-12">
                        <input type="text" class="form-control file-upload-info" disabled placeholder="Upload Image">
                        <span class="input-group-append">
                          <button class="file-upload-browse btn btn-primary" type="button">Upload</button>
                        </span>
                      </div>
                    </div>

                    <div class="form-group col-md-2">
                      <label for="role">Role</label>
                      <select class="form-control" id="role" name="role">
                        <option>Admin</option>
                        <option>Support</option>
                      </select>
                    </div>
                  </div>

                  <p class="card-description">Address</p>
                  <div class="form-row">
                    <div class="form-group col-md-3">
                      <label for="apt">Apt No</label>
                      <input type="text" class="form-control" id="apt" name="apt" placeholder="Apt No" />
                    </div>

                    <div class="form-group col-md-9">
                      <label for="address">Address</label>
                      <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address" />
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="postcode">Postcode</label>
                      <input type="text" class="form-control" id="postcode" name="postcode" />
                    </div>

                    <div class="form-group col-md-3">
                      <label for="country">Country</label>
                      <select class="form-control" id="country" name="country">
  <!-- Country options will be populated dynamically here -->
</select>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12" style="text-align: right;">
                          <button type="submit" class="btn btn-inverse-primary btn-fw">Add Staff</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <!-- Response Modal -->
          <div class="modal" id="responseModal">
            <div class="modal-content">
              <div id="responseMsg" class="mt-2"></div>
            </div>
          </div>

        </div>
        <?php include '../../partials/footer.php'; ?>
      </div>   
    </div>     
  </div>

  <?php include '../../partials/loadjs.php'; ?>

  <script>
 $(document).ready(function () {
  // Fetch country data from the Restcountries API
  $.ajax({
    url: 'https://restcountries.com/v3.1/all?fields=name,idd',  // API URL to get all countries
    type: 'GET',
    success: function (data) {
      console.log('API Data:', data);  // Log the data returned from the API

      var countryData = {};  // Object to store country code and phone number lengths

      // Loop through the countries data
      data.forEach(function (country) {
        if (country.idd && country.idd.root) {
          const countryName = country.name.common; // Country name
          const countryCode = country.idd.root + (country.idd.suffixes ? country.idd.suffixes[0] : ''); // Form the country code

          // Store the country name and country code with a reference to the expected number length
          countryData[countryCode] = {
            name: countryName,
            length: country.idd.root === '+1' ? 10 : (country.idd.suffixes ? 10 : 11)  // Example lengths, can be extended
          };

          // Append the option to the #country dropdown (sending only the country name)
          $('#country').append(`
            <option value="${countryName}">${countryName}</option>
          `);

          // Append the option to the #mobileCountry dropdown (sending country code and country name)
          $('#mobileCountry').append(`
            <option value="${countryCode}">${countryName} (${countryCode})</option>
          `);
        }
      });

      // Set the default selected value (UK)
      $('#country').val('United Kingdom');
      $('#mobileCountry').val('+44');  // UK country code
      updateMobileNumberLength('+44', countryData);  // Update the mobile number length based on UK

      // Detect country code change
      $('#mobileCountry').change(function () {
        const selectedCode = $(this).val();
        updateMobileNumberLength(selectedCode, countryData);  // Dynamically update length
      });
    },
    error: function (error) {
      console.error('Error fetching countries:', error);
      alert('Error fetching country data. Please try again later.');
    }
  });

  // Function to update the max length of mobile number field based on selected country code
  function updateMobileNumberLength(countryCode, countryData) {
    const length = countryData[countryCode] ? countryData[countryCode].length : 10; // Default length 10
    $('#mobile').attr('maxlength', length);  // Set maxlength based on the country code
  }

  // Handle form submission
  $('#newStaffForm').submit(function (e) {
    e.preventDefault();  // Prevent the default form submission

    console.log("Form submission triggered!");

    var isValid = true;
    var errorMessage = '';

    // Validate first name
    if ($('#firstName').val().trim() === '') {
      isValid = false;
      errorMessage += 'First Name is required.<br>';
    }

    // Validate last name
    if ($('#lastName').val().trim() === '') {
      isValid = false;
      errorMessage += 'Last Name is required.<br>';
    }

    // Validate gender
    if ($('#gender').val() === '') {
      isValid = false;
      errorMessage += 'Gender is required.<br>';
    }

    // Validate date of birth
    var dob = $('#dob').val().trim();
    var dobRegex = /^(\d{2})\/(\d{2})\/(\d{4})$/;  // dd/mm/yyyy format
    if (dob === '') {
      isValid = false;
      errorMessage += 'Date of Birth is required.<br>';
    } else if (!dobRegex.test(dob)) {
      isValid = false;
      errorMessage += 'Please enter a valid Date of Birth (dd/mm/yyyy).<br>';
    }

    // Validate mobile number
    var mobile = $('#mobile').val().trim();
    var mobileRegex = /^[0-9]{10,15}$/;  // Ensure it's numeric and 10 to 15 digits
    if (mobile === '') {
      isValid = false;
      errorMessage += 'Mobile number is required.<br>';
    } else if (!mobileRegex.test(mobile)) {
      isValid = false;
      errorMessage += 'Please enter a valid mobile number (10-15 digits).<br>';
    }

    // Validate email
    var email = $('#email').val().trim();
    var emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
    if (email === '') {
      isValid = false;
      errorMessage += 'Email is required.<br>';
    } else if (!emailRegex.test(email)) {
      isValid = false;
      errorMessage += 'Please enter a valid email address.<br>';
    }

    // If form validation fails
    if (!isValid) {
      console.log("Form validation failed. Showing errors...");
      showModal(errorMessage, 'text-danger');  // Show modal with error message and red text
      return;  // Stop form submission
    }

    // Submit form via AJAX (using FormData)
    console.log("Form is valid. Submitting via AJAX...");

    var formData = new FormData(this);  // Create FormData object

    $.ajax({
      url: 'includes/insertstaff.php',  // PHP script for form submission
      type: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      success: function(response) {
        console.log("Success Response:", response);  // Log success response
        showModal(response, 'text-success');  // Show success modal
        $('#newStaffForm')[0].reset();  // Reset the form fields
      },
      error: function(jqXHR, textStatus, errorThrown) {
        console.log("AJAX Error:", textStatus, errorThrown);  // Log error details
        showModal('An error occurred. Please try again.', 'text-danger');  // Show error modal
      }
    });
  });
});

// Show the Modal with the Response Message
function showModal(message, type) {
  const modal = document.getElementById('responseModal');
  const responseMsg = document.getElementById('responseMsg');

  responseMsg.innerHTML = message;
  responseMsg.className = type;  // Set the message type (success or error)

  // Show modal with slide effect
  modal.classList.add('show');  // Show the modal

  // Close the modal after 3 seconds
  setTimeout(function() {
    closeModal();
  }, 3000);  // You can adjust the timeout duration
}

// Close the Modal
function closeModal() {
  const modal = document.getElementById('responseModal');
  modal.classList.remove('show');  // Hide the modal
}

</script>


</body>
</html>
