<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>

  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">

  <style>
    /* Put a horizontal scrollbar on small screens */
    .dt-scroll-wrap {
      width: 100%;
      overflow-x: auto;
      -webkit-overflow-scrolling: touch; /* smooth iOS scrolling */
    }

    /* Make the DT search + refresh sit nicely on one line on desktop, stack on mobile */
    .dt-toolbar {
      display: flex;
      align-items: center;
      gap: .5rem;
      flex-wrap: wrap;
      justify-content: flex-end;
    }

    /* Slightly tighter cells on narrow screens */
    @media (max-width: 576px) {
      table.dataTable td, table.dataTable th {
        padding: .5rem .6rem !important;
      }
    }

    /* Prevent long values from wrapping; keeps columns compact with scroll */
    #staffTable td, #staffTable th {
      white-space: nowrap;
    }
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">
          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Staff Details</h4>

                <!-- IMPORTANT: do NOT wrap in Bootstrap .table-responsive when using DataTables scrollX.
                     Use a plain div with overflow-x (above) to avoid double wrappers fighting each other. -->
                <div class="dt-scroll-wrap pt-3">
                  <table class="table table-bordered table-striped align-middle nowrap" id="staffTable" style="width:100%">
                    <thead>
                      <tr>
                        <th>Staff ID</th>
                        <th>Name</th>
                        <th>Contact Number</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>

              </div>
            </div>
          </div>

          <!-- Response Modal -->
          <div class="modal" id="responseModal" style="display: none;">
            <div class="modal-content p-3">
              <span class="close" style="cursor:pointer; float:right;">&times;</span>
              <div id="responseMsg" class="mt-2"></div>
            </div>
          </div>

        </div><!-- content-wrapper -->
      </div><!-- main-panel -->
    </div><!-- page-body-wrapper -->
  </div><!-- container-scroller -->

  <?php include '../../partials/loadjs.php'; ?>

  <!-- jQuery (if not already included by loadjs.php) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- DataTables JS -->
  <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

  <script>
    $(document).ready(function () {
      const staffTable = $('#staffTable').DataTable({
        ajax: {
          url: 'includes/get_staff_data.php',
          dataSrc: '' // expects plain array: [ {...}, {...} ]
        },
        columns: [
          { data: 'staff_ref_id' }, // 0
          { data: 'name' },         // 1
          { data: 'phone_number' }, // 2
          { data: 'role' },         // 3
          {                         // 4 (status button)
            data: 'is_active',
            orderable: false,
            render: function (isActive, type, row) {
              const active = (isActive == 1 || isActive === true);
              return `
                <button class="btn btn-${active ? 'success' : 'danger'} btn-sm toggle-status"
                        data-id="${row.staff_ref_id}"
                        data-status="${active ? 1 : 0}">
                  ${active ? 'Active' : 'Inactive'}
                </button>
              `;
            }
          },
          { // 5 (actions)
            data: null,
            orderable: false,
            searchable: false,
            className: 'text-nowrap',
            render: function (data, type, row) {
              return `
                <a href="pages/requireds/editStaff.php?staff_id=${row.staff_ref_id}"
                   class="btn btn-info btn-sm" data-toggle="tooltip" title="Edit">
                  <i class="fas fa-edit"></i>
                </a>
                <a href="pages/requireds/userdetails.php?staff_id=${row.staff_ref_id}"
                   class="btn btn-primary btn-sm" data-toggle="tooltip" title="Users">
                  <i class="fas fa-users"></i>
                </a>
              `;
            }
          }
        ],

        // Key settings for horizontal scroll (show all columns; no Responsive)
        responsive: false,     // disable column-hiding behavior
        scrollX: true,         // enable horizontal scrollbar
        autoWidth: false,      // prevents DataTables from forcing widths that can break scroll
        // Optional: define minimal widths if your columns collapse too much on mobile
        columnDefs: [
          { targets: 0, width: 100 },  // Staff ID
          { targets: 1, width: 160 },  // Name
          { targets: 2, width: 150 },  // Contact
          { targets: 3, width: 140 },  // Role
          { targets: 4, width: 120 },  // Status
          { targets: 5, width: 160 }   // Actions
        ],

        order: [[0, 'asc']],
        pageLength: 10,
        lengthMenu: [10, 25, 50, 100],
        deferRender: true,
        processing: true,
        language: { processing: 'Loading staff…' },

        // Custom DOM to place global search and our Refresh button together
        dom:
          "<'row mb-2'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
          "<'row mb-2'<'col-sm-12 dt-toolbar'<'dt-extra-toolbar'>>>" +
          "t" + // table (scroll wrapper already applied via CSS)
          "<'row mt-2'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

        // Ensure columns adjust after init (needed for scrollX in hidden containers)
        initComplete: function() {
          this.api().columns.adjust();
        },
        drawCallback: function() {
          this.api().columns.adjust();
        }
      });

      // Put placeholder on the global search input
      $('#staffTable_filter input')
        .attr('placeholder', 'Search staff…')
        .addClass('form-control form-control-sm');

      // Add Refresh button next to search
      $('.dt-extra-toolbar').html(`
        <button id="refreshTable" type="button" class="btn btn-outline-secondary btn-sm">
          <i class="mdi mdi-refresh"></i> Refresh
        </button>
      `);

      // Refresh button: reload only table data (keep current page & search)
      $(document).on('click', '#refreshTable', function () {
        staffTable.ajax.reload(null, false);
      });

      // Toggle Status (delegated)
      $('#staffTable').on('click', '.toggle-status', function () {
        const $btn        = $(this);
        const staffId     = $btn.data('id');
        const currentStat = Number($btn.data('status')); // 1 or 0
        const newStatus   = currentStat === 1 ? 0 : 1;

        // Optimistic UI
        $btn.data('status', newStatus)
            .toggleClass('btn-success btn-danger')
            .text(newStatus === 1 ? 'Active' : 'Inactive');

        $.ajax({
          url: 'includes/toggle_staff_status.php',
          method: 'POST',
          dataType: 'json',
          data: { staff_id: staffId }, // If API requires new_status, include it too
          success: function (res) {
            if (!res || !res.success) {
              revertButton();
              showModal('Error updating status.', 'error');
              return;
            }
            // Update the underlying row data so redraws stay in sync
            const idx = staffTable
              .rows()
              .indexes()
              .toArray()
              .find(i => staffTable.row(i).data().staff_ref_id == staffId);
            if (idx !== undefined) {
              const rowData = staffTable.row(idx).data();
              rowData.is_active = (newStatus === 1);
              staffTable.row(idx).data(rowData).invalidate().draw(false);
            }
          },
          error: function (xhr, status, err) {
            revertButton();
            showModal('Error: ' + err, 'error');
            console.error('Response Text:', xhr.responseText);
          }
        });

        function revertButton() {
          const revert = newStatus === 1 ? 0 : 1;
          $btn.data('status', revert)
              .toggleClass('btn-success btn-danger')
              .text(revert === 1 ? 'Active' : 'Inactive');
        }
      });

      // Simple modal helpers
      function showModal(message, type) {
        $('#responseMsg').text(message);
        $('#responseModal').show();
      }
      $('.close').on('click', function () {
        $('#responseModal').hide();
      });

      // If table is inside tabs/hidden panels, adjust columns when shown
      // (uncomment and adapt if relevant)
      // $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function () {
      //   staffTable.columns.adjust();
      // });
    });
  </script>
</body>
</html>
