<?php
// pages/settings/access_control.php
declare(strict_types=1);

$APP_ROOT = realpath(__DIR__ . '/..' . '/..');
require_once $APP_ROOT . '/api/_bootstrap.php';
require_once $APP_ROOT . '/api/_actor.php';
require_once $APP_ROOT . '/api/rbac.php';

guard('page:settings:view');

// ---- URL base → API URL ----
$docRoot = str_replace('\\','/', realpath($_SERVER['DOCUMENT_ROOT'] ?? ''));
$appRoot = str_replace('\\','/', realpath($APP_ROOT));
$APP_BASE = rtrim(str_replace($docRoot, '', $appRoot), '/');   // e.g. /ezylend-admin
$API_URL  = ($APP_BASE ?: '') . '/api/acl.php';
?>
<?php include $APP_ROOT.'/partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Access Control</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    .ac-grid{display:grid;grid-template-columns:260px 1fr;gap:1rem;}
    @media(max-width:991.98px){.ac-grid{grid-template-columns:1fr;}}
    .card-sm{border:1px solid #e5e7eb;border-radius:10px;}
    .role-pill{display:block;padding:.35rem .5rem;border:1px solid #e5e7eb;border-radius:8px;margin-bottom:.5rem;text-decoration:none}
    .role-pill.active{background:#eef2ff;border-color:#c7d2fe}
    .muted{color:#6b7280;font-size:.85rem}
    .chip{display:inline-block;padding:.1rem .4rem;border-radius:6px;background:#f3f4f6;font-size:.75rem}
    .table-sm td,.table-sm th{padding:.4rem .5rem;}
    .sticky-actions{position:sticky;bottom:0;background:#fff;border-top:1px solid #e5e7eb;padding:.5rem .75rem;text-align:right}

    .matrix{width:100%;border-collapse:collapse}
    .matrix th,.matrix td{border-bottom:1px dashed #e5e7eb;padding:.4rem .5rem;vertical-align:middle}
    .switch{position:relative;display:inline-block;width:38px;height:22px}
    .switch input{display:none}
    .slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background:#e5e7eb;border-radius:999px;transition:.2s}
    .slider:before{content:"";position:absolute;height:18px;width:18px;left:2px;top:2px;background:#fff;border-radius:50%;transition:.2s;box-shadow:0 1px 2px rgba(0,0,0,.25)}
    input:checked + .slider{background:#10b981}
    input:checked + .slider:before{transform:translateX(16px)}

    /* modal + toast + error box */
    .xmodal{position:fixed;inset:0;z-index:1050;display:flex;align-items:center;justify-content:center;padding:24px;background:rgba(15,23,42,.32);opacity:0;visibility:hidden;transition:opacity .25s ease,visibility .25s ease}
    .xmodal.show{opacity:1;visibility:visible}
    .xpanel{width:min(860px,96vw);background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 22px 60px rgba(2,6,23,.20), 0 6px 16px rgba(2,6,23,.12);padding:16px 18px;max-height:calc(100vh - 80px);overflow:auto;transform:scale(.985) translateY(6px);opacity:0;transition:transform .22s cubic-bezier(.2,.8,.2,1), opacity .22s ease;position:relative}
    .xmodal.show .xpanel{transform:scale(1) translateY(0);opacity:1}
    .x-close{position:absolute;top:10px;right:10px;border:none;background:#f1f5f9;color:#111827;border-radius:8px;padding:.3rem .5rem;line-height:1;cursor:pointer}
    .toast-mini{position:fixed;right:12px;bottom:12px;background:#111;color:#fff;padding:10px 12px;border-radius:8px;z-index:9999;opacity:.95}
    .err-body{white-space:pre-wrap;background:#0f172a;color:#fff;padding:12px;border-radius:10px;max-height:50vh;overflow:auto;font:12px/1.45 ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;}
  </style>
</head>
<body>
<div class="container-scroller">
  <?php include $APP_ROOT.'/partials/navbar.php'; ?>
  <div class="container-fluid page-body-wrapper">
    <?php include $APP_ROOT.'/partials/settings.php'; ?>
    <?php include $APP_ROOT.'/partials/sidebar.php'; ?>

    <div class="main-panel">
      <div class="content-wrapper">
        <div class="d-flex align-items-center justify-content-between mb-3">
          <h3 class="font-weight-bold mb-0">Access Control</h3>
          <div class="btn-group">
            <button id="tabRoles"  class="btn btn-outline-primary active">Roles</button>
            <button id="tabPeople" class="btn btn-outline-primary">People</button>
          </div>
        </div>

        <!-- ROLES PANEL -->
        <div id="panelRoles">
          <div class="ac-grid">
            <!-- left -->
            <div>
              <div class="card card-sm">
                <div class="card-body">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <h5 class="card-title mb-0">Roles</h5>
                    <button class="btn btn-sm btn-primary" id="btnNewRole" <?= can('settings:update')?'':'disabled aria-disabled="true"' ?>>New</button>
                  </div>
                  <div id="roleList"></div>
                </div>
              </div>
            </div>

            <!-- right -->
            <div>
              <div class="card card-sm">
                <div class="card-body">
                  <form id="roleMatrixForm">
                    <div class="table-responsive">
                      <table class="matrix" id="permMatrix">
                        <thead>
                          <tr>
                            <th>Permission</th>
                            <th style="width:90px;text-align:center">Read</th>
                            <th style="width:90px;text-align:center">Write</th>
                            <th style="width:90px;text-align:center">Commit</th>
                            <th style="width:90px;text-align:center">Delete</th>
                          </tr>
                        </thead>
                        <tbody id="matrixBody"></tbody>
                      </table>
                    </div>
                    <div class="sticky-actions">
                      <button class="btn btn-primary" id="btnSaveRole" <?= can('settings:update')?'':'disabled aria-disabled="true"' ?>>Save Role Permissions</button>
                    </div>
                  </form>

                  <div class="mt-3">
                    <h6>Other permissions</h6>
                    <div id="otherList" class="d-flex flex-wrap" style="gap:10px"></div>
                  </div>
                </div>
              </div>
            </div>
          </div><!-- /grid -->
        </div>

        <!-- PEOPLE PANEL -->
        <div id="panelPeople" style="display:none">
          <div class="card card-sm">
            <div class="card-body">
              <div class="d-flex align-items-center justify-content-between mb-3">
                <div class="btn-group">
                  <button class="btn btn-outline-secondary active" id="btnAdmins">Admins</button>
                  <button class="btn btn-outline-secondary" id="btnUsers">Users</button>
                </div>
                <input class="form-control" id="personSearch" placeholder="Search…" style="max-width:320px" />
              </div>
              <div class="table-responsive">
                <table class="table table-sm">
                  <thead id="peopleHead"></thead>
                  <tbody id="personTbody"></tbody>
                </table>
              </div>
              <div class="muted">“Set Roles” edits role membership (multi-select). “Overrides” forces Allow/Deny for specific permissions.</div>
            </div>
          </div>
        </div>

      </div><!-- /content-wrapper -->
      <?php include $APP_ROOT.'/partials/footer.php'; ?>
    </div>
  </div>
</div>

<!-- New Role Modal -->
<div class="xmodal" id="newRoleModal" aria-hidden="true">
  <div class="xpanel">
    <button type="button" class="x-close" data-close="#newRoleModal">×</button>
    <h5 class="mb-3">Create Role</h5>
    <form id="newRoleForm">
      <div class="form-group">
        <label>Code (unique)</label>
        <input class="form-control" id="nr_code" placeholder="e.g. manager" required>
      </div>
      <div class="form-group">
        <label>Name</label>
        <input class="form-control" id="nr_name" placeholder="e.g. Manager" required>
      </div>
      <div class="text-right">
        <button class="btn btn-primary" <?= can('settings:update')?'':'disabled aria-disabled="true"' ?>>Create</button>
      </div>
    </form>
  </div>
</div>

<!-- Set Roles Modal -->
<div class="xmodal" id="rolesModal" aria-hidden="true">
  <div class="xpanel">
    <button type="button" class="x-close" data-close="#rolesModal">×</button>
    <h5 class="mb-2">Set Roles</h5>
    <input type="hidden" id="rolesWho" value="admin">
    <input type="hidden" id="rolesRef" value="">
    <input type="hidden" id="rolesId" value="0">
    <div id="rolesChecklist"></div>
    <div class="text-right mt-3">
      <button class="btn btn-primary" id="rolesSaveBtn" <?= can('settings:update')?'':'disabled aria-disabled="true"' ?>>Save</button>
    </div>
  </div>
</div>

<!-- Overrides Modal -->
<div class="xmodal" id="overridesModal" aria-hidden="true">
  <div class="xpanel">
    <button type="button" class="x-close" data-close="#overridesModal">×</button>
    <h5 class="mb-2">Permission Overrides</h5>
    <input type="hidden" id="ovrWho" value="admin">
    <input type="hidden" id="ovrRef" value="">
    <input type="hidden" id="ovrId" value="0">
    <div class="table-responsive">
      <table class="matrix">
        <thead>
          <tr><th>Permission</th><th style="width:130px;text-align:center">Inherit</th><th style="width:130px;text-align:center">Allow</th><th style="width:130px;text-align:center">Deny</th></tr>
        </thead>
        <tbody id="ovrBody"></tbody>
      </table>
    </div>
    <div class="text-right mt-3">
      <button class="btn btn-primary" id="ovrSaveBtn" <?= can('settings:update')?'':'disabled aria-disabled="true"' ?>>Save Overrides</button>
    </div>
  </div>
</div>

<!-- Error Modal -->
<div class="xmodal" id="errModal" aria-hidden="true">
  <div class="xpanel">
    <button type="button" class="x-close" data-close="#errModal">×</button>
    <h5 class="mb-2">Request Error</h5>
    <div id="errText" class="err-body"></div>
  </div>
</div>

<?php include $APP_ROOT.'/partials/loadjs.php'; ?>
<script>
const API = <?= json_encode($API_URL, JSON_UNESCAPED_SLASHES) ?>;

// ---------- tiny helpers ----------
const qs=(s,el=document)=>el.querySelector(s);
const qsa=(s,el=document)=>Array.from(el.querySelectorAll(s));
function el(tag,attrs={},html=''){ const x=document.createElement(tag); for(const k in attrs){ if(k==='class') x.className=attrs[k]; else x.setAttribute(k,attrs[k]); } if(html!==undefined) x.innerHTML=html; return x; }

function showError(msg){
  const t = qs('#errText');
  t.textContent = typeof msg==='string' ? msg : JSON.stringify(msg, null, 2);
  openModal('#errModal');
}
async function jget(params){
  const url=API+'?'+new URLSearchParams(params);
  try{
    const r=await fetch(url,{cache:'no-store'});
    const j=await r.json().catch(()=>({ok:false,error:'invalid_json'}));
    if(!r.ok || j?.ok===false) throw j;
    return j;
  }catch(e){ showError(e?.error||e?.message||'GET failed'); throw e; }
}
// Put action in querystring so PHP router always sees it
async function jpost(action, payload){
  try{
    const r = await fetch(API+'?action='+encodeURIComponent(action), {
      method:'POST',
      headers:{'Content-Type':'application/json'},
      body: JSON.stringify(payload||{})
    });
    const j = await r.json().catch(()=>({ok:false,error:'invalid_json'}));
    if(!r.ok || j?.ok===false) throw j;
    return j;
  }catch(e){ showError(e?.error||e?.message||('POST '+action+' failed')); throw e; }
}
function toast(msg){ const n=el('div',{class:'toast-mini'}, msg); document.body.appendChild(n); setTimeout(()=>n.remove(), 2100); }
function openModal(id){ qs(id).classList.add('show'); }
function closeModal(id){ qs(id).classList.remove('show'); }

// ---------- state ----------
let FEATURES={}, ROLES=[], PERMS=[], CURRENT_ROLE_ID=null;
let MATRIX={}, OTHER=[];

// ---------- tabs ----------
qs('#tabRoles').onclick=()=>{ qs('#tabRoles').classList.add('active'); qs('#tabPeople').classList.remove('active'); qs('#panelRoles').style.display=''; qs('#panelPeople').style.display='none'; };
qs('#tabPeople').onclick=()=>{ qs('#tabPeople').classList.add('active'); qs('#tabRoles').classList.remove('active'); qs('#panelPeople').style.display=''; qs('#panelRoles').style.display='none'; };

// ---------- load base ----------
(async function init(){
  FEATURES = await jget({action:'features'});
  // If DB has no users table, hide Users tab
  const btnUsers = document.getElementById('btnUsers');
  if (!FEATURES.has_users && btnUsers) btnUsers.remove();

  const r1 = await jget({action:'roles_list'}); ROLES = r1.roles||[];
  const p1 = await jget({action:'perms_list'}); PERMS = p1.permissions||[];
  buildMatrixFromPerms();
  renderRoleList();
  renderMatrixSkeleton();
  if (ROLES.length){ selectRole(ROLES[0].role_id); }
  loadPeople('admin');
})();

// ---------- build matrix ----------
function parseAction(code){
  const m = String(code).match(/^(.*?):(view|read|update|create|write|commit|delete)$/i);
  if(!m) return null; const domain=m[1], act=m[2].toLowerCase();
  if (act==='view'||act==='read') return {domain,action:'read'};
  if (act==='update'||act==='create'||act==='write') return {domain,action:'write'};
  if (act==='commit') return {domain,action:'commit'};
  if (act==='delete') return {domain,action:'delete'};
  return null;
}
function buildMatrixFromPerms(){
  MATRIX={}; OTHER=[];
  PERMS.forEach(p=>{ const pa=parseAction(p.code); if(!pa){ OTHER.push(p); return; }
    if(!MATRIX[pa.domain]) MATRIX[pa.domain]={label:pa.domain,pids:{},perm:{}};
    MATRIX[pa.domain].pids[pa.action]=p.perm_id; MATRIX[pa.domain].perm[pa.action]=p; });
}

// ---------- render roles ----------
function renderRoleList(){
  const host=qs('#roleList'); host.innerHTML='';
  ROLES.forEach(r=>{ const a=el('a',{href:'#','data-rid':r.role_id,class:'role-pill'}, `${escapeHtml(r.name)} <span class="muted">(${escapeHtml(r.code)})</span>`);
    a.onclick=(e)=>{ e.preventDefault(); selectRole(r.role_id); }; host.appendChild(a); });
  markActiveRole();
}
function markActiveRole(){ qsa('#roleList .role-pill').forEach(a=>{ a.classList.toggle('active', +a.getAttribute('data-rid')===+CURRENT_ROLE_ID); }); }

// ---------- render matrix ----------
function renderMatrixSkeleton(){
  const tb = qs('#matrixBody'); tb.innerHTML='';
  Object.keys(MATRIX).sort().forEach(domain=>{
    const row=el('tr'); row.appendChild(el('td',{}, `<div>${escapeHtml(domain)}</div>`));
    ['read','write','commit','delete'].forEach(kind=>{
      const pid=MATRIX[domain].pids[kind]; const td=el('td',{style:'text-align:center'});
      if(pid){ const id=`mx_${pid}`; td.innerHTML=`<label class="switch"><input type="checkbox" data-pid="${pid}" id="${id}"><span class="slider"></span></label>`; }
      else { td.innerHTML='<span class="muted">—</span>'; }
      row.appendChild(td);
    });
    tb.appendChild(row);
  });
  const ol=qs('#otherList'); ol.innerHTML='';
  OTHER.forEach(p=>{ const id=`mx_${p.perm_id}`; const w=el('label',{class:'role-pill',style:'display:inline-flex;align-items:center;gap:8px;width:auto;'});
    w.innerHTML=`<input type="checkbox" data-pid="${p.perm_id}" id="${id}"> <span>${escapeHtml(p.label)}</span> <span class="chip">${escapeHtml(p.code)}</span>`; ol.appendChild(w); });
}

// ---------- select role ----------
async function selectRole(rid){
  CURRENT_ROLE_ID=+rid; markActiveRole();
  const j=await jget({action:'role_perms_get', role_id:rid});
  const on=new Set((j.perm_ids||[]).map(Number));
  qsa('[data-pid]').forEach(cb=> cb.checked = on.has(+cb.dataset.pid));
}

// ---------- save role permissions ----------
qs('#roleMatrixForm').addEventListener('submit', async (e)=>{
  e.preventDefault(); if(!CURRENT_ROLE_ID){ toast('Pick a role'); return; }
  const perm_ids = qsa('[data-pid]').filter(x=>x.checked).map(x=>+x.dataset.pid);
  await jpost('role_perms_save', {role_id: CURRENT_ROLE_ID, perm_ids});
  toast('Saved role permissions');
});

// ---------- new role ----------
qs('#btnNewRole').onclick=()=>{ qs('#nr_code').value=''; qs('#nr_name').value=''; openModal('#newRoleModal'); };
qs('#newRoleForm').addEventListener('submit', async (e)=>{
  e.preventDefault(); const code=qs('#nr_code').value.trim(); const name=qs('#nr_name').value.trim(); if(!code||!name) return;
  const r=await jpost('role_create', {code, name});
  ROLES.push(r.role); ROLES.sort((a,b)=>a.name.localeCompare(b.name)); renderRoleList();
  closeModal('#newRoleModal'); toast('Role created');
});

// ---------- People ----------
qs('#btnAdmins').onclick=()=>loadPeople('admin');
const usersBtn = document.getElementById('btnUsers');
if (usersBtn) usersBtn.onclick=()=>loadPeople('user');

async function loadPeople(who){
  const hasUsersBtn = !!document.getElementById('btnUsers');
  qs('#btnAdmins').classList.toggle('active', who==='admin');
  if (hasUsersBtn) qs('#btnUsers').classList.toggle('active',  who==='user');

  const thead=qs('#peopleHead');
  thead.innerHTML = (who==='admin')
    ? '<tr><th>#</th><th>ID</th><th>Ref</th><th>Username</th><th>Type</th><th>Status</th><th>Actions</th></tr>'
    : '<tr><th>#</th><th>ID</th><th>Ref</th><th>Username</th><th>Staff Name</th><th>Actions</th></tr>';

  const j=await jget({action:'people_list', who});
  const tbody=qs('#personTbody'); tbody.innerHTML='';
  (j.rows||[]).forEach((row,i)=>{
    const tr=el('tr',{'data-ref':row.ref||'', 'data-id': row.id||0, 'data-who':who});
    if (who==='admin'){
      tr.innerHTML = `
        <td>${i+1}</td>
        <td>${row.id}</td>
        <td>${escapeHtml(row.ref||'')}</td>
        <td>${escapeHtml(row.username||'')}</td>
        <td>${escapeHtml(row.type||'')}</td>
        <td>${escapeHtml(row.status||'')}</td>
        <td>
          <button type="button" class="btn btn-sm btn-outline-primary btn-set-roles">Set Roles</button>
          <button type="button" class="btn btn-sm btn-outline-dark btn-ovr">Overrides</button>
        </td>`;
    } else {
      const staff = row.staff_name ? row.staff_name.trim().replace(/\s+/g,' ') : '';
      tr.innerHTML = `
        <td>${i+1}</td>
        <td>${row.id}</td>
        <td>${escapeHtml(row.ref||'')}</td>
        <td>${escapeHtml(row.username||'')}</td>
        <td>${staff ? escapeHtml(staff) : '<span class="muted">—</span>'}</td>
        <td>
          <button type="button" class="btn btn-sm btn-outline-primary btn-set-roles">Set Roles</button>
          <button type="button" class="btn btn-sm btn-outline-dark btn-ovr">Overrides</button>
        </td>`;
    }
    tbody.appendChild(tr);
  });
}

// search
qs('#personSearch').addEventListener('input', ()=>{
  const v=qs('#personSearch').value.toLowerCase();
  qsa('#personTbody tr').forEach(tr=>{ tr.style.display = tr.innerText.toLowerCase().includes(v) ? '' : 'none'; });
});

// open roles modal
document.addEventListener('click', async (e)=>{
  const btn = e.target.closest('.btn-set-roles'); if(!btn) return;
  const tr = btn.closest('tr'); const who=tr.dataset.who; const ref=tr.dataset.ref; const id=+tr.dataset.id||0;
  qs('#rolesWho').value=who; qs('#rolesRef').value=ref; qs('#rolesId').value=String(id);
  const host = qs('#rolesChecklist'); host.innerHTML='';
  ROLES.forEach(r=>{ const idc='r_'+r.role_id; const wrap=el('label',{class:'role-pill',style:'display:flex;align-items:center;gap:8px;cursor:pointer'});
    wrap.innerHTML=`<input class="role-check" type="checkbox" id="${idc}" value="${r.role_id}"> <span>${escapeHtml(r.name)}</span> <span class="muted">(${escapeHtml(r.code)})</span>`; host.appendChild(wrap); });
  const j=await jget({action:'person_roles_get', who, ref, id});
  (j.role_ids||[]).forEach(idv=>{ const cb=qs('#r_'+idv); if(cb) cb.checked=true; });
  openModal('#rolesModal');
});

// save roles modal
qs('#rolesSaveBtn').onclick = async ()=>{
  const who = qs('#rolesWho').value; const ref = qs('#rolesRef').value; const id = +qs('#rolesId').value||0;
  const role_ids = qsa('#rolesChecklist .role-check').filter(x=>x.checked).map(x=>+x.value);
  await jpost('person_roles_save', {who, ref, id, role_ids});
  closeModal('#rolesModal'); toast('Roles saved');
};

// open overrides modal
document.addEventListener('click', async (e)=>{
  const btn = e.target.closest('.btn-ovr'); if(!btn) return;
  const tr = btn.closest('tr'); const who=tr.dataset.who; const ref=tr.dataset.ref; const id=+tr.dataset.id||0;
  qs('#ovrWho').value=who; qs('#ovrRef').value=ref; qs('#ovrId').value=String(id);

  const tb = qs('#ovrBody'); tb.innerHTML='';
  PERMS.forEach(p=>{ const idp=p.perm_id; const row=el('tr');
    row.innerHTML = `
      <td><div>${escapeHtml(p.label)}</div><div class="muted"><span class="chip">${escapeHtml(p.code)}</span></div></td>
      <td style="text-align:center"><input type="radio" name="tri_${idp}" value="inherit" checked></td>
      <td style="text-align:center"><input type="radio" name="tri_${idp}" value="allow"></td>
      <td style="text-align:center"><input type="radio" name="tri_${idp}" value="deny"></td>`;
    tb.appendChild(row);
  });

  const j = await jget({action:'overrides_get', who, ref, id});
  (j.allow||[]).forEach(idv=>{ const r=qs(`input[name="tri_${idv}"][value="allow"]`); if(r) r.checked=true; });
  (j.deny ||[]).forEach(idv=>{ const r=qs(`input[name="tri_${idv}"][value="deny"]`);  if(r) r.checked=true; });
  openModal('#overridesModal');
});

// save overrides (FIXED selector: removed stray quote)
qs('#ovrSaveBtn').onclick = async ()=>{
  const who = qs('#ovrWho').value; const ref = qs('#ovrRef').value; const id = +qs('#ovrId').value||0;
  const allow=[], deny=[];
  PERMS.forEach(p=>{
    const v=(qs(`input[name="tri_${p.perm_id}"]:checked`)||{}).value;
    if(v==='allow') allow.push(p.perm_id);
    if(v==='deny')  deny.push(p.perm_id);
  });
  await jpost('overrides_save', {who, ref, id, allow, deny});
  closeModal('#overridesModal'); toast('Overrides saved');
};

function escapeHtml(s){ return String(s??'').replace(/[&<>"']/g, m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[m])); }
</script>
</body>
</html>
