<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <title>EZY LEND</title>
  <style>
    /* For the Eye Icon */
    .eye-icon {
      position: absolute;
      top: 10px;
      right: 10px;
      cursor: pointer;
    }

    /* To position the username availability icon */
    .username-icon {
      position: absolute;
      top: 10px;
      right: 10px;
      cursor: pointer;
    }

    .input-container {
      position: relative;
    }
  </style>
</head>
<body>
  <div class="container-scroller">
    <!-- navbar -->
    <?php include '../../partials/navbar.php'; ?>  
    <!-- navbar -->
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- settings -->
      <?php include '../../partials/settings.php'; ?>  
      <!-- settings -->
      <!-- sidebar-->
      <?php include '../../partials/sidebar.php'; ?>   
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body"></div>
            </div>
          </div>

          <div class="col-12 grid-margin">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Update User Details</h4>
                <form class="form-sample" id="newStaffForm" enctype="multipart/form-data">
                  <p class="card-description">Login Details</p>
                  <div class="form-row">
                    <!-- Username Field with icon inside -->
<div class="form-group col-md-6">
  <label for="username">Username</label>
  <div style="position: relative;">
    <input type="text" id="username" name="username" class="form-control" style="padding-right: 30px;" />
    <span id="usernameIcon" style="position: absolute; top: 50%; right: 10px; transform: translateY(-50%); font-size: 18px;"></span>
  </div>
</div>

<!-- Password Field with toggle eye icon inside -->
<div class="form-group col-md-6">
  <label for="password">Password</label>
  <div style="position: relative;">
    <input type="password" id="password" name="password" class="form-control" style="padding-right: 30px;" />
    <span id="eyeIcon" style="position: absolute; top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer; font-size: 18px;">👁️</span>
  </div>
</div>
  </div>


                  <div class="form-row">
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12" style="text-align: right;">
                          <button type="submit" class="btn btn-inverse-primary btn-fw">Update User</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <!-- Response Modal -->
          <div class="modal" id="responseModal">
            <div class="modal-content">
              <div id="responseMsg" class="mt-2"></div>
            </div>
          </div>

        </div>
        <?php include '../../partials/footer.php'; ?>
      </div>   
    </div>     
  </div>

  <?php include '../../partials/loadjs.php'; ?>

  <script>
$(document).ready(function () {
  // Fetch user_id from URL query parameters
  const urlParams = new URLSearchParams(window.location.search);
  const userId = urlParams.get('staff_id');

  if (userId) {
    // Fetch user data
    $.ajax({
      url: 'includes/fetch_user_data.php',
      type: 'GET',
      data: { user_id: userId },
      dataType: 'json',
      success: function (data) {
        if (data.error) {
          showModal(data.error, 'text-danger');
        } else {
          $('#username').val(data.username);
          $('#password').val('');  // Don't pre-fill password hash
        }
      },
      error: function (xhr, status, error) {
        showModal('Error loading user data: ' + error, 'text-danger');
      }
    });
  } else {
    showModal('No user_id provided in the URL', 'text-danger');
  }

  // Form submission
  $('#newStaffForm').submit(function (e) {
    e.preventDefault();

    var isValid = true;
    var errorMessage = '';

    if ($('#username').val().trim() === '') {
      isValid = false;
      errorMessage += 'Username is required.<br>';
    }

    var password = $('#password').val().trim();
    if (password === '') {
      isValid = false;
      errorMessage += 'Password is required.<br>';
    }

    if (!isValid) {
      showModal(errorMessage, 'text-danger');
      return;
    }

    // Prepare data
    var formData = new FormData(this);
    formData.append('user_id', userId);

    // Submit updated user data
    $.ajax({
      url: 'includes/update_user_data.php',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',  // Important: ensures JSON parsing
      success: function (response) {
        console.log(response);
        if (response.success) {
          showModal('User details updated successfully!', 'text-success');
        } else if (response.error === 'No changes detected.') {
          showModal('No changes detected. Please modify the data before updating.', 'text-warning');
        } else {
          showModal('Error updating user details: ' + response.error, 'text-danger');
        }
      },
      error: function (xhr, status, error) {
        showModal('Error updating user details: ' + error, 'text-danger');
      }
    });
  });

  // Show modal
  function showModal(message, type) {
    const modal = document.getElementById('responseModal');
    const responseMsg = document.getElementById('responseMsg');

    responseMsg.innerHTML = message;
    responseMsg.className = type;
    modal.classList.add('show');

    setTimeout(function () {
      closeModal();
    }, 3000);
  }

  // Close modal
  function closeModal() {
    const modal = document.getElementById('responseModal');
    modal.classList.remove('show');
  }

  // Toggle password visibility
  $('#eyeIcon').click(function () {
    const passwordField = $('#password');
    const type = passwordField.attr('type') === 'password' ? 'text' : 'password';
    passwordField.attr('type', type);
  });

  // Check username availability
  $('#username').on('input', function () {
    const username = $(this).val().trim();
    if (username) {
      $.ajax({
        url: 'includes/check_username_availability.php',
        type: 'GET',
        data: { username: username },
        dataType: 'json',
        success: function (data) {
          const usernameIcon = $('#usernameIcon');
          if (data.available) {
            usernameIcon.html('✔️').css('color', 'green');
          } else {
            usernameIcon.html('❌').css('color', 'red');
          }
        },
        error: function () {
          $('#usernameIcon').html('❌').css('color', 'red');
        }
      });
    } else {
      $('#usernameIcon').html('');
    }
  });
});
</script>

</body>
</html>
