<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Flatpickr (beautiful datepicker) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  <!-- Optional theme (looks good with your UI) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">

  <!-- Font Awesome (icons for image edit/remove buttons) -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>

  <style>
    /* Image preview area */
    .image-container{
      position:relative; width:170px; height:170px; margin:auto;
      border-radius:12px; overflow:hidden; background:#f3f4f6; border:1px solid #e5e7eb;
      display:flex; align-items:center; justify-content:center;
    }
    .image-preview{ width:100%; height:100%; object-fit:cover; display:block; }
    .edit-button,.remove-button{
      position:absolute; right:8px; border:none; border-radius:8px; padding:.35rem .5rem; cursor:pointer;
      background:#fff; box-shadow:0 2px 6px rgba(0,0,0,.15);
    }
    .edit-button{ bottom:44px; color:#1f2937; }
    .remove-button{ bottom:8px; color:#b91c1c; }
    .edit-button:hover{ background:#eef2ff; }
    .remove-button:hover{ background:#fee2e2; }

    /* Simple modal */
    .modal{ position:fixed; inset:0; display:none; align-items:center; justify-content:center;
      background:rgba(0, 0, 0, 0); z-index:11000; }
    .modal.show{ display:flex; }
    .modal .modal-content{
      background:#fff; border-radius:10px; padding:16px 18px; max-width:520px; width:calc(100% - 32px);
      box-shadow:0 20px 50px rgba(2,6,23,.25), 0 6px 16px rgba(2,6,23,.15);
    }
  </style>
</head>
<body>
  <div class="container-scroller">
    <!-- navbar -->
    <?php include '../../partials/navbar.php'; ?>  
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>  
      <?php include '../../partials/sidebar.php'; ?>   
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card"><div class="card-body"></div></div>
          </div>

          <div class="col-12 grid-margin">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Update Staff Details</h4>
                <form class="form-sample" id="newStaffForm" enctype="multipart/form-data" autocomplete="off">
                  <p class="card-description">Personal info</p>

                  <div class="form-row">
                    <div class="form-group col-md-5"></div>

                    <div class="form-group col-md-2">
                      <div class="form-row">
                        <!-- Image Container -->
                        <div class="image-container">
                          <!-- Current image -->
                          <img id="currentImage" class="image-preview" src="images/faces/face28.jpg" alt="Staff Image" />
                          <!-- New preview -->
                          <img id="imagePreview" class="image-preview" style="display:none;" alt="Preview" />
                          <!-- Buttons -->
                          <button type="button" id="editImageBtn" class="edit-button">
                            <i class="fas fa-pencil-alt"></i>
                          </button>
                          <button type="button" id="removeImage" class="remove-button" style="display:none;">
                            <i class="fas fa-trash-alt"></i>
                          </button>
                          <!-- File input -->
                          <input type="file" id="img" name="staff_image" accept="image/png,image/jpeg" style="display:none;">
                        </div>
                      </div>
                    </div>

                    <div class="form-group col-md-5"></div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="prefix">Prefix</label>
                      <select id="prefix" class="form-control" name="prefix">
                        <option value="Mr">Mr</option>
                        <option value="Ms">Ms</option>
                        <option value="Mrs">Mrs</option>
                      </select>
                    </div>

                    <div class="form-group col-md-5">
                      <label for="firstName">First Name</label>
                      <input type="text" class="form-control" id="firstName" name="firstName" placeholder="First Name">
                    </div>

                    <div class="form-group col-md-5">
                      <label for="lastName">Last Name</label>
                      <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Last Name">
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="gender">Gender</label>
                      <select class="form-control" id="gender" name="gender">
                        <option value="">Select…</option>
                        <option>Male</option>
                        <option>Female</option>
                        <option>Other</option>
                      </select>
                    </div>

                    <div class="form-group col-md-2">
                      <label for="dob">Date of Birth</label>
                      <input type="text" class="form-control" id="dob" name="dob" placeholder="dd/mm/yyyy" />
                      <small class="text-muted">Must be 18+ years</small>
                    </div>

                    <div class="form-group col-md-4">
                      <label for="mobile">Mobile</label>
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <select class="form-control" style="max-width:180px" id="mobileCountry" name="mobileCountry"></select>
                        </div>
                        <input type="text" class="form-control" id="mobile" name="mobile" placeholder="Mobile number">
                      </div>
                      <small class="text-muted">Digits only</small>
                    </div>

                    <div class="form-group col-md-4">
                      <label for="email">Email</label>
                      <input type="text" class="form-control" id="email" name="email" />
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="role">Role</label>
                      <select class="form-control" id="role" name="role">
                        <option>Admin</option>
                        <option>Support</option>
                      </select>
                    </div>
                  </div>

                  <p class="card-description">Address</p>
                  <div class="form-row">
                    <div class="form-group col-md-3">
                      <label for="apt">Apt No</label>
                      <input type="text" class="form-control" id="apt" name="apt" placeholder="Apt No" />
                    </div>

                    <div class="form-group col-md-9">
                      <label for="address">Address</label>
                      <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address" />
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="form-group col-md-2">
                      <label for="postcode">Postcode</label>
                      <input type="text" class="form-control" id="postcode" name="postcode" />
                    </div>

                    <div class="form-group col-md-3">
                      <label for="country">Country</label>
                      <select class="form-control" id="country" name="country"></select>
                    </div>
                  </div>

                  <div class="form-row">
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12" style="text-align:right;">
                          <button type="submit" class="btn btn-inverse-primary btn-fw">Update Staff</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <!-- Response Modal -->
          <div class="modal" id="responseModal" role="dialog" aria-modal="true">
            <div class="modal-content">
              <div id="responseMsg" class="mt-2"></div>
            </div>
          </div>

        </div>
      </div>   
    </div>
  </div>

  <?php include '../../partials/footer.php'; ?>
  <?php include '../../partials/loadjs.php'; ?>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- Flatpickr -->
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

  <script>
$(document).ready(function () {
  /* ========= DOB datepicker (Flatpickr) ========= */
  const eighteenYearsAgo = new Date();
  eighteenYearsAgo.setFullYear(eighteenYearsAgo.getFullYear() - 18);

  const dobPicker = flatpickr('#dob', {
    dateFormat: 'd/m/Y',
    altInput: false,
    allowInput: true,
    maxDate: eighteenYearsAgo,   // must be 18+
    disableMobile: true
  });

  /* ========= Country + dial codes ========= */
  $.ajax({
    url: 'https://restcountries.com/v3.1/all?fields=name,idd',
    type: 'GET',
    dataType: 'json',
    success: function (data) {
      const countryData = {};
      data.forEach(function (country) {
        if (country.idd && country.idd.root) {
          const countryName = country.name?.common || '';
          const code = country.idd.root + (country.idd.suffixes ? country.idd.suffixes[0] : '');
          if (!countryName || !code) return;

          // store expected lengths (rough heuristic)
          countryData[code] = {
            name: countryName,
            length: (country.idd.root === '+1') ? 10 : 10 // keep 10 default unless you need per-country
          };

          $('#country').append(`<option value="${countryName}">${countryName}</option>`);
          $('#mobileCountry').append(`<option value="${code}">${countryName} (${code})</option>`);
        }
      });

      // Defaults
      $('#country').val('United Kingdom');
      $('#mobileCountry').val('+44');
      updateMobileNumberLength('+44', countryData);

      $('#mobileCountry').on('change', function () {
        updateMobileNumberLength(this.value, countryData);
      });

      function updateMobileNumberLength(code, map) {
        const len = map[code] ? map[code].length : 10;
        $('#mobile').attr('maxlength', len);
      }
    }
  });

  /* ========= Prefill if staff_id in URL ========= */
  const urlParams = new URLSearchParams(window.location.search);
  const staffId = urlParams.get('staff_id');

  if (staffId) {
    $.ajax({
      url: 'includes/get_staff_datas.php',
      type: 'GET',
      data: { staff_id: staffId },
      dataType: 'json'
    }).done(function (data) {
      if (data && !data.error) {
        $('#prefix').val(data.prefix || 'Mr');
        $('#firstName').val(data.first_name || '');
        $('#lastName').val(data.second_name || '');
        $('#gender').val(data.gender || '');
        // handle dob: if "YYYY-MM-DD" set with format; if already "dd/mm/YYYY", set directly
        if (data.dob) {
          if (data.dob.includes('-')) {
            dobPicker.setDate(data.dob, true, 'Y-m-d');
          } else {
            dobPicker.setDate(data.dob, true, 'd/m/Y');
          }
        }
        $('#mobile').val((data.phone_number || '').replace(/\D+/g,''));
        $('#email').val(data.email || '');
        $('#apt').val(data.apt_no || '');
        $('#address').val(data.address || '');
        $('#postcode').val((data.postcode || '').toUpperCase());
        $('#country').val(data.country || 'United Kingdom');
        $('#role').val(data.role || 'Support');

        if (data.staff_image) {
          const imagePath = 'includes/uploads/staff_images/' + data.staff_image;
          $('#currentImage').attr('src', imagePath).show();
        } else {
          $('#currentImage').attr('src', 'images/faces/face28.jpg').show();
        }
      } else {
        showModal(data?.error || 'Error loading staff data', 'text-danger');
      }
    }).fail(function (err) {
      showModal('Error loading staff data', 'text-danger');
    });
  } else {
    showModal('No staff ID provided', 'text-danger');
  }

  /* ========= Mobile: digits only ========= */
  $('#mobile').on('input', function(){ this.value = this.value.replace(/\D+/g,''); });

  /* ========= Image upload UI ========= */
  $('#editImageBtn').on('click', function (e) {
    e.preventDefault();
    $('#img').click();
  });

  $('#img').on('change', function (e) {
    const file = e.target.files[0];
    if (!file) return;
    const valid = ['image/jpeg','image/png','image/jpg'];
    if (!valid.includes(file.type)) {
      showModal('Please upload a valid image (JPG, JPEG, PNG).','text-danger');
      $('#img').val('');
      return;
    }
    if (file.size > 2*1024*1024) {
      showModal('File size exceeds 2MB.','text-danger');
      $('#img').val('');
      return;
    }
    const reader = new FileReader();
    reader.onload = function(ev){
      $('#imagePreview').attr('src', ev.target.result).show();
      $('#currentImage').hide();
      $('#removeImage').show();
    };
    reader.readAsDataURL(file);
  });

  $('#removeImage').on('click', function () {
    $('#img').val('');
    $('#imagePreview').hide();
    $('#currentImage').show();
    $(this).hide();
  });

  /* ========= Validation helpers ========= */
  function parseDMY(str){
    // expects dd/mm/yyyy
    const m = /^(\d{2})\/(\d{2})\/(\d{4})$/.exec(str);
    if (!m) return null;
    const d = parseInt(m[1],10), mo = parseInt(m[2],10)-1, y = parseInt(m[3],10);
    const dt = new Date(y,mo,d);
    if (dt.getFullYear()!==y || dt.getMonth()!==mo || dt.getDate()!==d) return null;
    return dt;
  }
  function isAtLeast18(dt){
    const now = new Date();
    const min = new Date(now.getFullYear()-18, now.getMonth(), now.getDate());
    return dt <= min;
  }

  /* ========= Submit ========= */
  $('#newStaffForm').on('submit', function (e) {
    e.preventDefault();

    let isValid = true;
    let errors = [];

    const firstName = ($('#firstName').val() || '').trim();
    const lastName  = ($('#lastName').val()  || '').trim();
    const gender    = ($('#gender').val()    || '').trim();
    const dobStr    = ($('#dob').val()       || '').trim();
    const mobile    = ($('#mobile').val()    || '').trim();
    const email     = ($('#email').val()     || '').trim();

    if (!firstName) errors.push('First Name is required.');
    if (!lastName)  errors.push('Last Name is required.');
    if (!gender)    errors.push('Gender is required.');

    if (!dobStr) {
      errors.push('Date of Birth is required.');
    } else {
      const d = parseDMY(dobStr);
      if (!d) errors.push('Please enter a valid Date of Birth (dd/mm/yyyy).');
      else if (!isAtLeast18(d)) errors.push('Staff member must be at least 18 years old.');
    }

    if (!mobile) {
      errors.push('Mobile number is required.');
    } else if (!/^[0-9]{7,15}$/.test(mobile)) {
      errors.push('Please enter a valid mobile number (7–15 digits).');
    }

    if (!email) {
      errors.push('Email is required.');
    } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]{2,}$/.test(email)) {
      errors.push('Please enter a valid email address.');
    }

    if (errors.length) {
      showModal(errors.join('<br>'), 'text-danger');
      return;
    }

    // Build form data
    const formData = new FormData(this);
    formData.append('staff_id', staffId || '');
    // Keep dob in dd/mm/yyyy as your backend expects this format

    $.ajax({
      url: 'includes/update_staff_data.php',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json'
    }).done(function (resp) {
      if (resp && resp.success) {
        showModal('Staff details updated successfully!', 'text-success');
      } else {
        showModal('Error updating staff details: ' + (resp?.error || 'Unknown error'), 'text-danger');
      }
    }).fail(function () {
      showModal('Error updating staff details.', 'text-danger');
    });
  });

  /* ========= Modal helpers ========= */
  function showModal(message, type) {
    const modal = document.getElementById('responseModal');
    const responseMsg = document.getElementById('responseMsg');
    responseMsg.innerHTML = message;
    responseMsg.className = type || '';
    modal.classList.add('show');
    setTimeout(closeModal, 3000);
  }
  function closeModal() {
    const modal = document.getElementById('responseModal');
    modal.classList.remove('show');
  }
});
  </script>
</body>
</html>
