<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>

    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-md-12 grid-margin stretch-card">
            <div class="card"><div class="card-body"><!-- spacer --></div></div>
          </div>

          <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Client Details</h4>

                <form class="clientform" id="editCustomerForm" autocomplete="off">
                  <input type="hidden" id="customer_id" name="customer_id">

                  <div class="row">
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="prefix">Prefix</label>
                        <select class="form-control" id="prefix" name="prefix">
                          <option>Mr</option>
                          <option>Ms</option>
                          <option>Mrs</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label for="first_name">First Name</label>
                        <input type="text" class="form-control" id="first_name" name="first_name" placeholder="Tony" required>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label for="second_name">Second Name</label>
                        <input type="text" class="form-control" id="second_name" name="second_name" placeholder="Stark" required>
                      </div>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-4">
                      <div class="form-group">
                        <label for="phone_number">Phone Number</label>
                        <div class="input-group">
                          <span class="input-group-text">+44</span>
                          <input type="text" class="form-control" id="phone_number" name="phone_number" placeholder="123456789">
                        </div>
                        <small class="text-muted">Digits only, 7–15 digits</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="tony@example.com" required>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="dob">Date of Birth</label>
                        <input type="date" class="form-control" id="dob" name="dob">
                        <small class="text-muted">Must be 15+ years</small>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="gender">Gender</label>
                        <select class="form-control" id="gender" name="gender">
                          <option>Male</option>
                          <option>Female</option>
                          <option>Other</option>
                        </select>
                      </div>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-3">
                      <div class="form-group">
                        <label for="martial_status">Marital Status</label>
                        <!-- DB field is "martial_status" (typo kept to match DB) -->
                        <select class="form-control" id="martial_status" name="martial_status">
                          <option>Single</option>
                          <option>Married</option>
                          <option>Divorced</option>
                          <option>Widowed</option>
                          <option>Other</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="apt_no">Apt No.</label>
                        <input type="text" class="form-control" id="apt_no" name="apt_no" placeholder="Apt. 2003">
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label for="address_line1">Address</label>
                        <input type="text" class="form-control" id="address_line1" name="address_line1" placeholder="Caroline St">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="postcode">Postcode</label>
                        <input type="text" class="form-control" id="postcode" name="postcode" placeholder="CF10 1AF">
                      </div>
                    </div>
                  </div>

                  <div class="mt-4">
                    <button type="submit" class="btn btn-primary me-2" id="saveBtn">Update</button>
                    <a href="alllenddetails.php" class="btn btn-light">Back</a>
                  </div>
                </form>

              </div>
            </div>
          </div>

          <?php include '../../partials/footer.php'; ?>
        </div>
      </div>
    </div>
  </div>

  <?php include '../../partials/loadjs.php'; ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <script>
    // Set DOB max to (today - 15 years)
    (function(){
      const dobEl = document.getElementById('dob');
      if (!dobEl) return;
      const today = new Date();
      const minDate = new Date(today.getFullYear() - 15, today.getMonth(), today.getDate());
      dobEl.max = minDate.toISOString().split('T')[0];
    })();
  </script>

  <script>
  $(function () {
    // Helpers
    const trimVal = (sel) => $.trim($(sel).val() || '');
    const setDisabled = (sel, v) => $(sel).prop('disabled', !!v);

    // Phone: digits only
    $('#phone_number').on('input', function(){
      this.value = this.value.replace(/\D+/g,'');
    });

    // Uppercase postcode on blur
    $('#postcode').on('blur', function(){ this.value = this.value.toUpperCase(); });

    // Load existing details
    const params = new URLSearchParams(window.location.search);
    const id = params.get('id');

    if (!id) {
      Swal.fire('Error', 'No Customer ID provided.', 'error');
      return;
    }

    $.ajax({
      url: `api/get_customer.php?id=${encodeURIComponent(id)}`,
      method: 'GET',
      dataType: 'json'
    }).done(function(data){
      if (data && !data.error) {
        $('#customer_id').val(data.customer_id);
        $('#prefix').val(data.prefix || 'Mr');
        $('#first_name').val(data.first_name || '');
        $('#second_name').val(data.second_name || '');
        $('#phone_number').val((data.phone_number || '').replace(/\D+/g,''));
        $('#email').val(data.email || '');
        $('#gender').val(data.gender || 'Male');
        $('#martial_status').val(data.martial_status || 'Single'); // DB key "martial_status"
        $('#dob').val(data.dob || '');
        $('#apt_no').val(data.apt_no || '');
        $('#address_line1').val(data.address_line1 || '');
        $('#postcode').val((data.postcode || '').toUpperCase());
      } else {
        Swal.fire('Error', (data && data.error) ? data.error : 'Could not fetch customer details.', 'error');
      }
    }).fail(function(){
      Swal.fire('Error', 'Could not fetch customer details.', 'error');
    });

    // Client-side validation
    function validateForm(){
      const errs = [];

      const firstName = trimVal('#first_name');
      const secondName = trimVal('#second_name');
      const email = trimVal('#email');
      const phone = trimVal('#phone_number');
      const dob = trimVal('#dob');
      const gender = trimVal('#gender');
      const mstat = trimVal('#martial_status');

      if (!firstName) errs.push('First name is required.');
      if (!secondName) errs.push('Second name is required.');

      if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
        errs.push('Invalid email address.');
      }

      if (phone) {
        if (phone.length < 7 || phone.length > 15) {
          errs.push('Phone number must contain 7–15 digits.');
        }
      }

      if (dob) {
        const d = new Date(dob + 'T00:00:00');
        const today = new Date();
        const min = new Date(today.getFullYear() - 15, today.getMonth(), today.getDate());
        if (isNaN(d.getTime())) errs.push('DOB must be a valid date (YYYY-MM-DD).');
        else if (d > min) errs.push('Customer must be at least 15 years old.');
      }

      // sanity for enumerations
      const genders = ['Male','Female','Other'];
      if (gender && !genders.includes(gender)) {
        errs.push('Invalid gender.');
      }
      const statuses = ['Single','Married','Divorced','Widowed','Other'];
      if (mstat && !statuses.includes(mstat)) {
        errs.push('Invalid marital status.');
      }

      return errs;
    }

    // Submit
    $('#editCustomerForm').on('submit', function(e){
      e.preventDefault();

      const errors = validateForm();
      if (errors.length) {
        Swal.fire('Please fix the following', errors.join('<br>'), 'warning');
        return;
      }

      const payload = {
        customer_id: $('#customer_id').val(),
        prefix: $('#prefix').val(),
        first_name: trimVal('#first_name'),
        second_name: trimVal('#second_name'),
        phone_number: trimVal('#phone_number'),
        email: trimVal('#email'),
        gender: $('#gender').val(),
        martial_status: $('#martial_status').val(), // DB column name kept as-is
        dob: trimVal('#dob'),
        apt_no: trimVal('#apt_no'),
        address_line1: trimVal('#address_line1'),
        postcode: trimVal('#postcode').toUpperCase()
      };

      Swal.fire({
        title: 'Are you sure?',
        text: 'Do you want to save these changes?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, update it!'
      }).then((res)=>{
        if (!res.isConfirmed) return;

        setDisabled('#saveBtn', true);

        $.ajax({
          url: 'api/update_customer.php',
          method: 'POST',
          dataType: 'json',
          contentType: 'application/json',
          data: JSON.stringify(payload)
        }).done(function(resp){
          if (resp && resp.status === 'success') {
            Swal.fire('Updated!', resp.message || 'Customer updated.', 'success');
          } else {
            Swal.fire('Error', (resp && resp.message) ? resp.message : 'Update failed.', 'error');
          }
        }).fail(function(xhr){
          let msg = 'An unknown error occurred while updating.';
          try {
            const j = JSON.parse(xhr.responseText);
            if (j && j.message) msg = j.message;
          } catch(e){}
          Swal.fire('Error', msg, 'error');
        }).always(function(){
          setDisabled('#saveBtn', false);
        });
      });
    });
  });
  </script>
</body>
</html>
