<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8"><title>EZY LEND</title>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    .file-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(180px,1fr));gap:.75rem}
    .file-card{position:relative;border:1px solid #e5e7eb;border-radius:.5rem;padding:.5rem;background:#fff;cursor:pointer}
    .file-card img{max-width:100%;height:120px;object-fit:cover;border-radius:.25rem}
    .file-name{font-size:.85rem;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
    .muted{color:#6b7280;font-size:.8rem}
    .badge-new{position:absolute;top:.35rem;left:.35rem;background:#16a34a;color:#fff;font-size:.72rem;padding:.15rem .4rem;border-radius:.35rem}
    .chip{display:inline-flex;align-items:center;gap:.35rem;border-radius:999px;padding:.15rem .5rem;font-size:.72rem;border:1px solid #e5e7eb}
    .chip.ver{background:#ecfdf5;border-color:#a7f3d0}
    .chip.nver{background:#fff7ed;border-color:#fed7aa}
    .chip.rej{background:#fef2f2;border-color:#fecaca}
    .chip.exp{background:#fde68a;border-color:#fcd34d}
    .toolbar{position:absolute;top:.35rem;right:.35rem;display:flex;gap:.35rem}
    .btn-icon{border:1px solid #e5e7eb;background:#fff;border-radius:.35rem;cursor:pointer;padding:.25rem}
    .btn-icon[disabled]{opacity:.5;cursor:not-allowed}
    .btn-icon:hover{background:#f9fafb}
    .older-link{font-size:.85rem;color:#2563eb;cursor:pointer;text-decoration:underline}
    .older-link[hidden]{display:none!important}
    .section-block{border-top:1px dashed #e5e7eb;margin-top:.75rem;padding-top:.75rem}
    .section-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:.5rem}
    .section-title{font-weight:600;font-size:.95rem}
    .live-del{position:absolute;top:.25rem;right:.25rem;background:#fff;border:1px solid #e5e7eb;border-radius:.35rem;padding:.1rem .3rem;cursor:pointer}
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <!-- Header summary -->
          <div class="col-md-6 grid-margin stretch-card">
            <div class="card"><div class="card-body">
              <div class="row">
                <div class="form-group col-md-4">
                  <label for="clientnumber">Client Name</label>
                  <input type="text" class="form-control" id="clientnumber" disabled>
                </div>
                <div class="form-group col-md-4">
                  <label for="accapplicationnumbernumber">Application Number</label>
                  <input type="text" class="form-control" id="accapplicationnumbernumber" disabled>
                </div>
                <div class="form-group col-md-4">
                  <label for="lendingtype">Lending Type</label>
                  <input type="text" class="form-control" id="lendingtype" disabled>
                </div>
              </div>
            </div></div>
          </div>

          <!-- Row A -->
          <div class="row">
            <!-- Verify Documents -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card"><div class="card-body">
                <h4 class="card-title">Verify Documents</h4>
                <p class="card-description">Upload the Documents</p>

                <form id="formVerifyDocs" enctype="multipart/form-data">
                  <div class="form-group">
                    <label for="personal_id">Personal Identification</label>
                    <input type="file" class="form-control js-guard" data-doc="personal_id" name="personal_id" id="personal_id" accept=".jpg,.jpeg,.png,.pdf">
                    <div id="livePrev_personal_id" class="muted mt-1"></div>
                    <div class="muted" id="hint_personal_id"></div>
                  </div>
                  <div class="form-group">
                    <label for="residence_proof">Residence Proof</label>
                    <input type="file" class="form-control js-guard" data-doc="residence_proof" name="residence_proof" id="residence_proof" accept=".jpg,.jpeg,.png,.pdf">
                    <div id="livePrev_residence_proof" class="muted mt-1"></div>
                    <div class="muted" id="hint_residence_proof"></div>
                  </div>
                  <button type="submit" class="btn btn-primary mr-2">Submit</button>
                  <button type="button" class="btn btn-light" id="cancelVerifyDocs">Cancel</button>
                </form>

                <!-- Personal ID -->
                <div class="section-block">
                  <div class="section-header">
                    <div class="section-title">Personal Identification</div>
                    <div id="btnOlderPI" class="older-link" hidden>Older uploads</div>
                  </div>
                  <div id="verifyLatestPI" class="file-grid"></div>
                </div>

                <!-- Residence Proof -->
                <div class="section-block">
                  <div class="section-header">
                    <div class="section-title">Residence Proof</div>
                    <div id="btnOlderRP" class="older-link" hidden>Older uploads</div>
                  </div>
                  <div id="verifyLatestRP" class="file-grid"></div>
                </div>
              </div></div>
            </div>

            <!-- Bank Information -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card"><div class="card-body">
                <h4 class="card-title">Bank Information</h4>
                <form id="formBank" autocomplete="off">
                  <div class="row">
                    <div class="form-group col-md-6">
                      <label for="nameasinank">Name as in Bank</label>
                      <input type="text" class="form-control" id="nameasinank" name="account_holder_name">
                    </div>
                    <div class="form-group col-md-6">
                      <label for="bank_name">Select Your Bank</label>
                      <select class="form-control" id="bank_name" name="bank_name">
                        <option value="">Select Your Bank</option>
                        <option>Barclays</option><option>HSBC</option><option>Lloyds Bank</option><option>Royal Bank of Scotland</option>
                      </select>
                    </div>
                  </div>
                  <div class="row">
                    <div class="form-group col-md-6">
                      <label for="accnumber">Account Number</label>
                      <input type="text" class="form-control" id="accnumber" name="account_number">
                    </div>
                    <div class="form-group col-md-3">
                      <label for="sortcode">Sort Code</label>
                      <input type="text" class="form-control" id="sortcode" name="sort_code" placeholder="12-34-56">
                    </div>
                    <div class="form-group col-md-3">
                      <label for="swift_bic">SWIFT/BIC</label>
                      <input type="text" class="form-control" id="swift_bic" name="swift_bic" placeholder="HBUKGB41XXX">
                    </div>
                  </div>
                  <button type="submit" class="btn btn-primary mr-2">Submit</button>
                  <button type="button" class="btn btn-light" id="cancelBank">Cancel</button>
                </form>
              </div></div>
            </div>
          </div>

          <!-- Row B -->
          <div class="row">
            <!-- Land Docs -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card"><div class="card-body">
                <h4 class="card-title">Land Related Documents</h4>
                <p class="card-description">Upload the Documents</p>
                <form id="formLand" enctype="multipart/form-data">
                  <div class="form-group">
                    <label for="land_doc1">Land Identification</label>
                    <input type="file" class="form-control js-guard" data-doc="land_doc1" name="land_doc1" id="land_doc1" accept=".jpg,.jpeg,.png,.pdf">
                    <div id="livePrev_land_doc1" class="muted mt-1"></div>
                    <div class="muted" id="hint_land_doc1"></div>
                  </div>
                  <div class="form-group">
                    <label for="land_doc2">Land Proof</label>
                    <input type="file" class="form-control js-guard" data-doc="land_doc2" name="land_doc2" id="land_doc2" accept=".jpg,.jpeg,.png,.pdf">
                    <div id="livePrev_land_doc2" class="muted mt-1"></div>
                    <div class="muted" id="hint_land_doc2"></div>
                  </div>
                  <div class="form-group">
                    <label for="land_doc3">Additional Land Document</label>
                    <input type="file" class="form-control js-guard" data-doc="land_doc3" name="land_doc3" id="land_doc3" accept=".jpg,.jpeg,.png,.pdf">
                    <div id="livePrev_land_doc3" class="muted mt-1"></div>
                    <div class="muted" id="hint_land_doc3"></div>
                  </div>
                  <button type="submit" class="btn btn-primary mr-2">Submit</button>
                  <button type="button" class="btn btn-light" id="cancelLand">Cancel</button>
                </form>

                <!-- Land categories -->
                <div class="section-block">
                  <div class="section-header">
                    <div class="section-title">Land Identification</div>
                    <div id="btnOlderLand1" class="older-link" hidden>Older uploads</div>
                  </div>
                  <div id="landLatest1" class="file-grid"></div>
                </div>
                <div class="section-block">
                  <div class="section-header">
                    <div class="section-title">Land Proof</div>
                    <div id="btnOlderLand2" class="older-link" hidden>Older uploads</div>
                  </div>
                  <div id="landLatest2" class="file-grid"></div>
                </div>
                <div class="section-block">
                  <div class="section-header">
                    <div class="section-title">Additional Land Document</div>
                    <div id="btnOlderLand3" class="older-link" hidden>Older uploads</div>
                  </div>
                  <div id="landLatest3" class="file-grid"></div>
                </div>
              </div></div>
            </div>

            <!-- Business Docs -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card"><div class="card-body">
                <h4 class="card-title">Business Related Documents</h4>
                <p class="card-description">Upload the Documents</p>
                <form id="formBusiness" enctype="multipart/form-data">
                  <?php for($i=1;$i<=5;$i++): ?>
                    <div class="form-group">
                      <label for="biz_doc<?=$i?>">Document <?=$i?></label>
                      <input type="file" class="form-control js-guard" data-doc="biz_doc<?=$i?>" name="biz_doc<?=$i?>" id="biz_doc<?=$i?>" accept=".jpg,.jpeg,.png,.pdf">
                      <div id="livePrev_biz_doc<?=$i?>" class="muted mt-1"></div>
                      <div class="muted" id="hint_biz_doc<?=$i?>"></div>
                    </div>
                  <?php endfor; ?>
                  <button type="submit" class="btn btn-primary mr-2">Submit</button>
                  <button type="button" class="btn btn-light" id="cancelBusiness">Cancel</button>
                </form>

                <!-- Business categories -->
                <?php for($i=1;$i<=5;$i++): ?>
                  <div class="section-block">
                    <div class="section-header">
                      <div class="section-title">Business Document <?=$i?></div>
                      <div id="btnOlderBiz<?=$i?>" class="older-link" hidden>Older uploads</div>
                    </div>
                    <div id="bizLatest<?=$i?>" class="file-grid"></div>
                  </div>
                <?php endfor; ?>
              </div></div>
            </div>
          </div>

        </div>
        <?php include '../../partials/footer.php'; ?>
      </div>
    </div>
  </div>

  <?php include '../../partials/loadjs.php'; ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>const APP_BASE = "<?= rtrim(dirname($_SERVER['SCRIPT_NAME']),'/') ?>/";</script>

  <script>
  (function(){
    const params = new URLSearchParams(window.location.search);
    const applicationId = params.get('application_id'); // can be numeric or EZYxxxx
    if(!applicationId){ Swal.fire('Error','Missing application_id in URL','error'); return; }

    let customerId = null;
    const ACCEPT_EXT = ['jpg','jpeg','png','pdf'];
    const ACCEPT_MIME = ['image/jpeg','image/png','application/pdf'];

    const olderCache = {
      verify_pi: [], verify_rp: [],
      land_doc1: [], land_doc2: [], land_doc3: [],
      biz_doc1: [], biz_doc2: [], biz_doc3: [], biz_doc4: [], biz_doc5: []
    };

    const toGB = (d)=> new Date((d||'').replace(' ','T')).toLocaleString('en-GB');
    const toGBdate = (d)=> new Date((d||'').replace(' ','T')).toLocaleDateString('en-GB',{day:'2-digit',month:'short',year:'numeric'});
    const extOf = (n)=>{ const i=n.lastIndexOf('.'); return i>=0 ? n.slice(i+1).toLowerCase() : ''; };
    const isExpired = (exp)=> exp ? (new Date(exp) < new Date()) : false;

    function hrefFromItem(it){
      const rel = (it.file_path||'').replace(/^\/+/, '');
      return APP_BASE + rel;
    }

    // chips
    function statusChips(it){
      const s = Number(it.verified);
      const exp = it.expires_at || null;
      const expired = isExpired(exp) || s===3;
      let label='⏳ Not verified', cls='nver';
      if (s===1) { label='✅ Verified'; cls='ver'; }
      else if (s===2) { label='❌ Rejected'; cls='rej'; }
      else if (expired) { label='⏳ Expired'; cls='exp'; }
      const chips = [`<span class="chip ${cls}">${label}</span>`];
      if(exp){ chips.push(`<span class="chip ${expired?'exp':''}">${expired?'⚠️ Expired':'📅 Expires'}: ${toGBdate(exp)}</span>`); }
      return chips.join(' ');
    }

    function toolbarHTML(it){
      const s = Number(it.verified);
      const fill = s===1 ? '#10b981' : s===2 ? '#ef4444' : (s===3 ? '#f59e0b' : 'none');
      const locked = s===1 || s===2 || s===3;
      return `
        <div class="toolbar">
          <button class="btn-icon js-set-status" ${locked?'disabled':''} title="${locked?'Locked':''}" data-id="${it.id}" data-current="${s}">
            <svg width="18" height="18" viewBox="0 0 24 24" fill="${fill}" stroke="#111827" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
              <path d="M12 2l7 4v6c0 5-3.5 9-7 10-3.5-1-7-5-7-10V6l7-4z"/>
              <path d="M9 12l2 2 4-4"></path>
            </svg>
          </button>
        </div>`;
    }

    // CARD — add data-href and data-kind for popup (image/pdf)
    function cardHTML(it, badge=false){
      const isImg = (it.mime_type||'').startsWith('image/') || /\.(png|jpe?g)$/i.test(it.file_path||'');
      const isPdf = (it.mime_type||'')==='application/pdf' || /\.pdf$/i.test(it.file_path||'');
      const href  = hrefFromItem(it);
      const name  = (it.original_name||it.file_path||'').split('/').pop();
      const uploaded = toGB(it.uploaded_at);
      const newBadge = badge ? `<span class="badge-new">Newly updated</span>` : '';
      const expired = isExpired(it.expires_at) || Number(it.verified)===3;
      const kind = isPdf ? 'pdf' : (isImg ? 'image' : 'file');

      return `
        <div class="file-card" data-id="${it.id}" data-href="${href}" data-kind="${kind}" data-name="${name}" data-date="${uploaded}">
          ${newBadge}${toolbarHTML(it)}
          ${isImg ? `<img src="${href}" alt="${name}">` : `<div class="muted">${isPdf?'PDF':'File'}</div>`}
          <div class="file-name" title="${name}">${name}</div>
          <div class="muted">Uploaded: ${uploaded}</div>
          <div class="mt-1">${statusChips(it)}</div>
          ${expired ? `<div class="muted" style="color:#b45309">You can re-upload (expired)</div>` : ''}
          ${isPdf ? `<div class="muted" style="font-size:.75rem">Click card to preview PDF</div>` : ''}
        </div>`;
    }

    // subtype detectors
    function landSubcat(it){
      const n = (it.file_path || it.original_name || '').split('/').pop().toLowerCase();
      if (/(^|[_/])land_doc1_/.test(n)) return 'land_doc1';
      if (/(^|[_/])land_doc2_/.test(n)) return 'land_doc2';
      if (/(^|[_/])land_doc3_/.test(n)) return 'land_doc3';
      return null;
    }
    function bizSubcat(it){
      const n = (it.file_path || it.original_name || '').split('/').pop().toLowerCase();
      for (let i=1;i<=5;i++){ if (new RegExp(`(^|[_/])biz_doc${i}_`).test(n)) return `biz_doc${i}`; }
      return null;
    }

    // UK bank validation
    function validateUKBankFields() {
      const holder=$('#nameasinank').val().trim();
      const bank=$('#bank_name').val().trim();
      const acc=$('#accnumber').val().replace(/\s+/g,'');
      const sort=$('#sortcode').val().replace(/[^0-9]/g,'');
      const bic=$('#swift_bic').val().trim().toUpperCase();
      const errs=[];
      if(!holder||holder.length<2) errs.push('Account holder name is required.');
      if(!bank) errs.push('Bank name is required.');
      if(!/^\d{6}$/.test(sort)) errs.push('Sort code must be 6 digits (e.g. 123456).');
      if(!/^\d{8}$/.test(acc)) errs.push('Account number must be 8 digits.');
      if(bic){
        if(!/^[A-Z0-9]{8}([A-Z0-9]{3})?$/.test(bic)) errs.push('SWIFT/BIC must be 8 or 11 chars.');
        if(!/^([A-Z]{4})GB([A-Z0-9]{2})([A-Z0-9]{3})?$/.test(bic)) errs.push('SWIFT/BIC should be a UK code (..GB..).');
      }
      if(errs.length){ Swal.fire('Fix fields', errs.join('<br>'),'warning'); return null; }
      return {holder,bank,acc,sort,bic};
    }

    // bank submit
    $('#formBank').on('submit', function(e){
      e.preventDefault();
      if(!customerId||!applicationId){ Swal.fire('Error','Missing IDs. Reload the page.','error'); return; }
      const ok=validateUKBankFields(); if(!ok) return;
      const body={
        application_id:applicationId, customer_id:customerId,
        account_holder_name:ok.holder, bank_name:ok.bank, account_number:ok.acc,
        sort_code:ok.sort, swift_bic:ok.bic
      };
      fetch('api/save_bank_details.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify(body)})
        .then(r=>r.json()).then(r=>{
          if(r.status==='success') Swal.fire('Saved',r.message||'Bank info updated','success');
          else Swal.fire('Error', r.message||'Update failed','error');
        }).catch(()=>Swal.fire('Error','Update failed','error'));
    });

    // live preview + delete
    function attachLivePreview(inputId){
      const inp=document.getElementById(inputId);
      const box=document.getElementById('livePrev_'+inputId);
      if(!inp||!box) return;
      function clearSel(){ inp.value=''; box.innerHTML=''; }
      inp.addEventListener('change', ()=>{
        box.innerHTML='';
        const f=inp.files&&inp.files[0]; if(!f) return;
        const okExt=['jpg','jpeg','png','pdf']; const okMime=['image/jpeg','image/png','application/pdf',''];
        const ext=(f.name.split('.').pop()||'').toLowerCase();
        if(!(okExt.includes(ext)&&(okMime.includes(f.type||'')))){
          Swal.fire('Invalid file','Only JPG/PNG/PDF allowed','warning'); clearSel(); return;
        }
        const isImg=(f.type||'').startsWith('image/');
        const preview=isImg?`<img src="${URL.createObjectURL(f)}">`:`<div class="muted">${f.name}</div>`;
        box.innerHTML=`<div class="file-card" style="position:relative">
          <div class="live-del" title="Remove" data-for="${inputId}">×</div>
          ${preview}
          <div class="file-name">${f.name}</div>
          <div class="muted">Pending upload</div>
        </div>`;
      });
      document.addEventListener('click',(e)=>{
        const del=e.target.closest('.live-del');
        if(del&&del.getAttribute('data-for')===inputId){ clearSel(); }
      });
    }
    ['personal_id','residence_proof','land_doc1','land_doc2','land_doc3','biz_doc1','biz_doc2','biz_doc3','biz_doc4','biz_doc5'].forEach(attachLivePreview);

    // Older uploads popups
    function showOlderPopup(title, items){
      const html = items && items.length
        ? `<div class="file-grid" style="margin-top:.25rem">${items.map(it=>cardHTML(it,false)).join('')}</div>`
        : `<div class="muted">No older uploads</div>`;
      Swal.fire({ title, html, width: 1000, showCloseButton: true, showConfirmButton: false, padding: '0 0 1rem' });
    }
    function bindOlder(id, title, key){
      const el=document.getElementById(id); if(!el) return;
      el.addEventListener('click', ()=>showOlderPopup(title, olderCache[key]));
    }
    bindOlder('btnOlderPI','Older Personal Identification','verify_pi');
    bindOlder('btnOlderRP','Older Residence Proof','verify_rp');
    bindOlder('btnOlderLand1','Older Land Identification','land_doc1');
    bindOlder('btnOlderLand2','Older Land Proof','land_doc2');
    bindOlder('btnOlderLand3','Older Additional Land Document','land_doc3');
    for(let i=1;i<=5;i++) bindOlder('btnOlderBiz'+i,'Older Business Document '+i,'biz_doc'+i);

    // Renderers
    function renderVerifyGrouped(items){
      const pi=items.filter(x=>x.doc_type==='personal_id').sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at));
      const rp=items.filter(x=>x.doc_type==='residence_proof').sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at));
      document.getElementById('verifyLatestPI').innerHTML = pi.length ? cardHTML(pi[0], true) : `<div class="muted">No file yet</div>`;
      olderCache.verify_pi = pi.slice(1);
      const btnPI=document.getElementById('btnOlderPI'); btnPI.hidden=!olderCache.verify_pi.length; if(!btnPI.hidden) btnPI.textContent=`Older uploads (${olderCache.verify_pi.length})`;
      document.getElementById('verifyLatestRP').innerHTML = rp.length ? cardHTML(rp[0], true) : `<div class="muted">No file yet</div>`;
      olderCache.verify_rp = rp.slice(1);
      const btnRP=document.getElementById('btnOlderRP'); btnRP.hidden=!olderCache.verify_rp.length; if(!btnRP.hidden) btnRP.textContent=`Older uploads (${olderCache.verify_rp.length})`;
      guardInput('personal_id', pi[0]);
      guardInput('residence_proof', rp[0]);
    }

    function renderTyped(latestId, btnId, cacheKey, items){
      const arr=(items||[]).slice().sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at));
      document.getElementById(latestId).innerHTML = arr.length ? cardHTML(arr[0], true) : `<div class="muted">No file yet</div>`;
      olderCache[cacheKey]=arr.slice(1);
      const btn=document.getElementById(btnId); btn.hidden=!olderCache[cacheKey].length; if(!btn.hidden) btn.textContent=`Older uploads (${olderCache[cacheKey].length})`;
    }

    function guardInput(inputId, latest){
      const inp=document.getElementById(inputId);
      const hint=document.getElementById('hint_'+inputId);
      if(!inp||!hint) return;
      let allowed=true, msg='';
      if(latest){
        const v=Number(latest.verified);
        const expired=isExpired(latest.expires_at)||v===3;
        if(v===0){ allowed=false; msg='Latest is pending review. Upload disabled.'; }
        else if(v===1 && !expired){ allowed=false; msg='Already verified. Re-upload after expiry only.'; }
        else if(v===2 || expired){ allowed=true; msg='You may upload a new file (rejected/expired).'; }
      }
      inp.disabled=!allowed; hint.textContent=msg;
      if(!allowed){ document.getElementById('livePrev_'+inputId).innerHTML=''; inp.value=''; }
    }

    // Header + load
    fetch('api/get_header_info.php?application_id=' + encodeURIComponent(applicationId))
      .then(r=>r.json()).then(res=>{
        if(res.error){ Swal.fire('Error', res.error, 'error'); return; }
        customerId=res.customer_id;
        $('#clientnumber').val(res.client_name||'');
        $('#accapplicationnumbernumber').val(res.application_ref_id||'');
        $('#lendingtype').val(res.loan_type||'');
        if(res.bank){
          $('#nameasinank').val(res.bank.account_holder_name||'');
          $('#bank_name').val(res.bank.bank_name||'');
          $('#accnumber').val(res.bank.account_number||'');
          $('#sortcode').val(res.bank.sort_code||'');
          $('#swift_bic').val(res.bank.swift_bic||'');
        }
        loadPreviews();
      }).catch(()=>Swal.fire('Error','Failed loading header info','error'));

    function loadPreviews(){
      if(!customerId) return;
      fetch(`api/list_documents.php?customer_id=${encodeURIComponent(customerId)}&application_id=${encodeURIComponent(applicationId)}`)
        .then(r=>r.json()).then(r=>{
          if(r.error){ console.error(r.error); return; }

          const verify=r.items.filter(x=>x.doc_type==='personal_id'||x.doc_type==='residence_proof');
          renderVerifyGrouped(verify);

          const landAll=r.items.filter(x=>x.doc_type==='land');
          renderTyped('landLatest1','btnOlderLand1','land_doc1', landAll.filter(it=>landSubcat(it)==='land_doc1'));
          renderTyped('landLatest2','btnOlderLand2','land_doc2', landAll.filter(it=>landSubcat(it)==='land_doc2'));
          renderTyped('landLatest3','btnOlderLand3','land_doc3', landAll.filter(it=>landSubcat(it)==='land_doc3'));
          const land1=landAll.filter(it=>landSubcat(it)==='land_doc1').sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at))[0];
          const land2=landAll.filter(it=>landSubcat(it)==='land_doc2').sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at))[0];
          const land3=landAll.filter(it=>landSubcat(it)==='land_doc3').sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at))[0];
          guardInput('land_doc1', land1); guardInput('land_doc2', land2); guardInput('land_doc3', land3);

          const bizAll=r.items.filter(x=>x.doc_type==='business');
          for(let i=1;i<=5;i++){
            const arr=bizAll.filter(it=>bizSubcat(it)===('biz_doc'+i));
            renderTyped('bizLatest'+i,'btnOlderBiz'+i,'biz_doc'+i, arr);
            const latest=arr.slice().sort((a,b)=>new Date(b.uploaded_at)-new Date(a.uploaded_at))[0];
            guardInput('biz_doc'+i, latest);
          }
        }).catch(console.error);
    }

    // Status change (immutable once set)
    document.addEventListener('click', async (e)=>{
      const btn=e.target.closest('.js-set-status');
      if(!btn) return;

      const id=Number(btn.getAttribute('data-id'));
      const current=Number(btn.getAttribute('data-current'))||0;

      if(current===1 || current===2 || current===3){
        Swal.fire('Locked','Status can’t be changed once set.','info');
        return;
      }

      const { value: action } = await Swal.fire({
        title:'Set document status',
        input:'select',
        inputOptions: { verify: '✅ Verify (sets expiry +6 months)', reject: '❌ Reject' },
        inputPlaceholder:'Choose…', showCancelButton:true, confirmButtonText:'Continue'
      });
      if(!action) return;

      if(action==='verify'){
        const ok=await Swal.fire({icon:'question',title:'Verify this document?',text:'This action is permanent.',showCancelButton:true,confirmButtonText:'Verify'});
        if(!ok.isConfirmed) return;
        fetch('api/toggle_doc_status.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({ id, verified:1 })})
          .then(r=>r.json()).then(resp=>{ if(resp.status==='success'){ loadPreviews(); } else { Swal.fire('Error', resp.message||'Update failed','error'); }})
          .catch(()=>Swal.fire('Error','Update failed','error'));
        return;
      }

      if(action==='reject'){
        const reasonHtml = `
          <div style="text-align:left">
            <label class="muted" style="font-size:.85rem">Reason</label>
            <select id="rejSel" class="swal2-input" style="width:100%;box-sizing:border-box">
              <option value="">Select a reason…</option>
              <option>Document unreadable</option>
              <option>Mismatched name</option>
              <option>Expired/invalid date</option>
              <option>Incorrect document type</option>
              <option>Suspected tampering</option>
              <option>Incomplete pages</option>
              <option>Address mismatch</option>
              <option value="__OTHER__">Other</option>
            </select>
            <textarea id="rejTxt" class="swal2-textarea" placeholder="Type custom reason…" style="display:none;height:110px"></textarea>
          </div>`;
        await Swal.fire({
          title:'Reject document', html:reasonHtml, focusConfirm:false, showCancelButton:true,
          preConfirm:()=>{
            const sel = (document.getElementById('rejSel')||{}).value || '';
            const txt = (document.getElementById('rejTxt')||{}).value || '';
            const val = (sel==='__OTHER__') ? txt.trim() : sel.trim();
            if(!val) { Swal.showValidationMessage('Please choose or type a reason.'); return false; }
            return val;
          },
          didOpen:()=>{
            const sel=document.getElementById('rejSel');
            const txt=document.getElementById('rejTxt');
            sel.addEventListener('change', ()=>{ if(sel.value==='__OTHER__'){ txt.style.display='block'; txt.focus(); } else { txt.style.display='none'; txt.value=''; }});
          }
        }).then(out=>{
          if(!out.isConfirmed) return;
          const reason = out.value;
          fetch('api/toggle_doc_status.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({ id, verified:2, reason })})
            .then(r=>r.json()).then(resp=>{ if(resp.status==='success'){ loadPreviews(); } else { Swal.fire('Error', resp.message||'Update failed','error'); }})
            .catch(()=>Swal.fire('Error','Update failed','error'));
        });
      }
    });

    // Popup preview for BOTH images & PDFs
    document.addEventListener('click', (e)=>{
      const card = e.target.closest('.file-card');
      if(!card) return;
      // ignore clicks on toolbar buttons
      if(e.target.closest('.btn-icon') || e.target.closest('.live-del') || e.target.closest('a')) return;

      const href = card.getAttribute('data-href');
      const kind = card.getAttribute('data-kind') || 'file';
      const name = card.getAttribute('data-name') || 'File';
      const date = card.getAttribute('data-date') || '';

      let html = `<div class="muted" style="margin-top:.5rem">Uploaded: ${date}</div>`;
      if(kind==='image'){
        html += `<img src="${href}" alt="${name}" style="max-width:100%;margin-top:.75rem;border-radius:.35rem">`;
      } else if(kind==='pdf'){
        html += `<div style="margin-top:.75rem;height:75vh"><iframe src="${href}" style="width:1000px;height:100%;border:0;"></iframe></div>`;
      } else {
        html += `<div class="muted" style="margin-top:.75rem">Preview not available. <a href="${href}" target="_blank">Open</a></div>`;
      }

      Swal.fire({ title: name, html, showConfirmButton:false, showCloseButton:true, width: 1000, padding:'0 0 1rem' });
    });

    // SUBMITS
    function basicValidate(ids){
      const files=ids.map(id=>document.getElementById(id).files[0]).filter(Boolean);
      if(!files.length){ Swal.fire('Upload required','Please upload at least one document','warning'); return false; }
      const okExt=['jpg','jpeg','png','pdf']; const okMime=['image/jpeg','image/png','application/pdf',''];
      if(files.some(f=>!okExt.includes((f.name.split('.').pop()||'').toLowerCase()) || !okMime.includes(f.type||''))){
        Swal.fire('Invalid file','Only JPG/PNG/PDF allowed','warning'); return false;
      }
      return true;
    }

    $('#formVerifyDocs').on('submit', function(e){
      e.preventDefault();
      if(!basicValidate(['personal_id','residence_proof'])) return;
      const fd=new FormData(this);
      fd.append('application_id', applicationId);
      fd.append('application_ref_id', applicationId);
      fd.append('customer_id', customerId || '');
      fetch('api/verify_documents_upload.php',{method:'POST',body:fd})
        .then(r=>r.json()).then(r=>{
          if(r.status==='success'){
            Swal.fire('Saved', r.message||'Uploaded','success'); this.reset();
            ['personal_id','residence_proof'].forEach(id=>$('#livePrev_'+id).html('')); loadPreviews();
          } else { Swal.fire('Error', r.message||'Upload failed','error'); }
        }).catch(()=>Swal.fire('Error','Upload failed','error'));
    });
    $('#cancelVerifyDocs').on('click', ()=>{ ['personal_id','residence_proof'].forEach(id=>{ $('#'+id).val(''); $('#livePrev_'+id).html(''); }); });

    $('#formLand').on('submit', function(e){
      e.preventDefault();
      if(!basicValidate(['land_doc1','land_doc2','land_doc3'])) return;
      const fd=new FormData(this);
      fd.append('application_id', applicationId);
      fd.append('application_ref_id', applicationId);
      fd.append('customer_id', customerId || '');
      fetch('api/land_documents_upload.php',{method:'POST',body:fd})
        .then(r=>r.json()).then(r=>{
          if(r.status==='success'){
            Swal.fire('Saved', r.message||'Uploaded','success'); this.reset();
            ['land_doc1','land_doc2','land_doc3'].forEach(id=>$('#livePrev_'+id).html('')); loadPreviews();
          } else { Swal.fire('Error', r.message||'Upload failed','error'); }
        }).catch(()=>Swal.fire('Error','Upload failed','error'));
    });
    $('#cancelLand').on('click', ()=>{ ['land_doc1','land_doc2','land_doc3'].forEach(id=>{ $('#'+id).val(''); $('#livePrev_'+id).html(''); }); });

    $('#formBusiness').on('submit', function(e){
      e.preventDefault();
      const ids=['biz_doc1','biz_doc2','biz_doc3','biz_doc4','biz_doc5'];
      if(!basicValidate(ids)) return;
      const fd=new FormData(this);
      fd.append('application_id', applicationId);
      fd.append('application_ref_id', applicationId);
      fd.append('customer_id', customerId || '');
      fetch('api/business_documents_upload.php',{method:'POST',body:fd})
        .then(r=>r.json()).then(r=>{
          if(r.status==='success'){
            Swal.fire('Saved', r.message||'Uploaded','success'); this.reset();
            ids.forEach(id=>$('#livePrev_'+id).html('')); loadPreviews();
          } else { Swal.fire('Error', r.message||'Upload failed','error'); }
        }).catch(()=>Swal.fire('Error','Upload failed','error'));
    });
    $('#cancelBusiness').on('click', ()=>{ for(let i=1;i<=5;i++){ $('#biz_doc'+i).val(''); $('#livePrev_biz_doc'+i).html(''); } });

  })();
  </script>
</body>
</html>
