<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    .dir-row{display:flex;gap:.75rem;align-items:center;margin-bottom:.5rem}
    .dir-row .form-control{flex:1}
    .dir-actions{display:flex;gap:.4rem}
    .btn-plus{background:#1d4ed8;color:#fff;border:1px solid #1d4ed8;border-radius:.5rem;padding:.45rem .6rem;line-height:1}
    .btn-del{border:1px solid #ef4444;color:#ef4444;border-radius:.5rem;background:#fff;padding:.45rem .6rem}
    .btn-del:hover{background:#fff0f0}
    .muted{color:#6b7280}
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-md-12 grid-margin stretch-card">
            <div class="card"><div class="card-body"></div></div>
          </div>

          <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Business Details</h4>

                <form id="bizForm" autocomplete="off" novalidate>
                  <input type="hidden" id="loan_application_id" name="loan_application_id">
                  <input type="hidden" id="business_details_id" name="business_details_id">

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label for="business_type">Business Type <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="business_type" placeholder="Sole Trader / Limited Company / LLP …">
                        <div class="invalid-feedback">Business type is required.</div>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label for="company_number">Company Number</label>
                        <input type="text" class="form-control" id="company_number" placeholder="12345678 or AB123456">
                        <div class="invalid-feedback">Enter 8 digits or 2 letters + 6 digits.</div>
                      </div>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label for="company_name">Company Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="company_name" placeholder="Wayne Enterprises Ltd">
                        <div class="invalid-feedback">Company name is required.</div>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label for="vat_number">VAT Number</label>
                        <input type="text" class="form-control" id="vat_number" placeholder="GB123456789">
                        <div class="invalid-feedback">Use GB + 9 digits (optionally +3 branch digits).</div>
                      </div>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="company_address">Company Address <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="company_address" rows="2" placeholder="Street, City, Postcode"></textarea>
                        <div class="invalid-feedback">Company address is required.</div>
                      </div>
                    </div>
                  </div>

                  <!-- Directors -->
                  <div class="row mt-3">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Director(s) Details</label>
                        <div id="directorsWrap"></div>
                        <div class="dir-actions mt-1">
                          <button type="button" class="btn-plus" id="addDirector" title="Add Director">+</button>
                        </div>
                        <div class="muted mt-1">Add each director’s name and contact number.</div>
                      </div>
                    </div>
                  </div>

                  <div class="row mt-3">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label for="industry_type">Industry Type</label>
                        <input type="text" class="form-control" id="industry_type" placeholder="Construction / Retail / Tech …" maxlength="80">
                        <div class="invalid-feedback">Max 80 characters.</div>
                      </div>
                    </div>
                  </div>

                  <div class="mt-4">
                    <button type="submit" class="btn btn-primary me-2">Save</button>
                    <a href="alllenddetails.php" class="btn btn-light">Back</a>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <?php include '../../partials/footer.php'; ?>
        </div>
      </div>
    </div>
  </div>

  <?php include '../../partials/loadjs.php'; ?>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
  (function(){
    // --- helpers ---
    function escapeHtml(s){ return (s||'').toString().replace(/[&<>"']/g, m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[m])); }
    function markInvalid($el, invalid){
      if(invalid){ $el.addClass('is-invalid'); }
      else{ $el.removeClass('is-invalid'); }
    }

    const params = new URLSearchParams(window.location.search);
    const applicationId = params.get('application_id');
    if(!applicationId){ Swal.fire('Error','Missing application_id in URL','error'); return; }
    $('#loan_application_id').val(applicationId);

    const wrap = $('#directorsWrap');
    const MAX_DIRECTORS = 10;

    function directorRow(name='', number='', allowDelete=true){
      const html = `
        <div class="dir-row">
          <div class="flex-1 w-100">
            <input type="text" class="form-control dir-name" placeholder="Director Name" value="${escapeHtml(name)}">
            <div class="invalid-feedback">Director name is required.</div>
          </div>
          <div class="flex-1 w-100">
            <input type="text" class="form-control dir-num"  placeholder="Contact Number" value="${escapeHtml(number)}">
            <div class="invalid-feedback">Enter 7–15 digits (you may use + or spaces).</div>
          </div>
          ${allowDelete ? '<button type="button" class="btn-del js-del" title="Remove">×</button>' : '<span style="width:40px"></span>'}
        </div>`;
      const $row = $(html);
      $row.on('click', '.js-del', ()=> $row.remove());
      // Clear invalid on input
      $row.find('input').on('input', function(){ $(this).removeClass('is-invalid'); });
      return $row;
    }

    function renderDirectors(list){
      wrap.empty();
      if(Array.isArray(list) && list.length){
        list.forEach((d)=> wrap.append(directorRow(d.name||'', d.number||'', true)));
      }else{
        wrap.append(directorRow('', '', false)); // starter row (not deletable)
      }
    }

    $('#addDirector').on('click', ()=>{
      const count = wrap.find('.dir-row').length;
      if(count >= MAX_DIRECTORS){
        Swal.fire('Limit reached', `You can add up to ${MAX_DIRECTORS} directors.`, 'info');
        return;
      }
      wrap.append(directorRow());
    });

    function collectDirectors(){
      const out=[];
      wrap.find('.dir-row').each(function(){
        const name=$(this).find('.dir-name').val().trim();
        const num =$(this).find('.dir-num').val().trim();
        if(name!=='' || num!=='') out.push({name, number:num});
      });
      return out;
    }

    // --- load existing ---
    function loadData(){
      $.getJSON('api/business_details_get.php', { application_id: applicationId })
        .done(res=>{
          if(!res || !res.ok){ Swal.fire('Error', (res&&res.error)||'Failed to load','error'); return; }
          const b = res.business||{};
          $('#business_details_id').val(b.business_details_id || '');
          $('#business_type').val(b.business_type || '');
          $('#company_number').val(b.company_number || '');
          $('#company_name').val(b.company_name || '');
          $('#company_address').val(b.company_address || '');
          $('#vat_number').val(b.vat_number || '');
          $('#industry_type').val(b.industry_type || '');
          renderDirectors(b.company_directors || []);
        })
        .fail(xhr=>{
          console.error(xhr.responseText);
          Swal.fire('Error','Failed to load','error');
        });
    }

    // --- validations ---
    function validate(){
      const errors=[];
      const focusTargets=[];

      const $bizType = $('#business_type');
      const $compName= $('#company_name');
      const $addr    = $('#company_address');
      const $compNo  = $('#company_number');
      const $vat     = $('#vat_number');
      const $ind     = $('#industry_type');

      // required
      markInvalid($bizType, $bizType.val().trim()==='');
      if($bizType.hasClass('is-invalid')){ errors.push('Business type is required.'); focusTargets.push($bizType[0]); }

      markInvalid($compName, $compName.val().trim()==='');
      if($compName.hasClass('is-invalid')){ errors.push('Company name is required.'); focusTargets.push($compName[0]); }

      markInvalid($addr, $addr.val().trim()==='');
      if($addr.hasClass('is-invalid')){ errors.push('Company address is required.'); focusTargets.push($addr[0]); }

      // company number (optional) 8 digits or 2 letters + 6 digits
      const compNo = $compNo.val().trim();
      if(compNo!==''){
        const ok = /^(\d{8}|[A-Z]{2}\d{6})$/i.test(compNo);
        markInvalid($compNo, !ok);
        if(!ok){ errors.push('Company number must be 8 digits or 2 letters + 6 digits.'); if(!focusTargets.length) focusTargets.push($compNo[0]); }
      }else{
        $compNo.removeClass('is-invalid');
      }

      // VAT (optional) GB + 9 digits (optionally +3)
      const vat = $vat.val().trim();
      if(vat!==''){
        const ok = /^GB\d{9}(\d{3})?$/.test(vat.toUpperCase());
        markInvalid($vat, !ok);
        if(!ok){ errors.push('VAT number must be GB + 9 digits (optionally +3).'); if(!focusTargets.length) focusTargets.push($vat[0]); }
      }else{
        $vat.removeClass('is-invalid');
      }

      // Industry type (optional) max length already set; check anyway
      const ind = $ind.val().trim();
      if(ind.length>80){
        markInvalid($ind, true); errors.push('Industry type cannot exceed 80 characters.'); if(!focusTargets.length) focusTargets.push($ind[0]);
      }else{
        $ind.removeClass('is-invalid');
      }

      // directors
      wrap.find('.dir-row').each(function(){
        const $name=$(this).find('.dir-name');
        const $num =$(this).find('.dir-num');
        const name=$name.val().trim();
        const num =$num.val().trim();
        const any = (name!=='' || num!=='');
        if(any){
          const phoneDigits = num.replace(/[^\d]/g,'');
          const phoneOK = /^\d{7,15}$/.test(phoneDigits);
          markInvalid($name, name==='');
          markInvalid($num, !phoneOK);
          if(name===''){ errors.push('Each filled director row must include a name.'); if(!focusTargets.length) focusTargets.push($name[0]); }
          if(!phoneOK){ errors.push('Director phone must be 7–15 digits.'); if(!focusTargets.length) focusTargets.push($num[0]); }
        }else{
          $name.removeClass('is-invalid'); $num.removeClass('is-invalid');
        }
      });

      // attach input listeners to clear red states on change
      $('#bizForm input, #bizForm textarea').one('input change', function(){ $(this).removeClass('is-invalid'); });

      return { ok: errors.length===0, errors, focus: focusTargets[0] || null };
    }

    // --- save ---
    $('#bizForm').on('submit', function(e){
      e.preventDefault();

      const v = validate();
      if(!v.ok){
        Swal.fire({icon:'warning',title:'Please fix the following',html: v.errors.map(e=>`• ${e}`).join('<br>')});
        if(v.focus){ v.focus.scrollIntoView({behavior:'smooth',block:'center'}); v.focus.focus(); }
        return;
      }

      const body = {
        loan_application_id: $('#loan_application_id').val(),
        business_details_id: $('#business_details_id').val() || null,
        business_type:       $('#business_type').val().trim(),
        company_number:      $('#company_number').val().trim(),
        company_name:        $('#company_name').val().trim(),
        company_address:     $('#company_address').val().trim(),
        company_directors:   collectDirectors(), // array of {name, number}
        vat_number:          $('#vat_number').val().trim().toUpperCase(),
        industry_type:       $('#industry_type').val().trim()
      };

      Swal.fire({title:'Save changes?',icon:'question',showCancelButton:true,confirmButtonText:'Save'})
      .then(dec=>{
        if(!dec.isConfirmed) return;

        $.ajax({
          url:'api/business_details_save.php',
          method:'POST',
          dataType:'json',
          contentType:'application/json',
          data: JSON.stringify(body)
        })
        .done(res=>{
          if(res && res.ok){
            Swal.fire('Success', res.message||'Saved', 'success');
            loadData();
          }else{
            Swal.fire('Error', (res&&res.message)||'Save failed', 'error');
          }
        })
        .fail(xhr=>{
          console.error(xhr.responseText);
          Swal.fire('Error','Save failed','error');
        });
      });
    });

    // init
    renderDirectors([]); // starter row immediately
    loadData();
  })();
  </script>
</body>
</html>
