<?php include '../../partials/loadcss.php'; ?>
<?php
function app_base_path_dynamic(): string {
  $script = str_replace('\\','/', $_SERVER['SCRIPT_NAME'] ?? '/');
  $parts  = array_values(array_filter(explode('/', $script)));
  $anchors = ['pages','api','includes'];
  $cutAt = null;
  foreach ($parts as $i => $seg) { if (in_array($seg, $anchors, true)) { $cutAt = $i; break; } }
  if ($cutAt !== null) return '/'.implode('/', array_slice($parts, 0, $cutAt));
  return isset($parts[0]) ? '/'.$parts[0] : '/';
}
$APP_BASE = app_base_path_dynamic();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND — Opening Screens</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
  :root{--border:#e5e7eb;--muted:#6b7280;--bg:#f8fafc;--chip:#f1f5f9;--shadow:0 12px 36px rgba(2,6,23,.10),0 4px 14px rgba(2,6,23,.06);--primary:#2563eb;--primary-600:#1d4ed8;--green:#10b981;--amber:#f59e0b;--red:#ef4444;--phone-dark:#0b1220;}
  .content-wrapper{padding:1rem 1rem 2rem}
  @media (min-width:1400px){.content-wrapper{padding-left:1.25rem;padding-right:1.25rem}}
  .wrap{max-width:none;margin:0}
  .card{border:1px solid var(--border);border-radius:16px;background:#fff;box-shadow:var(--shadow);overflow:hidden}
  .card .card-header{padding:12px 16px;background:var(--bg);border-bottom:1px solid #eef2f7;display:flex;align-items:center;justify-content:space-between;gap:.75rem}
  .card .card-header h5{margin:0;font-weight:800;font-size:1.05rem}
  .card .card-body{padding:16px}
  .top-grid{display:grid;grid-template-columns:1.2fr .8fr;gap:16px}
  @media (max-width:1200px){.top-grid{grid-template-columns:1fr}}
  .upload-shell{display:grid;grid-template-columns:minmax(320px,1fr) 1.1fr;gap:16px}
  @media (max-width:992px){.upload-shell{grid-template-columns:1fr}}
  .dropzone{position:relative;border:2px dashed #cbd5e1;background:linear-gradient(180deg,#fafafa,#f6f8fb);border-radius:14px;min-height:220px;display:flex;align-items:center;justify-content:center;padding:16px;transition:border-color .18s,background .18s}
  .dropzone.dragover{border-color:#93c5fd;background:linear-gradient(180deg,#f0f9ff,#f8fbff)}
  .dz-inner{text-align:center;color:var(--muted);display:flex;flex-direction:column;align-items:center;gap:.4rem}
  .dz-icon{width:52px;height:52px;border-radius:12px;display:grid;place-items:center;background:#eef2ff;border:1px solid #c7d2fe;color:#3730a3;font-size:24px}
  .dz-actions{display:flex;gap:.5rem;flex-wrap:wrap;justify-content:center}
  .dz-note{font-size:.86rem}
  .hidden-input{display:none}
  .file-chip{display:inline-flex;align-items:center;gap:.4rem;background:#ecfeff;border:1px solid #a5f3fc;color:#0369a1;border-radius:999px;padding:.25rem .6rem;font-size:.85rem;font-weight:700}
  .progress{height:8px;border-radius:999px;background:#f1f5f9;border:1px solid #e2e8f0;overflow:hidden}
  .progress-bar{height:100%;width:0%;background:linear-gradient(90deg,#60a5fa,#2563eb);transition:width .25s}
  .hint{color:var(--muted);font-size:.9rem}
  .ctrls-row{display:flex;align-items:center;gap:.6rem;flex-wrap:wrap}
  .pill-note{display:inline-flex;align-items:center;gap:.35rem;border:1px solid var(--border);background:#fff;border-radius:999px;padding:.2rem .55rem;color:var(--muted);font-size:.82rem}

  /* iPhone frame – fixed to 1179 × 2556 */
  .active-preview{
    display:flex;align-items:center;justify-content:center;
    width:220px;height:400px; /* requested size */
    margin:0 auto;padding:0;
  }
  .phone{
    position:relative;display:block;
    width:100%;height:100%;           /* fill the 1179×2556 box */
    border-radius:34px;padding:12px;
    box-shadow:0 20px 60px rgba(2,6,23,.18), inset 0 0 0 2px #0f172a;
    background:linear-gradient(145deg,#0f172a,#111827);
    border:1px solid #111827;
  }
  .phone-notch{position:absolute;top:10px;left:50%;transform:translateX(-50%);width:120px;height:18px;background:#0a0f1f;border-bottom-left-radius:14px;border-bottom-right-radius:14px;box-shadow:0 1px 0 #0b1120}
  .phone-screen{position:absolute;inset:12px;border-radius:24px;overflow:hidden;background:var(--phone-dark);display:grid;place-items:center}
  .phone-screen video,.phone-screen img{width:100%;height:100%;object-fit:contain;background:#000;display:block}
  .phone-lottie{width:100%;height:100%;background:#000}

  .active-box{border:1px solid var(--border);border-radius:12px;background:#fff;padding:12px}
  .active-head{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px;gap:.5rem;flex-wrap:wrap}
  .chip{display:inline-flex;align-items:center;gap:.35rem;background:var(--chip);border:1px solid var(--border);padding:.15rem .55rem;border-radius:999px;font-size:.82rem}
  .chip.green{background:#ecfdf5;border-color:#a7f3d0;color:#047857;font-weight:700}
  .chip.gray{background:#f1f5f9;border-color:#e2e8f0;color:#334155}
  .active-meta{margin-top:8px;color:var(--muted);font-size:.86rem}

  .table-wrap{overflow:auto;border:1px solid var(--border);border-radius:12px}
  table.os-table{width:100%;border-collapse:separate;border-spacing:0}
  table.os-table thead th{position:sticky;top:0;z-index:1;background:var(--bg);font-weight:800;border-bottom:1px solid #eef2f7}
  table.os-table th,table.os-table td{padding:.65rem .75rem;vertical-align:middle;white-space:nowrap;border-bottom:1px solid #f1f5f9}
  table.os-table tbody tr:hover{background:#f9fafb}
  .row-del{opacity:.55}
  .preview-mini{width:120px;height:72px;border-radius:10px;object-fit:cover;background:#0b1220;display:block}
  .mini-wrap{width:120px;height:72px;border-radius:10px;overflow:hidden;background:#0b1220;display:grid;place-items:center}
  .pill{border:1px solid var(--border);border-radius:999px;padding:.18rem .55rem;font-size:.78rem}
  .pill-act{background:#ecfeff;border-color:#a5f3fc;color:#0e7490;font-weight:800}
  .pill-del{background:#fef2f2;border-color:#fecaca;color:#991b1b}
  .btn{border:1px solid var(--border);background:#fff;border-radius:999px;padding:.48rem .8rem;cursor:pointer;transition:transform .14s,box-shadow .14s,background .14s,border-color .14s;box-shadow:0 1px 2px rgba(2,6,23,.06);font-weight:600}
  .btn:hover{transform:translateY(-1px);background:#f8fafc}
  .btn:disabled{opacity:.55;cursor:not-allowed}
  .btn-primary{background:var(--primary);border-color:var(--primary);color:#fff}
  .btn-primary:hover{background:var(--primary-600);border-color:var(--primary-600)}
  .btn-green{background:var(--green);border-color:var(--green);color:#fff}
  .btn-green:hover{filter:brightness(.96)}
  .btn-amber{background:#fff;border-color:#fcd34d;color:#92400e}
  .btn-amber:hover{background:#fff7ed}
  .btn-danger{background:#fff;border-color:var(--red);color:#var(--red)}
  .btn-danger:hover{background:#fee2e2}
  .btn-icon{display:inline-flex;align-items:center;gap:.45rem}
  .actions{display:flex;gap:.5rem;align-items:center;flex-wrap:wrap}

  /* Preview modal — iPhone 15 logical pixels (portrait) */
  .modal{position:fixed;inset:0;background:rgba(2,6,23,.55);display:none;align-items:center;justify-content:center;z-index:3000;padding:20px}
  .modal.open{display:flex}
  .pv-frame-wrap{transform-origin:center center}
  .pv-frame{width:1179px;height:2556px;background:#0b1220;border-radius:14px;box-shadow:0 30px 80px rgba(0,0,0,.45);position:relative;overflow:hidden}
  .pv-close{position:absolute;top:8px;right:8px;border:none;border-radius:999px;width:44px;height:44px;display:grid;place-items:center;background:#ffffffe6;cursor:pointer;font-size:22px;z-index:5}
  .pv-content{position:absolute;inset:0;display:grid;place-items:center}
  .pv-content video,.pv-content img{width:100%;height:100%;object-fit:contain;background:#000;display:block}
  .pv-lottie{width:100%;height:100%;background:#111827}
  .muted{color:var(--muted)}
  .mdi{font-size:18px}
</style>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.12.2/lottie.min.js"></script>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="wrap">
            <div class="top-grid">
              <div class="card">
                <div class="card-header">
                  <h5>Opening Screen Uploader</h5>
                  <span class="pill-note"><i class="mdi mdi-information-outline"></i> PNG/JPG/WEBP/GIF, Lottie JSON, MP4/WEBM/MOV/OGG · max 12MB</span>
                </div>
                <div class="card-body">
                  <div class="upload-shell">
                    <div>
                      <div class="dropzone" id="dropzone">
                        <div class="dz-inner">
                          <div class="dz-icon"><i class="mdi mdi-cloud-upload-outline"></i></div>
                          <div><strong>Drag & drop</strong> a file here</div>
                          <div class="muted">or</div>
                          <div class="dz-actions">
                            <button class="btn" id="btnBrowse"><span class="btn-icon"><i class="mdi mdi-file-outline"></i> Browse</span></button>
                            <button class="btn" id="btnClear"><span class="btn-icon"><i class="mdi mdi-backspace-outline"></i> Clear</span></button>
                          </div>
                          <div class="dz-note">Tip: Small videos, GIFs or Lottie JSON work great for app start screens.</div>
                          <input type="file" id="fileInput" class="hidden-input" accept=".png,.jpg,.jpeg,.webp,.gif,.json,.mp4,.webm,.mov,.m4v,.ogg,.ogv" />
                        </div>
                      </div>
                      <div class="mt-3 ctrls-row">
                        <label class="muted" for="labelInput" style="min-width:64px">Label</label>
                        <input type="text" id="labelInput" class="form-control" placeholder="e.g. Summer promo" style="max-width:360px">
                        <span id="pickedMeta" class="file-chip" style="display:none"></span>
                      </div>
                      <div class="mt-3">
                        <div class="progress"><div class="progress-bar" id="uploadBar"></div></div>
                        <div class="muted" id="uploadMsg" style="margin-top:.35rem"></div>
                      </div>
                      <div class="mt-3">
                        <button class="btn btn-primary" id="btnUpload"><span class="btn-icon"><i class="mdi mdi-cloud-upload-outline"></i> Upload</span></button>
                      </div>
                    </div>
                    <div>
                      <div class="active-preview" aria-label="Uploader phone preview">
                        <div class="phone">
                          <div class="phone-notch" aria-hidden="true"></div>
                          <div class="phone-screen" id="phonePreviewScreen">
                            <span class="hint">Select or drop a file to preview</span>
                          </div>
                        </div>
                      </div>
                      <div class="hint" style="text-align:center">Preview simulates phone loading the media</div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="card">
                <div class="card-header">
                  <h5>Currently Active</h5>
                  <span id="activeChip" class="chip gray"><i class="mdi mdi-toggle-switch-off-outline"></i> None</span>
                </div>
                <div class="card-body">
                  <div class="active-box">
                    <div class="active-head">
                      <div class="muted" id="activeLabel">—</div>
                      <button class="btn btn-amber" id="btnPreviewActive" disabled><span class="btn-icon"><i class="mdi mdi-eye"></i> Preview</span></button>
                    </div>
                    <div class="active-preview">
                      <div class="phone" aria-label="iPhone preview frame">
                        <div class="phone-notch" aria-hidden="true"></div>
                        <div class="phone-screen" id="phoneScreen"><span class="hint">No active screen</span></div>
                      </div>
                    </div>
                    <div class="active-meta" id="activeMeta"></div>
                  </div>
                </div>
              </div>
            </div>

            <div class="card" style="margin-top:16px">
              <div class="card-header"><h5>All Opening Screens</h5></div>
              <div class="card-body">
                <div class="table-wrap">
                  <table class="os-table" id="screensTable">
                    <thead>
                      <tr>
                        <th style="min-width:70px">ID</th>
                        <th style="min-width:220px">Label</th>
                        <th>Preview</th>
                        <th>Type</th>
                        <th>Active</th>
                        <th>Updated (UK)</th>
                        <th>Updated By</th>
                        <th>Deleted</th>
                        <th style="min-width:420px">Actions</th>
                      </tr>
                    </thead>
                    <tbody id="screensTbody"></tbody>
                  </table>
                </div>
                <div class="muted mt-2">Only one screen can be active at a time. Deleted items are shown faded at the bottom.</div>
              </div>
            </div>

          </div>
        </div>
        <?php include '../../partials/footer.php'; ?>
      </div>
    </div>
  </div>

  <?php include '../../partials/loadjs.php'; ?>

  <!-- Fixed-size Preview Modal (2556×1179) -->
  <div class="modal" id="pvModal" role="dialog" aria-modal="true">
    <div class="pv-frame-wrap" id="pvWrap" style="--scale:1">
      <div class="pv-frame" id="pvFrame">
        <button class="pv-close" id="pvClose" title="Close">&times;</button>
        <div class="pv-content" id="pvContent"></div>
      </div>
    </div>
  </div>

  <script>
    const APP_BASE = <?php echo json_encode($APP_BASE, JSON_UNESCAPED_SLASHES); ?>;
    const END_LIST = APP_BASE + '/api/opening_screens_list.php';
    const END_UPLD = APP_BASE + '/api/opening_screens_upload.php';
    const END_UPDATE = APP_BASE + '/api/opening_screens_update.php';

    function joinBase(p){
      if (!p) return '';
      p = String(p);
      if (/^(?:https?:)?\/\//i.test(p)) return p;
      const base = APP_BASE.replace(/\/+$/,'');
      if (p.startsWith('/')) return p.startsWith(base + '/') ? p : (base + p);
      return base + '/' + p.replace(/^\/+/, '');
    }

    const fmtUK = new Intl.DateTimeFormat('en-GB',{timeZone:'Europe/London',year:'numeric',month:'short',day:'2-digit',hour:'2-digit',minute:'2-digit',second:'2-digit',hour12:false,timeZoneName:'short'});

    // ==== Upload preview ====
    const dropzone   = document.getElementById('dropzone');
    const btnBrowse  = document.getElementById('btnBrowse');
    const btnClear   = document.getElementById('btnClear');
    const fileInput  = document.getElementById('fileInput');
    const labelInput = document.getElementById('labelInput');
    const uploadMsg  = document.getElementById('uploadMsg');
    const uploadBar  = document.getElementById('uploadBar');
    const pickedMeta = document.getElementById('pickedMeta');
    const phonePreviewScreen = document.getElementById('phonePreviewScreen');

    let lastPreview = null;
    function resetProgress(){ uploadBar.style.width='0%'; }
    function setProgress(p){ uploadBar.style.width = Math.max(0,Math.min(100,p)) + '%'; }
    function clearPreviewBox(){
      if (lastPreview && lastPreview.url) URL.revokeObjectURL(lastPreview.url);
      if (lastPreview && lastPreview.anim) { try{ lastPreview.anim.destroy(); }catch(e){} }
      phonePreviewScreen.innerHTML = '<span class="hint">Select or drop a file to preview</span>';
      lastPreview = null; pickedMeta.style.display='none'; resetProgress();
    }
    function kindFromName(name,mime=''){
      const n=(name||'').toLowerCase();
      if (n.endsWith('.json')) return 'lottie';
      if (n.endsWith('.gif')) return 'gif';
      if (/\.(mp4|webm|mov|m4v|ogg|ogv)$/.test(n) || /^video\//.test(mime)) return 'video';
      if (n.endsWith('.png')||n.endsWith('.jpg')||n.endsWith('.jpeg')||n.endsWith('.webp')) return 'image';
      return 'image';
    }
    function setPickedMeta(file){ const kb=Math.round(file.size/1024); pickedMeta.textContent=`${file.name} • ${kb.toLocaleString('en-GB')} KB`; pickedMeta.style.display='inline-flex'; }
    function renderPreview(file){
      clearPreviewBox(); if (!file) return;
      const kind = kindFromName(file.name, file.type); setPickedMeta(file);
      if (kind==='image' || kind==='gif' || kind==='video'){
        const url = URL.createObjectURL(file); lastPreview = {kind,url,file};
        phonePreviewScreen.innerHTML = kind==='video' ? `<video src="${url}" muted autoplay playsinline loop></video>` : `<img src="${url}" alt="">`; return;
      }
      if (kind==='lottie'){
        const reader = new FileReader();
        reader.onload = ()=>{
          phonePreviewScreen.innerHTML = `<div id="lottiePrevOnPhone" class="phone-lottie"></div>`;
          try{
            const anim = lottie.loadAnimation({container:document.getElementById('lottiePrevOnPhone'),renderer:'svg',loop:true,autoplay:true,animationData:JSON.parse(reader.result)});
            lastPreview = {kind,anim,file};
          }catch(e){ phonePreviewScreen.innerHTML = `<span class="hint" style="color:#fca5a5">Invalid Lottie JSON</span>`; }
        };
        reader.readAsText(file);
      }
    }
    ['dragenter','dragover'].forEach(evt=>dropzone.addEventListener(evt,e=>{e.preventDefault();e.stopPropagation();dropzone.classList.add('dragover')}))
    ;['dragleave','drop'].forEach(evt=>dropzone.addEventListener(evt,e=>{e.preventDefault();e.stopPropagation();dropzone.classList.remove('dragover')}))
    dropzone.addEventListener('drop',e=>{const f=e.dataTransfer.files&&e.dataTransfer.files[0]; if(!f)return; fileInput.files=e.dataTransfer.files; renderPreview(f);});
    btnBrowse.addEventListener('click',()=>fileInput.click());
    fileInput.addEventListener('change',()=>{const f=fileInput.files&&fileInput.files[0]; if(f) renderPreview(f);});
    btnClear.addEventListener('click',()=>{fileInput.value='';labelInput.value='';uploadMsg.textContent='';clearPreviewBox();});

    const btnUpload=document.getElementById('btnUpload');
    btnUpload.addEventListener('click',()=>{
      uploadMsg.textContent=''; const f=(fileInput.files&&fileInput.files[0])||(lastPreview&&lastPreview.file); const label=labelInput.value.trim();
      if(!label){uploadMsg.textContent='Label is required';return;}
      if(!f){uploadMsg.textContent='Choose a file';return;}
      if(f.size>12*1024*1024){uploadMsg.textContent='File too large (max 12MB)';return;}
      const fd=new FormData(); fd.append('label',label); fd.append('file',f);
      btnUpload.disabled=true; setProgress(0);
      const xhr=new XMLHttpRequest(); xhr.open('POST',END_UPLD,true);
      xhr.upload.addEventListener('progress',e=>{if(e.lengthComputable)setProgress(Math.round((e.loaded/e.total)*100));});
      xhr.onreadystatechange=async()=>{ if(xhr.readyState===4){ btnUpload.disabled=false; try{const j=JSON.parse(xhr.responseText||'{}'); if(xhr.status>=200&&xhr.status<300&&j.status==='success'){uploadMsg.textContent='Uploaded ✔'; fileInput.value='';labelInput.value='';clearPreviewBox();await loadList();} else {uploadMsg.textContent=(j&&j.message)||'Upload failed'; setProgress(0);} }catch(_){uploadMsg.textContent='Upload error'; setProgress(0);} } };
      xhr.send(fd);
    });

    // ==== List / Active ====
    const tbody=document.getElementById('screensTbody');
    function icon(kind){return kind==='video'?'mdi mdi-video-outline':kind==='lottie'?'mdi mdi-motion-play':kind==='gif'?'mdi mdi-gif':'mdi mdi-image-outline'}
    function renderMini(cell,row){
      const url=joinBase(row.file_path); cell.innerHTML='';
      if(row.media_kind==='video'){const v=document.createElement('video');v.src=url;v.muted=true;v.loop=true;v.playsInline=true;v.autoplay=true;v.className='preview-mini';cell.appendChild(v);}
      else if(row.media_kind==='lottie'){const w=document.createElement('div');w.className='mini-wrap';w.innerHTML='<div class="lottie-mini" style="width:112px;height:68px"></div>';cell.appendChild(w);lottie.loadAnimation({container:w.firstChild,renderer:'svg',loop:true,autoplay:true,path:url});}
      else {const img=document.createElement('img');img.src=url;img.className='preview-mini';img.alt='';cell.appendChild(img);}
    }
    const activeChip=document.getElementById('activeChip');
    const activeLabelEl=document.getElementById('activeLabel');
    const activeMeta=document.getElementById('activeMeta');
    const btnPreviewAct=document.getElementById('btnPreviewActive');
    const phoneScreen=document.getElementById('phoneScreen');
    let activeAnim=null; let lastList=[];
    function clearActivePreview(){phoneScreen.innerHTML='<span class="hint">No active screen</span>'; if(activeAnim){try{activeAnim.destroy();}catch(e){} activeAnim=null;} btnPreviewAct.disabled=true; activeChip.className='chip gray'; activeChip.innerHTML='<i class="mdi mdi-toggle-switch-off-outline"></i> None'; activeLabelEl.textContent='—'; activeMeta.textContent='';}
    function setActiveBoxFromList(list){
      const row=(list||[]).find(x=>Number(x.is_active)===1&&Number(x.is_deleted)===0); if(!row){clearActivePreview();return;}
      activeChip.className='chip green'; activeChip.innerHTML='<i class="mdi mdi-toggle-switch"></i> Active';
      activeLabelEl.textContent=row.label||'—'; activeMeta.textContent=(row.updated_at?`Updated: ${fmtUK.format(new Date(row.updated_at))}`:'')+(row.updated_by?` • by ${row.updated_by}`:'');
      phoneScreen.innerHTML=''; if(activeAnim){try{activeAnim.destroy();}catch(e){} activeAnim=null;}
      const url=joinBase(row.file_path);
      if(row.media_kind==='video'){phoneScreen.innerHTML=`<video src="${url}" muted autoplay playsinline loop></video>`;}
      else if(row.media_kind==='lottie'){const holder=document.createElement('div');holder.className='phone-lottie';holder.id='lottieActive';phoneScreen.appendChild(holder);activeAnim=lottie.loadAnimation({container:holder,renderer:'svg',loop:true,autoplay:true,path:url});}
      else {phoneScreen.innerHTML=`<img src="${url}" alt="Active screen" />`;}
      btnPreviewAct.disabled=false; btnPreviewAct.onclick=()=>openPreview(row.screen_id);
    }
    async function loadList(){
      tbody.innerHTML=`<tr><td colspan="9" class="muted">Loading…</td></tr>`;
      try{
        const r=await fetch(END_LIST,{cache:'no-store'}); const j=await r.json();
        if(!Array.isArray(j)){tbody.innerHTML=`<tr><td colspan="9" class="text-danger">Failed to load</td></tr>`;return;}
        lastList=j.slice(); setActiveBoxFromList(j);
        tbody.innerHTML='';
        j.forEach(row=>{
          const tr=document.createElement('tr'); if(Number(row.is_deleted)===1) tr.classList.add('row-del');
          tr.innerHTML=`
            <td>${row.screen_id}</td>
            <td title="${(row.label||'').replace(/"/g,'&quot;')}">${row.label||'—'}</td>
            <td class="mini"></td>
            <td><i class="${icon(row.media_kind)}"></i> ${row.media_kind}</td>
            <td>${row.is_active==1?'<span class="pill pill-act">Active</span>':'<span class="pill">—</span>'}</td>
            <td>${row.updated_at?fmtUK.format(new Date(row.updated_at)):'—'}</td>
            <td>${row.updated_by||'—'}</td>
            <td>${row.is_deleted==1?'<span class="pill pill-del">Deleted</span>':'—'}</td>
            <td class="actions">
              <button class="btn btn-icon js-preview" title="Preview" data-id="${row.screen_id}"><i class="mdi mdi-eye"></i> Preview</button>
              ${row.is_active==1?`<button class="btn btn-amber btn-icon js-deactivate" title="Deactivate" data-id="${row.screen_id}"><i class="mdi mdi-toggle-switch-off-outline"></i> Deactivate</button>`:`<button class="btn btn-green btn-icon js-activate" title="Activate" data-id="${row.screen_id}" ${row.is_deleted==1?'disabled':''}><i class="mdi mdi-toggle-switch"></i> Activate</button>`}
              <button class="btn btn-danger btn-icon js-delete" title="Delete (soft)" data-id="${row.screen_id}" ${row.is_deleted==1?'disabled':''}><i class="mdi mdi-trash-can-outline"></i> Delete</button>
            </td>`;
          tbody.appendChild(tr); renderMini(tr.querySelector('.mini'),row);
        });
      }catch(e){tbody.innerHTML=`<tr><td colspan="9" class="text-danger">Error</td></tr>`;}
    }
    tbody.addEventListener('click',async(e)=>{
      const b=e.target.closest('button'); if(!b) return;
      const id=Number(b.dataset.id||0); if(!id) return;
      let action=null;
      if(b.classList.contains('js-activate')) action='activate';
      else if(b.classList.contains('js-deactivate')) action='deactivate';
      else if(b.classList.contains('js-delete')) action='delete';
      else if(b.classList.contains('js-preview')) {openPreview(id); return;}
      if(!action) return; b.disabled=true;
      try{const r=await fetch(END_UPDATE,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({action,screen_id:id})});const j=await r.json();if(!r.ok||j.status!=='success') alert((j&&j.message)||'Operation failed'); await loadList();}catch(_){alert('Error');} finally{b.disabled=false;}
    });

    // ==== Modal (2556×1179) ====
    const pvModal=document.getElementById('pvModal');
    const pvWrap=document.getElementById('pvWrap');
    const pvFrame=document.getElementById('pvFrame');
    const pvClose=document.getElementById('pvClose');
    const pvContent=document.getElementById('pvContent');
    let pvAnim=null;

    function sizeModalToViewport(){
      const W=1179, H=2556;
      const vw=window.innerWidth-40, vh=window.innerHeight-40; // padding from .modal
      const scale=Math.min(1, vw/W, vh/H);
      pvWrap.style.transform=`scale(${scale})`;
    }
    function closePreview(){
      pvModal.classList.remove('open'); pvContent.innerHTML=''; if(pvAnim){try{pvAnim.destroy();}catch(e){} pvAnim=null;}
      window.removeEventListener('resize',sizeModalToViewport);
    }
    pvClose.addEventListener('click',closePreview);
    pvModal.addEventListener('click',e=>{ if(e.target===pvModal) closePreview(); });
    document.addEventListener('keydown',e=>{ if(e.key==='Escape' && pvModal.classList.contains('open')) closePreview(); });

    async function openPreview(id){
      try{
        const row=(lastList||[]).find(x=>Number(x.screen_id)===Number(id)); if(!row) return;
        const url=joinBase(row.file_path);
        pvContent.innerHTML='';
        if(row.media_kind==='video'){
          pvContent.innerHTML = `<video src="${url}" controls autoplay muted playsinline></video>`;
        } else if(row.media_kind==='lottie'){
          pvContent.innerHTML = `<div class="pv-lottie" id="lottieBig"></div>`;
          pvAnim = lottie.loadAnimation({container:document.getElementById('lottieBig'),renderer:'svg',loop:true,autoplay:true,path:url});
        } else {
          pvContent.innerHTML = `<img src="${url}" alt="">`;
        }
        pvModal.classList.add('open');
        sizeModalToViewport();
        window.addEventListener('resize',sizeModalToViewport);
      }catch(_){}
    }

    // Init
    loadList();
  </script>
</body>
</html>
