<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <title>EZY LEND</title>
</head>
<body>
  <div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
      <div class="content-wrapper d-flex align-items-center auth px-0">
        <div class="row w-100 mx-0">
          <div class="col-lg-4 mx-auto">
            <div class="auth-form-light text-left py-5 px-4 px-sm-5">
              <div class="brand-logo">
                <img src="../../../../images/logo.svg" alt="logo">
              </div>
              <h4>Hello! let's get started</h4>
              <h6 class="font-weight-light">Sign in to continue.</h6>
                <form class="pt-3" id="loginForm">
                <div class="form-group mb-3">
                    <input type="text" class="form-control form-control-lg" id="username" placeholder="Username or Email" required>
                </div>
                <div class="form-group mb-3">
                    <input type="password" class="form-control form-control-lg" id="password" placeholder="Password" required>
                </div>
                <div id="errorMessage" class="alert alert-danger d-none" role="alert"></div>
                <div class="mt-3">
                    <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn w-100" id="signInButton">
                        SIGN IN
                    </button>
                </div>
            </form>
            </div>
          </div>
        </div>
      </div>
      <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
   <!-- container-scroller -->
   <?php include '../../partials/loadjs.php'; ?>  
  <!-- endinject -->

  <script>
$(document).ready(function() {
    $('#loginForm').on('submit', function(event) {
        event.preventDefault(); // Prevent page reload

        const signInButton = $('#signInButton');
        const errorMessageDiv = $('#errorMessage');
        const originalButtonText = signInButton.html();

        const formData = {
            username: $('#username').val(),
            password: $('#password').val()
        };

        // --- Start Loading Effect ---
        signInButton.prop('disabled', true);
        signInButton.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Signing In...');
        errorMessageDiv.addClass('d-none'); // Hide previous errors

        $.ajax({
            url: 'includes/login_handler.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    // On success, redirect to the dashboard
                    window.location.href = response.redirect;
                } else {
                    // Show error message from server
                    errorMessageDiv.text(response.message).removeClass('d-none');
                }
            },
            error: function() {
                // Handle server errors (500, etc.)
                errorMessageDiv.text('An unknown server error occurred.').removeClass('d-none');
            },
            complete: function() {
                // --- End Loading Effect ---
                // This runs after success or error
                signInButton.prop('disabled', false);
                signInButton.html(originalButtonText);
            }
        });
    });
});
</script>
</body>

</html>