<?php include 'partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>
</head>
<body>
  <div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
      <div class="content-wrapper d-flex align-items-center auth px-0">
        <div class="row w-100 mx-0">
          <div class="col-lg-4 mx-auto">
            <div class="auth-form-light text-left py-5 px-4 px-sm-5">
              <h4>New here?</h4>
              <h6 class="font-weight-light">Signing up is easy. Just a few steps.</h6>

              <form class="pt-3" id="signupForm">
                <div class="form-group mb-3">
                    <label for="username">Username</label>
                    <input type="text" class="form-control form-control-lg" id="username" name="username" placeholder="Username" required>
                </div>

                <div class="form-group mb-3">
                    <label for="password">Password</label>
                    <input type="password" class="form-control form-control-lg" id="password" name="password" placeholder="Password" required>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn w-100">SIGN UP</button>
                </div>
              </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include 'partials/loadjs.php'; ?>  
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script>
  $(document).ready(function() {
      $('#signupForm').on('submit', function(event) {
          event.preventDefault();
          const formData = new FormData(this);

          $.ajax({
              url: 'includes/addadmin.php',
              type: 'POST',
              data: formData,
              contentType: false,
              processData: false,
              cache: false,
              dataType: 'json',
              success: function(response) {
                  if (response.status === 'success') {
                      Swal.fire({
                          title: 'Success!',
                          text: response.message,
                          icon: 'success',
                          timer: 2000,
                          showConfirmButton: false
                      }).then(() => {
                          $('#signupForm')[0].reset();
                      });
                  } else {
                      Swal.fire('Error', response.message, 'error');
                  }
              },
              error: function() {
                  Swal.fire('Error!', 'Connecdwstion error. Please try again.', 'error');
              }
          });
      });
  });
  </script>
</body>
</html>
