<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>

  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">

  <style>
    .dt-scroll-wrap{width:100%;overflow-x:auto;-webkit-overflow-scrolling:touch}
    #allloanTable td,#allloanTable th{white-space:nowrap;vertical-align:middle}
    .dt-toolbar{display:flex;align-items:center;gap:.5rem;flex-wrap:wrap;justify-content:flex-end}
    @media (max-width:576px){table.dataTable td,table.dataTable th{padding:.5rem .6rem!important}}

    /* Table-only vertical scrolling */
    .dataTables_wrapper .dataTables_scrollBody{
      overflow-y:auto !important;
      border:1px solid #eef2f7;
      border-radius:.5rem;
    }

    /* Action buttons */
    .act-btn{
      border:1px solid #e5e7eb;background:#fff;border-radius:.65rem;
      padding:.42rem .6rem;cursor:pointer;transition:all .18s ease;
      box-shadow:0 1px 0 rgba(0,0,0,.03)
    }
    .act-btn:hover{background:#f3f4f6;transform:translateY(-1px)}
    .act-row{display:flex;gap:.4rem;align-items:center}

    .muted{color:#6b7280}
    .badge.bg-warning{background:#fde68a!important;color:#1f2937!important}
    .badge.bg-info{background:#bae6fd!important;color:#111827!important}
    .bg-purple { background-color:#6f42c1!important; color:#fff!important; }

    /* === Pretty, animated modal (no Bootstrap JS needed) === */
    .modal{
      position:fixed; inset:0; display:flex; align-items:center; justify-content:center;
      visibility:hidden; opacity:0; pointer-events:none;
      background:rgba(2,6,23,.50); backdrop-filter:blur(2.5px);
      transition:opacity .22s ease, visibility 0s linear .22s; z-index:1055
    }
    .modal.open{visibility:visible; opacity:1; pointer-events:auto; transition-delay:0s}
    .modal .modal-content{
      width:min(720px, calc(100% - 32px));
      background:linear-gradient(180deg,#ffffff,#fdfdfd);
      border:1px solid #e5e7eb; border-radius:16px; overflow:hidden;
      transform:translateY(16px) scale(.985); opacity:.98;
      box-shadow:0 22px 70px rgba(2,6,23,.22), 0 8px 26px rgba(2,6,23,.12);
      transition:transform .24s cubic-bezier(.2,.7,.2,1), opacity .22s ease
    }
    .modal.open .modal-content{transform:translateY(0) scale(1); opacity:1}

    /* Wider Amounts modal */
    #amountsModal.modal .modal-content{
      width: 1200px !important;
      max-width: calc(100% - 32px) !important;
    }

    .modal-header{
      display:flex;align-items:center;justify-content:space-between;
      padding:14px 16px;border-bottom:1px solid #eef2f7;background:#f8fafc
    }
    .modal-title{margin:0;font-weight:700;font-size:1.05rem;display:flex;align-items:center;gap:.5rem}
    .modal-body{padding:16px}
    .modal-footer{padding:12px 16px;border-top:1px solid #eef2f7;background:#fbfbfb;display:flex;gap:.5rem;justify-content:flex-end}
    .btn-ghost{
      border:1px solid #e5e7eb;background:#fff;border-radius:.6rem;padding:.45rem .75rem;cursor:pointer
    }
    .btn-primary{
      border:1px solid #2563eb;background:#2563eb;color:#fff;border-radius:.6rem;padding:.45rem .75rem;cursor:pointer
    }
    .btn-primary:disabled{opacity:.5;cursor:not-allowed}
    .close, .close-amounts{border:none;background:transparent;font-size:22px;line-height:1;cursor:pointer}

    /* Amounts modal layout */
    .am-card{
      border:1px solid #e5e7eb;border-radius:12px;padding:14px;background:#fff
    }
    .am-card h6{margin:0 0 8px 0;font-weight:700}
    .am-line{display:flex;justify-content:space-between;align-items:center;padding:6px 0;border-bottom:1px dashed #eef2f7}
    .am-line:last-child{border-bottom:0}
    .am-ask{font-weight:700}
    .am-highlight{
      border:1px solid #dbeafe;background:#eff6ff;border-radius:10px;padding:8px 10px
    }
    .am-caption{font-size:.85rem;color:#6b7280}
    .gap-8{gap:.5rem}

    /* === Floating Status Menu (portal) === */
    .fly-menu{
      position:fixed; left:0; top:0; z-index:100000;
      min-width:235px;background:#fff;border:1px solid #e5e7eb;border-radius:.65rem;
      box-shadow:0 16px 32px rgba(2,6,23,.10), 0 4px 10px rgba(2,6,23,.06);
      padding:.4rem; opacity:0; transform:translateY(6px) scale(.98);
      transition:opacity .12s ease, transform .14s cubic-bezier(.2,.7,.2,1)
    }
    .fly-menu.show{opacity:1; transform:translateY(0) scale(1)}
    .fly-item{
      display:flex;align-items:center;gap:.65rem;padding:.5rem .6rem;border-radius:.5rem;cursor:pointer;font-weight:500
    }
    .fly-item:hover{background:#eef2ff}
    .fly-sep{height:1px;background:#e5e7eb;margin:.3rem 0}
    .fly-item i{font-size:18px}
    .fly-pending  i{color:#64748b}
    .fly-process  i{color:#0ea5e9}
    .fly-rejected i{color:#ef4444}
    .fly-verified i{color:#10b981}
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>

    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">All Lend Details</h4>

                <div class="dt-scroll-wrap">
                  <table id="allloanTable" class="table table-hover table-striped" style="width:100%">
                    <thead>
                      <tr>
                        <th>App ID</th>
                        <th>Client Name</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Applied</th>
                        <th>Status Date</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>

              </div>
            </div>
          </div>

          <!-- Modal: Response / Alerts -->
          <div class="modal" id="responseModal" aria-hidden="true">
            <div class="modal-content" role="dialog" aria-modal="true" aria-labelledby="respTitle">
              <div class="modal-header">
                <div class="modal-title" id="respTitle">
                  <i class="mdi mdi-information-outline"></i>
                  Notice
                </div>
                <button class="close" aria-label="Close">&times;</button>
              </div>
              <div class="modal-body">
                <div id="responseMsg" class="mt-2"></div>
              </div>
              <div class="modal-footer">
                <button class="btn-ghost js-close-response">Close</button>
              </div>
            </div>
          </div>

          <!-- Modal: Amounts Applied / Release -->
          <div class="modal" id="amountsModal" aria-hidden="true">
            <div class="modal-content" role="dialog" aria-modal="true" aria-labelledby="amountsTitle">
              <div class="modal-header">
                <div class="modal-title" id="amountsTitle">
                  <i class="mdi mdi-currency-gbp"></i>
                  Amounts
                </div>
                <button class="close-amounts" aria-label="Close">&times;</button>
              </div>
              <div class="modal-body">
                <div id="amountsBody" class="mt-2"></div>
              </div>
              <div class="modal-footer gap-8">
                <button type="button" class="btn-ghost" id="cancelReleaseFooter">Close</button>
                <button type="button" class="btn-primary" id="saveReleaseFooter" disabled>Save</button>
              </div>
            </div>
          </div>

        </div><!-- content-wrapper -->
      </div><!-- main-panel -->
    </div><!-- page-body-wrapper -->

    <?php include '../../partials/footer.php'; ?>
  </div><!-- container-scroller -->

  <?php include '../../partials/loadjs.php'; ?>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- DataTables JS -->
  <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
  $(function () {
    /* ====== ENDPOINTS ====== */
    const ENDPOINT_LIST        = 'api/fetchezydata.php';
    const ENDPOINT_DOCS        = 'api/list_documents.php';
    const ENDPOINT_SET_STATUS  = 'api/update_application_status.php';
    const ENDPOINT_AMOUNTS     = 'api/get_application_amounts.php';
    const ENDPOINT_SET_RELEASE = 'api/update_release_amount.php';

    const tableEl = $('#allloanTable');
    let table;
    let previousSignature = '';

    /* ====== Constants ====== */
    const UNDER_DOCS_LABEL = 'Under Documents Verification';
    // Don’t auto-downgrade these terminal statuses
    const EXCLUDE_AUTO_UPDATE = new Set(['rejected','approved']);

    /* ====== UK time helpers (BST/GMT correct) ====== */
    function parseDbDate(value){
      if(!value) return null;
      const s = String(value).trim();

      // Unix epoch seconds or ms
      if (/^\d+$/.test(s)) {
        const n = Number(s);
        return new Date(n < 1e12 ? n*1000 : n);
      }
      // MySQL DATETIME "YYYY-MM-DD HH:MM:SS" — treat as UTC
      if (/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/.test(s)) {
        const d = new Date(s.replace(' ','T')+'Z');
        return isNaN(d.getTime()) ? null : d;
      }
      // ISO w/o TZ — assume UTC
      if (/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}$/.test(s)) {
        const d = new Date(s+'Z');
        return isNaN(d.getTime()) ? null : d;
      }
      const d = new Date(s);
      return isNaN(d.getTime()) ? null : d;
    }

    const fmtUK = new Intl.DateTimeFormat('en-GB', {
      timeZone: 'Europe/London',
      weekday: 'short', day: '2-digit', month: 'short', year: 'numeric',
      hour: '2-digit', minute: '2-digit', second: '2-digit',
      hour12: false, timeZoneName: 'short'
    });

    function timeAgoUK(val){
      const d = (val instanceof Date) ? val : parseDbDate(val);
      if(!d) return '—';
      const diffSec = Math.floor((Date.now() - d.getTime())/1000);
      if(diffSec < 0) return '—';
      if(diffSec < 5)  return 'just now';
      if(diffSec < 60) return `${diffSec}s ago`;
      const m = Math.floor(diffSec/60);
      if(m < 60) return m===1 ? '1 min ago' : `${m} mins ago`;
      const h = Math.floor(m/60);
      if(h < 24) return h===1 ? '1 hr ago' : `${h} hrs ago`;
      const dsy = Math.floor(h/24);
      if(dsy < 7) return dsy===1 ? '1 day ago' : `${dsy} days ago`;
      const w = Math.floor(dsy/7);
      if(w < 5) return w===1 ? '1 wk ago' : `${w} wks ago`;
      const mo = Math.floor(dsy/30);
      if(mo < 12) return mo===1 ? '1 mo ago' : `${mo} mos ago`;
      const y = Math.floor(dsy/365);
      return y===1 ? '1 yr ago' : `${y} yrs ago`;
    }

    /* ====== HELPERS ====== */
    function openModal(id){ $(id).addClass('open'); }
    function closeModal(id){ $(id).removeClass('open'); }
    function gbp(val){
      if(val===null||val===undefined||val==='') return 'N/A';
      const n=Number(val); if(Number.isNaN(n)) return 'N/A';
      return n.toLocaleString('en-GB',{style:'currency',currency:'GBP'});
    }
    function statusBadgeHtml(statusRaw){
      const s=(statusRaw||'').toString().trim().toLowerCase();
      const normalized = (s==='under documnets verification') ? 'under documents verification' : s;
      let cls='bg-secondary';
      switch(normalized){
        case 'applied': cls='bg-primary'; break;
        case 'pending': cls='bg-secondary'; break;
        case 'in process': cls='bg-info'; break;
        case 'under documents verification': cls='bg-warning text-dark'; break;
        case 'verified': cls='bg-success'; break;
        case 'rejected': cls='bg-danger'; break;
        case 'approved': cls='bg-purple'; break;
        default: cls='bg-dark';
      }
      const label=(statusRaw&&statusRaw.length)?statusRaw:'N/A';
      return `<span class="badge ${cls}">${label}</span>`;
    }
    function buildSignature(rows){
      return JSON.stringify(rows.map(r=>[r.application_id,r.status,r.createdat,r.status_date]));
    }
    function injectToolbar(){
      $('#allloanTable_filter input').attr('placeholder','Search applications…').addClass('form-control form-control-sm');
      if(!$('.dt-extra-toolbar').length){
        const html=`
          <div class="row mb-2">
            <div class="col-sm-12 dt-toolbar">
              <div class="dt-extra-toolbar">
                <button id="refreshTable" type="button" class="btn btn-outline-secondary btn-sm">
                  <i class="mdi mdi-refresh"></i> Refresh
                </button>
              </div>
            </div>
          </div>`;
        $(html).insertAfter($('#allloanTable_filter').closest('.row'));
      }
      $('#refreshTable').off('click').on('click', ()=> fetchAndRefreshIfChanged(true));
    }

    /* ====== DOCS READINESS (for Verified gate) ====== */
    async function applicationDocsReady(customer_id, application_id){
      try{
        const res = await $.getJSON(`${ENDPOINT_DOCS}?customer_id=${encodeURIComponent(customer_id)}&application_id=${encodeURIComponent(application_id)}`);
        const items = Array.isArray(res.items)?res.items:[];
        const now = new Date();

        const latestBy = {};
        function pushLatest(key, it){
          if(!latestBy[key] || new Date(it.uploaded_at)>new Date(latestBy[key].uploaded_at)) latestBy[key]=it;
        }
        items.forEach(it=>{
          const type = (it.doc_type||'').toLowerCase();
          const fn = (it.file_path||it.original_name||'').toLowerCase();
          if(type==='personal_id') pushLatest('personal_id', it);
          else if(type==='residence_proof') pushLatest('residence_proof', it);
          else if(type==='land'){
            if (/(^|[_/])land_doc1_/.test(fn)) pushLatest('land_doc1', it);
            if (/(^|[_/])land_doc2_/.test(fn)) pushLatest('land_doc2', it);
            if (/(^|[_/])land_doc3_/.test(fn)) pushLatest('land_doc3', it);
          } else if(type==='business'){
            for(let i=1;i<=5;i++){ if(new RegExp(`(^|[_/])biz_doc${i}_`).test(fn)) pushLatest(`biz_doc${i}`, it); }
          }
        });

        // mandatory
        const must = ['personal_id','residence_proof'];
        for(const k of must){
          const row = latestBy[k];
          if(!row) return {ready:false, reason:`Missing ${k.replace('_',' ')}`};
          const expired = row.expires_at && (new Date(row.expires_at)<now);
          if(row.verified!=1 || expired) return {ready:false, reason:`${k.replace('_',' ')} not verified/expired`};
        }
        // optional-if-present must also be verified + not expired
        const others = Object.keys(latestBy).filter(k=>!must.includes(k));
        for(const k of others){
          const row = latestBy[k];
          const expired = row.expires_at && (new Date(row.expires_at)<now);
          if(row.verified!=1 || expired) return {ready:false, reason:`${k} not verified/expired`};
        }
        return {ready:true};
      }catch(e){
        console.error(e);
        return {ready:false, reason:'Failed to check documents'};
      }
    }

    /* ====== AUTO “Under Documents Verification” (DB + UI) ====== */
    const DOCS_TTL_MS = 60000; // cache per row for 60s
    const docsCache = new Map(); // appId -> {ts, hasAny, needsReview}
    const inFlight = new Set();  // appIds currently updating
    const lastAttempt = new Map(); // appId -> ts
    const COOLDOWN_MS = 60000; // don’t hammer API for same row more than once/min

    function docsNeedsReviewFromItems(items){
      if(!Array.isArray(items) || items.length===0) return {hasAny:false, needs:false};
      const now = new Date();
      for(const it of items){
        const expired = it.expires_at && (new Date(it.expires_at) < now);
        if (it.verified != 1 || expired) return {hasAny:true, needs:true};
      }
      return {hasAny:true, needs:false};
    }

    async function fetchDocsState(customer_id, application_id){
      const key = String(application_id);
      const cached = docsCache.get(key);
      const now = Date.now();
      if(cached && (now - cached.ts) < DOCS_TTL_MS) return cached;

      try{
        const res = await $.getJSON(`${ENDPOINT_DOCS}?customer_id=${encodeURIComponent(customer_id)}&application_id=${encodeURIComponent(application_id)}`);
        const {hasAny, needs} = docsNeedsReviewFromItems(res && res.items);
        const payload = {ts: now, hasAny, needsReview: needs};
        docsCache.set(key, payload);
        return payload;
      }catch(e){
        if(cached) return cached;
        const payload = {ts: now, hasAny:false, needsReview:false};
        docsCache.set(key, payload);
        return payload;
      }
    }

    function shouldAutoUpdateDb(currentStatus){
      const s = (currentStatus||'').toString().trim().toLowerCase();
      return !EXCLUDE_AUTO_UPDATE.has(s); // skip Approved/Rejected
    }

    function queueStatusUpdate(row, idx, targetLabel){
      const appId = String(row.application_id);
      if (inFlight.has(appId)) return;

      const now = Date.now();
      const prev = lastAttempt.get(appId) || 0;
      if (now - prev < COOLDOWN_MS) return;

      inFlight.add(appId);
      lastAttempt.set(appId, now);

      $.ajax({
        url: ENDPOINT_SET_STATUS,
        method: 'POST',
        dataType: 'json',
        contentType: 'application/json',
        data: JSON.stringify({ application_id: row.application_id, status: targetLabel }),
        complete: function(){ inFlight.delete(appId); },
        success: function(res){
          if(res && res.status==='success'){
            // Update row data locally so badge matches DB right away
            const data = table.row(idx).data();
            if(data){
              data.status = targetLabel;
              table.row(idx).data(data); // replace data
              // cell 4 (Status) already rendered with overlay; keep it
            }
          } else {
            // leave overlay as-is; DB didn’t change
            // (optional) console.warn('Status update failed:', res);
          }
        },
        error: function(xhr){
          // (optional) console.error('Status update error', xhr.responseText);
        }
      });
    }

    async function updateDocStatusesForVisibleRows(){
      const api = table;
      const rows = api.rows({page:'current'});
      const rowIdxs = rows.indexes().toArray();

      for(const idx of rowIdxs){
        const data = api.row(idx).data();
        if(!data) continue;

        const stCell = api.cell(idx, 4).node(); // Status TD

        if(stCell.dataset.docOverlayPending === '1') continue;
        stCell.dataset.docOverlayPending = '1';

        try{
          const state = await fetchDocsState(data.customer_id, data.application_id);

          if(state.hasAny && state.needsReview){
            // UI overlay
            stCell.innerHTML = statusBadgeHtml(UNDER_DOCS_LABEL);
            stCell.dataset.docOverlay = '1';

            // DB auto-update (skip terminal statuses)
            if (shouldAutoUpdateDb(data.status) &&
                (data.status||'').toString().trim().toLowerCase() !== UNDER_DOCS_LABEL.toLowerCase()) {
              queueStatusUpdate(data, idx, UNDER_DOCS_LABEL);
            }
          }else{
            // remove overlay if previously applied
            if(stCell.dataset.docOverlay === '1'){
              stCell.innerHTML = statusBadgeHtml(data.status);
              delete stCell.dataset.docOverlay;
            }
          }
        }finally{
          stCell.dataset.docOverlayPending = '0';
        }
      }
    }

    /* ====== STATUS CHANGE (with Rejection reasons + Verified gate) ====== */
    async function changeStatus(row, target){
      if(target==='Verified'){
        const gate = await applicationDocsReady(row.customer_id, row.application_id);
        if(!gate.ready){
          const why = gate.reason? `<br><span class="muted">Reason: ${gate.reason}</span>`:'';
          showModal('Cannot set Verified. All latest documents must be verified and not expired.'+why);
          return;
        }
      }

      let payload = { application_id: row.application_id, status: target };

      if (target === 'Rejected') {
        const reasonHtml = `
          <div style="text-align:left">
            <label class="muted" style="font-size:.9rem">Select a reason</label>
            <select id="rejSel" class="swal2-input" style="width:100%;box-sizing:border-box">
              <option value="">Select…</option>
              <option>Incomplete documents</option>
              <option>Failed affordability checks</option>
              <option>Credit history concerns</option>
              <option>Identity mismatch</option>
              <option>Fraud risk</option>
              <option>Customer withdrew</option>
              <option value="__OTHER__">Other</option>
            </select>
            <textarea id="rejTxt" class="swal2-textarea" placeholder="Type custom reason…" style="display:none;height:110px"></textarea>
          </div>`;
        const out = await Swal.fire({
          title:'Reject application',
          html:reasonHtml,
          focusConfirm:false,
          showCancelButton:true,
          confirmButtonText:'Reject',
          preConfirm:()=>{
            const sel = (document.getElementById('rejSel')||{}).value || '';
            const txt = (document.getElementById('rejTxt')||{}).value || '';
            const val = (sel==='__OTHER__') ? txt.trim() : sel.trim();
            if(!val) { Swal.showValidationMessage('Please choose or type a reason.'); return false; }
            return val;
          },
          didOpen:()=>{
            const sel=document.getElementById('rejSel');
            const txt=document.getElementById('rejTxt');
            sel.addEventListener('change', ()=>{
              if(sel.value==='__OTHER__'){ txt.style.display='block'; txt.focus(); }
              else { txt.style.display='none'; txt.value=''; }
            });
          }
        });
        if(!out.isConfirmed) return;
        payload.reason = out.value;
      }

      $.ajax({
        url: ENDPOINT_SET_STATUS,
        method: 'POST',
        dataType: 'json',
        contentType: 'application/json',
        data: JSON.stringify(payload),
        success: function(res){
          if(res && res.status==='success'){ fetchAndRefreshIfChanged(true); }
          else { showModal((res&&res.message)||'Failed to update status.'); }
        },
        error: function(xhr){ console.error(xhr.responseText); showModal('Error updating status.'); }
      });
    }

    /* ====== AMOUNTS MODAL ====== */
    function enableSaveButton(enabled){
      $('#saveReleaseFooter').prop('disabled', !enabled);
    }

    function showAmounts(appId){
      $('#amountsBody').html('<div class="muted">Loading…</div>');
      enableSaveButton(false);
      openModal('#amountsModal');

      $.getJSON(`${ENDPOINT_AMOUNTS}?application_id=${encodeURIComponent(appId)}`, function(res){
        if(res && !res.error){
          const asked     = Number(res.requested_amount ?? 0);
          const current   = (res.release_amount===null || res.release_amount==='') ? '' : Number(res.release_amount).toFixed(2);
          const count     = Number(res.update_count ?? 0);
          const remaining = Math.max(0, 2 - count);

          const lastAmount = current!=='' ? Number(current) : null;
          const lastWhenDt = parseDbDate(res.release_updated_at || null);
          const lastWhen   = lastWhenDt ? fmtUK.format(lastWhenDt) : null;

          const warn = (remaining>0)
            ? `<span class="muted">You can change the release amount <b>${remaining}</b> more time${remaining>1?'s':''}.</span>`
            : `<span class="text-danger">Change limit reached (2). Further updates are blocked.</span>`;

          const highlightBox = `
            <div class="am-highlight">
              <div class="am-caption">Current / Last release amount</div>
              <div class="am-ask" style="font-size:1.1rem">
                ${lastAmount!==null ? lastAmount.toLocaleString('en-GB',{style:'currency',currency:'GBP'}) : '—'}
              </div>
              ${lastWhen ? `<div class="am-caption">Updated: ${lastWhen}</div>`:''}
            </div>`;

          const html = `
            <div class="am-card">
              <h6>Requested vs Release</h6>
              <div class="am-line">
                <div>Requested Amount</div>
                <div class="am-ask">${asked.toLocaleString('en-GB',{style:'currency',currency:'GBP'})}</div>
              </div>
              <div class="am-line">
                <div>Release Amount</div>
                <div style="min-width:280px;max-width:380px">
                  <input type="number" step="0.01" min="0" id="releaseAmountInput" class="form-control form-control-sm" placeholder="0.00" value="${current}">
                  <div class="mt-2">${warn}</div>
                </div>
              </div>
              <div class="mt-2">${highlightBox}</div>
            </div>
          `;
          $('#amountsBody').html(html);

          // Close handlers
          $('#cancelReleaseFooter').off('click').on('click', ()=>closeModal('#amountsModal'));
          $('.close-amounts').off('click').on('click', ()=>closeModal('#amountsModal'));

          // Save handler
          $('#saveReleaseFooter').off('click').on('click', function(){
            const raw = $('#releaseAmountInput').val();
            if(raw===''||raw===null){ showModal('Please enter release amount.'); return; }
            const num = Number(raw);
            if(!Number.isFinite(num) || num<=0){ showModal('Release amount must be a positive number.'); return; }
            if(num > asked){ showModal('Release amount cannot exceed the requested amount.'); return; }

            $.ajax({
              url: ENDPOINT_SET_RELEASE,
              method: 'POST',
              dataType: 'json',
              contentType: 'application/json',
              data: JSON.stringify({ application_id: appId, release_amount: num }),
              success: function(r){
                if(r && r.status==='success'){
                  closeModal('#amountsModal');
                  showModal('Release amount saved.');
                  fetchAndRefreshIfChanged(true);
                }else{
                  showModal((r&&r.message)||'Failed to save.');
                }
              },
              error: function(xhr){ console.error(xhr.responseText); showModal('Error saving amount.'); }
            });
          });

          // Enable/disable save button based on value + limit
          function recomputeSaveState(){
            const v = $('#releaseAmountInput').val();
            const okNum = v!=='' && Number(v)>0 && Number(v) <= asked;
            enableSaveButton(remaining>0 && okNum);
          }
          $('#releaseAmountInput').on('input', recomputeSaveState);
          recomputeSaveState();
        } else {
          $('#amountsBody').html('<div class="text-danger">Failed to load amounts.</div>');
        }
      }).fail(()=>$('#amountsBody').html('<div class="text-danger">Failed to load amounts.</div>'));
    }

    /* ====== FLOATING STATUS MENU (portal) ====== */
    let flyMenu = null;
    let flyCloseHandlersBound = false;

    function closeFlyMenu(){
      if(flyMenu){ flyMenu.remove(); flyMenu = null; }
    }

    function bindGlobalCloseHandlers(){
      if (flyCloseHandlersBound) return;
      flyCloseHandlersBound = true;

      $(document).on('click.flymenu', function(){ closeFlyMenu(); });
      $(document).on('keydown.flymenu', function(e){ if(e.key==='Escape') closeFlyMenu(); });

      const wrapper = tableEl.closest('.dataTables_wrapper');
      const scrollBody = wrapper.find('.dataTables_scrollBody');
      $(window).on('scroll.flymenu', closeFlyMenu);
      scrollBody.on('scroll.flymenu', closeFlyMenu);
    }

    function openFlyMenuFor(buttonEl, row){
      closeFlyMenu(); // ensure one at a time

      flyMenu = $(`
        <div class="fly-menu" role="menu" aria-label="Change Status">
          <div class="fly-item fly-pending"  data-status="Pending"><i class="mdi mdi-clock-outline"></i> Pending</div>
          <div class="fly-item fly-process"  data-status="In Process"><i class="mdi mdi-cog-outline"></i> In Process</div>
          <div class="fly-item fly-rejected" data-status="Rejected"><i class="mdi mdi-close-circle-outline"></i> Rejected</div>
          <div class="fly-sep"></div>
          <div class="fly-item fly-verified" data-status="Verified" title="Requires all docs verified"><i class="mdi mdi-check-decagram-outline"></i> Verified</div>
        </div>
      `).appendTo(document.body);

      flyMenu.addClass('show').css({left:-9999, top:-9999});
      const mw = flyMenu.outerWidth(), mh = flyMenu.outerHeight();

      const rect = buttonEl.getBoundingClientRect();
      const vw = window.innerWidth, vh = window.innerHeight;

      let top = rect.bottom + 8;
      let left = rect.left;

      if (top + mh > vh) { // flip up
        top = rect.top - mh - 8;
        if (top < 8) top = Math.max(8, vh - mh - 8);
      }
      if (left + mw > vw - 8) left = vw - mw - 8;
      if (left < 8) left = 8;

      flyMenu.css({left: Math.round(left), top: Math.round(top)});

      flyMenu.on('click', function(e){ e.stopPropagation(); });

      flyMenu.on('click', '.fly-item', async function(){
        const target = $(this).data('status');
        closeFlyMenu();
        await changeStatus(row, target);
      });

      bindGlobalCloseHandlers();
    }

    /* ====== DATATABLE ====== */
    table = tableEl.DataTable({
      data: [],
      columns: [
        { data: 'application_ref_id' },
        { data: 'client_name' },
        { data: 'loan_type', render: d => d || 'N/A' },
        { data: 'loan_amount', render: d => gbp(d) },
        { data: 'status', orderable: false, render: d => statusBadgeHtml(d) },
        {
          data: 'createdat',
          render: function(d){
            const dt = parseDbDate(d);
            const label = timeAgoUK(dt);
            const tip = dt ? fmtUK.format(dt) : '';
            return `<span title="${tip.replace(/"/g,'&quot;')}">${label}</span>`;
          }
        },
        {
          data: 'status_date',
          render: function(d){
            const dt = parseDbDate(d);
            return dt ? fmtUK.format(dt) : 'N/A';
          }
        },
        {
          data: null,
          orderable: false,
          searchable: false,
          className: 'text-nowrap',
          render: function(row){
            return `
               <div class="act-row" data-app="${row.application_id}">
                <button type="button" class="act-btn js-status-open" title="Change Status">
                  <i class="mdi mdi-tune-variant"></i> Status
                </button>
                <button type="button" class="act-btn js-amounts" title="View / Edit Amounts" data-app-id="${row.application_id}">
                  <i class="mdi mdi-currency-gbp"></i>
                </button>
                <a class="act-btn" title="Business Details"
                   href="pages/requireds/BusinessDetails.php?application_id=${row.application_id}">
                  <i class="mdi mdi-briefcase-outline"></i>
                </a>
                <a class="act-btn" title="Client Details"
                   href="pages/requireds/Clientdetails.php?id=${row.customer_id}">
                  <i class="mdi mdi-eye"></i>
                </a>
                <a class="act-btn" title="Documents"
                   href="pages/requireds/ClientadditionalDetails.php?application_id=${row.application_id}">
                  <i class="mdi mdi-file-document"></i>
                </a>
              </div>`;
          }
        }
      ],
      order: [[5, 'desc']],
      pageLength: 10,
      lengthMenu: [10, 25, 50, 100],
      deferRender: true,
      processing: true,
      responsive: false,
      scrollX: true,
      scrollY: '56vh',       /* table-only vertical scroll */
      scrollCollapse: true,
      autoWidth: false,
      columnDefs: [
        { targets: 0, width: 100 },
        { targets: 1, width: 200 },
        { targets: 2, width: 140 },
        { targets: 3, width: 140 },
        { targets: 4, width: 220 },
        { targets: 5, width: 160 },
        { targets: 6, width: 200 },
        { targets: 7, width: 460 }
      ],
      dom:
        "<'row mb-2'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row mt-2'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
      initComplete: function(){
        this.api().columns.adjust();
        injectToolbar();
        updateDocStatusesForVisibleRows();
      },
      drawCallback: function(){
        this.api().columns.adjust();
        updateDocStatusesForVisibleRows();
      }
    });

    /* ====== EVENTS ====== */
    // Open floating Status menu
    tableEl.on('click', '.js-status-open', function(e){
      e.stopPropagation();
      const row = table.row($(this).closest('tr')).data();
      if(!row) return;
      openFlyMenuFor(this, row);
    });

    // Amounts modal open
    tableEl.on('click', '.js-amounts', function(){
      const appId=$(this).data('app-id');
      if(!appId) return;
      showAmounts(appId);
    });

    // Response modal close
    $('.close, .js-close-response').on('click', function(){ closeModal('#responseModal'); });

    // Click on overlay closes
    $(document).on('click', function(e){
      if($(e.target).is('#responseModal')) closeModal('#responseModal');
      if($(e.target).is('#amountsModal')) closeModal('#amountsModal');
    });
    // ESC closes topmost modals (fly-menu handled separately)
    $(document).on('keydown', function(e){
      if(e.key === 'Escape'){
        if($('#amountsModal').hasClass('open')) closeModal('#amountsModal');
        else if($('#responseModal').hasClass('open')) closeModal('#responseModal');
      }
    });

    // Alert modal helper
    function showModal(message){
      $('#responseMsg').html(message);
      openModal('#responseModal');
    }

    // Fetch + smart refresh (also refresh doc overlays)
    function fetchAndRefreshIfChanged(force=false){
      $.getJSON(ENDPOINT_LIST, function(rows){
        if(!Array.isArray(rows)){ console.error('Unexpected response:', rows); return; }
        const sig=buildSignature(rows);
        if(force || sig!==previousSignature){
          previousSignature=sig;
          table.clear().rows.add(rows).draw(false);
          updateDocStatusesForVisibleRows();
        }
      }).fail(function(xhr,st,err){
        console.error('Fetch error:', err, xhr.responseText);
      });
    }

    // Initial + polling
    fetchAndRefreshIfChanged(true);
    setInterval(fetchAndRefreshIfChanged, 10000);
  });
  </script>
</body>
</html>
