<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8" />
  <title>EZY LEND</title>
</head>
<body>
  <div class="container-scroller">
    <!-- navbar -->
    <?php include '../../partials/navbar.php'; ?>  
    <!-- navbar -->
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- settings -->
      <?php include '../../partials/settings.php'; ?>  
      <!-- settings -->
      <!-- sidebar -->
      <?php include '../../partials/sidebar.php'; ?>   
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="col-md-8 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <form id="feeForm">
                  <div class="form-row">
                    <div class="form-group col-md-12">
  <label for="chargesType">Update Charges</label>
  <div class="input-group mb-3">

    <!-- Loan Type -->
    <select class="form-control mr-2" id="chargeMode" name="chargeMode" style="max-width: 150px;" required>
      <option value="">Loan type</option>
      <option value="EZYCASH">EZYCASH</option>
      <option value="Instant">Instant</option>
    </select>

    <!-- Charges Type -->
    <select class="form-control mr-2" id="chargesType" name="chargesType" style="max-width: 180px;" required>
      <option value="">Charges Type</option>
      <option value="Legal Charges">Legal Charges</option>
      <option value="Processing Fee">Processing Fee</option>
      <option value="Interest">Interest</option>
      <option value="Paperwork">Paperwork</option>
      <option value="Valuation">Valuation</option>
    </select>

    <!-- Amount -->
    <input type="text" class="form-control mr-2" name="amount" id="amount" placeholder="Enter amount" style="max-width: 150px;" required />

    <!-- Change Reason -->
    <input type="text" class="form-control mr-2" id="change_reason" name="change_reason" placeholder="Change reason (optional)" style="max-width: 250px;" />

    <!-- Update Button (type=button) -->
    <div class="input-group-append">
      <button class="btn btn-sm btn-primary" type="button" id="updateBtn">Update</button>
    </div>
  </div>
</div>

                    
                  </div>
                </form>
              </div>
            </div>
          </div>

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">Charges Details</h4>
                <div class="table-responsive pt-3">
                  <table class="table table-bordered">
  <thead>
    <tr>
      <th>Type</th>
      <th>Legal Charges</th>
      <th>Processing Fee</th>
      <th>Interest</th>
      <th>Paperwork</th>
      <th>Valuation</th>
    </tr>
  </thead>
  <tbody>
    <!-- Dynamic rows will be inserted here -->
  </tbody>
</table>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!--footer -->
        <?php include '../../partials/footer.php'; ?>  
        <!--footer -->
      </div>
    </div>   
<!-- Modal Structure -->
<div class="modal" id="responseModal">
  <div class="modal-content">
    <div id="responseMsg" class="mt-2"></div>
  </div>
</div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  

  <?php include '../../partials/loadjs.php'; ?>  

  <!-- JavaScript Section -->
  <script>
 // Show the Modal with the Response Message
function showModal(message, type) {
  const modal = document.getElementById('responseModal');
  const responseMsg = document.getElementById('responseMsg');
  responseMsg.innerHTML = message;
  responseMsg.className = type;

  // Show the modal with the slide effect
  modal.classList.add('show');

  // Hide the modal after 3 seconds
  setTimeout(function() {
    closeModal();
  }, 3000); // Adjust time as needed
}

// Close the Modal
function closeModal() {
  const modal = document.getElementById('responseModal');
  modal.classList.remove('show');
}

// Handle form submission on clicking the update button
document.getElementById('updateBtn').addEventListener('click', function() {
  document.getElementById('feeForm').dispatchEvent(new Event('submit'));
});

// Handle form submission (triggered by clicking the update button)
document.getElementById('feeForm').addEventListener('submit', function (e) {
  e.preventDefault();

  const chargeMode = document.getElementById('chargeMode').value.trim();
  const chargesType = document.getElementById('chargesType').value.trim();
  const amountInput = document.getElementById('amount').value.trim();
  const reason = document.getElementById('change_reason').value.trim();

  // Basic validation
  if (!chargeMode || !chargesType || !amountInput) {
    showModal("Please fill in all required fields.", "text-danger");
    return;
  }

  const amount = parseFloat(amountInput);
  const decimalCheck = /^\d{1,3}(\.\d{1,2})?$/;  // Regex for validating numbers with up to 2 decimal places

  // Validate amount for Interest charge type (only up to 2 decimal places)
  if (chargesType === "Interest" && (!decimalCheck.test(amountInput) || amount < 0 || amount > 100)) {
    showModal("Interest amount must be a valid number with up to 2 decimal places, and between 0 and 100.", "text-danger");
    return;
  }

  // Allow any amount for other charge types
  if (chargesType !== "Interest" && isNaN(amount)) {
    showModal("Amount must be a valid number.", "text-danger");
    return;
  }

  // Submit with AJAX
  const formData = new FormData();
  formData.append("chargeMode", chargeMode);
  formData.append("chargesType", chargesType);
  formData.append("amount", amount);
  formData.append("change_reason", reason);

  fetch("includes/updatecharges.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.text())
  .then(data => {
    showModal(data, "text-success"); // Show the success modal
    loadLoanFeeData(); // Reload the table data after the update

    // Clear the form fields after successful update
    clearFormFields();
  })
  .catch(err => {
    showModal("Error submitting data.", "text-danger");
  });
});

// Function to restrict amount input to numbers only (including decimals)
document.getElementById('amount').addEventListener('input', function(e) {
  // Remove any non-numeric characters except decimal point
  this.value = this.value.replace(/[^0-9.]/g, '');

  // Ensure only one decimal point is allowed
  if (this.value.indexOf('.') !== -1) {
    this.value = this.value.replace(/\.+$/, '');  // Remove additional decimal points
  }
});

// Function to load loan fee data into the table
function loadLoanFeeData() {
  var xhr = new XMLHttpRequest();
  xhr.open("GET", "includes/fetch_loanfee_data.php", true);
  xhr.onload = function () {
    if (xhr.status === 200) {
      var data = JSON.parse(xhr.responseText);
      var tableBody = document.querySelector("table tbody");
      tableBody.innerHTML = ""; // Clear existing rows

      // Loop through the data and add rows to the table
      data.forEach(function(row) {
        var tr = document.createElement("tr");

        var tdType = document.createElement("td");
        tdType.textContent = row.loan_type_name; // Loan type
        tr.appendChild(tdType);

        var tdLegalCharges = document.createElement("td");
        tdLegalCharges.textContent = row['Legal Charges']; // Legal Charges
        tr.appendChild(tdLegalCharges);

        var tdProcessingFee = document.createElement("td");
        tdProcessingFee.textContent = row['Processing Fee']; // Processing Fee
        tr.appendChild(tdProcessingFee);

        var tdInterest = document.createElement("td");
        tdInterest.textContent = row['Interest']; // Interest
        tr.appendChild(tdInterest);

        var tdPaperwork = document.createElement("td");
        tdPaperwork.textContent = row['Paperwork']; // Paperwork
        tr.appendChild(tdPaperwork);

        var tdValuation = document.createElement("td");
        tdValuation.textContent = row['Valuation']; // Valuation
        tr.appendChild(tdValuation);

        tableBody.appendChild(tr);
      });
    } else {
      console.error("Failed to fetch loan fee data.");
    }
  };
  xhr.onerror = function() {
    console.error("Request failed.");
  };
  xhr.send();
}

// Function to clear form fields after update
function clearFormFields() {
  document.getElementById('chargeMode').value = '';
  document.getElementById('chargesType').value = '';
  document.getElementById('amount').value = '';
  document.getElementById('change_reason').value = '';
}

// Call the function to load the data when the page loads
window.onload = function() {
  loadLoanFeeData();
};

</script>


</body>
</html>
