<?php include 'partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <title>EZY LEND</title>
   
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
  <div class="container-scroller">
    <!-- navbar -->
     <?php include 'partials/navbar.php'; ?>  
    <!-- navbar -->
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- settings -->
      <?php include 'partials/settings.php'; ?>  
      <!-- settings -->
      <!-- sidebar-->
       <?php include 'partials/sidebar.php'; ?>   
       <div class="main-panel">
        <div class="content-wrapper">
                    
         <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
</div>
</div>
</div>

<div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Client Details</h4>
                  
                      
                  <form class="clientform" id="editCustomerForm">
                <input type="hidden" id="customerId" name="customerId">

                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="prefix">Prefix</label>
                            <select class="form-control" id="prefix" name="prefix">
                                <option>Mr</option>
                                <option>Ms</option>
                                <option>Mrs</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label for="firstName">First Name</label>
                            <input type="text" class="form-control" id="firstName" name="firstName" placeholder="Tony" required>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label for="lastName">Last Name</label>
                            <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Stark" required>
                        </div>
                    </div>
                </div>
            
                <div class="row mt-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="phoneNumber">Phone Number</label>
                            <div class="input-group">
                                <span class="input-group-text">+44</span>
                                <input type="text" class="form-control" id="phoneNumber" name="phoneNumber" placeholder="123456789">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="customerEmail">Email</label>
                            <input type="email" class="form-control" id="customerEmail" name="customerEmail" placeholder="tonystark@gmail.com" required>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="dob">Date of Birth</label>
                            <input type="date" class="form-control" id="dob" name="dob">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select class="form-control" id="gender" name="gender">
                                <option>Male</option>
                                <option>Female</option>
                                <option>Other</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="aptNo">Apt No.</label>
                            <input type="text" class="form-control" id="aptNo" name="aptNo" placeholder="Apt. 2003">
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="addressLine1">Address</label>
                            <input type="text" class="form-control" id="addressLine1" name="addressLine1" placeholder="Caroline St">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="postcode">Postcode</label>
                            <input type="text" class="form-control" id="postcode" name="postcode" placeholder="CF10 1AF">
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary me-2">Update</button>
                    <a href="alllenddetails.php" class="btn btn-light">Back</a>
                </div>
            </form>
                </div>
              </div>
            </div>
<!--footer -->
        <?php include 'partials/footer.php'; ?>  
        <!--footer -->
</div>

        </div>   
   
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->
   <?php include 'partials/loadjs.php'; ?>  

   <script>
  const birthdateInput = document.getElementById('birthdate');

  const today = new Date();
  const fifteenYearsAgo = new Date();
  fifteenYearsAgo.setFullYear(today.getFullYear() - 15);

  // Set max to 15 years ago from today
  birthdateInput.max = fifteenYearsAgo.toISOString().split('T')[0];
</script>
<script>
$(document).ready(function() {
    // --- PART 1: LOAD CUSTOMER DATA ON PAGE LOAD ---
    const urlParams = new URLSearchParams(window.location.search);
    const customerId = urlParams.get('id');

    if (customerId) {
        $('#customerIdDisplay').text(customerId);
        
        // Fetch customer data from the API
        $.ajax({
            url: `includes/get_customer.php?id=${customerId}`,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                if (data.error) {
                    Swal.fire('Error', data.error, 'error');
                } else {
                    // Populate the form fields with the fetched data
                    $('#customerId').val(data.customer_id);
                    $('#prefix').val(data.prefix);
                    $('#firstName').val(data.first_name);
                    $('#lastName').val(data.last_name);
                    $('#phoneNumber').val(data.phone_number);
                    $('#customerEmail').val(data.customer_email);
                    $('#dob').val(data.dob);
                    $('#gender').val(data.gender);
                    $('#aptNo').val(data.apt_no);
                    $('#addressLine1').val(data.address_line1);
                    $('#postcode').val(data.postcode);
                }
            },
            error: function(xhr, status, error) {
                Swal.fire('Error', 'Could not fetch customer details.', 'error');
            }
        });
    } else {
        Swal.fire('Error', 'No Customer ID provided.', 'error');
    }

    // --- PART 2: HANDLE FORM SUBMISSION FOR UPDATE ---
    $('#editCustomerForm').on('submit', function(event) {
        event.preventDefault(); // Prevent the default form submission

        // Show a confirmation dialog
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to save these changes?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, update it!'
        }).then((result) => {
            if (result.isConfirmed) {
                // If confirmed, proceed with the update
                const formData = {
                    customerId: $('#customerId').val(),
                    prefix: $('#prefix').val(),
                    firstName: $('#firstName').val(),
                    lastName: $('#lastName').val(),
                    phoneNumber: $('#phoneNumber').val(),
                    customerEmail: $('#customerEmail').val(),
                    dob: $('#dob').val(),
                    gender: $('#gender').val(),
                    aptNo: $('#aptNo').val(),
                    addressLine1: $('#addressLine1').val(),
                    postcode: $('#postcode').val()
                };

                $.ajax({
                    url: 'includes/update_customer.php',
                    type: 'POST',
                    contentType: 'application/json',
                    data: JSON.stringify(formData),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire('Updated!', response.message, 'success');
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error!', 'An unknown error occurred while updating.', 'error');
                    }
                });
            }
        });
    });
});
</script>

       </body>
</html>