<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>EZY LEND</title>

  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">

  <style>
    .dt-scroll-wrap{width:100%;overflow-x:auto;-webkit-overflow-scrolling:touch}
    #allloanTable td,#allloanTable th{white-space:nowrap;vertical-align:middle}
    .dt-toolbar{display:flex;align-items:center;gap:.5rem;flex-wrap:wrap;justify-content:flex-end}
    @media (max-width:576px){table.dataTable td,table.dataTable th{padding:.5rem .6rem!important}}

    /* Action buttons */
    .act-btn{
      border:1px solid #e5e7eb;background:#fff;border-radius:.65rem;
      padding:.42rem .6rem;cursor:pointer;transition:all .18s ease;
      box-shadow:0 1px 0 rgba(0,0,0,.03)
    }
    .act-btn:hover{background:#f3f4f6;transform:translateY(-1px)}
    .act-row{display:flex;gap:.4rem;align-items:center}

    /* Dropdown (clearer + subtle animation) */
    .dd{position:relative;display:inline-block}
    .dd-btn{
      border:1px solid #e5e7eb;background:#fff;border-radius:.65rem;
      padding:.42rem .6rem;cursor:pointer;display:inline-flex;align-items:center;gap:.4rem;
      transition:all .18s ease
    }
    .dd-btn:hover{background:#f3f4f6;transform:translateY(-1px)}
    .dd-menu{
      position:absolute;top:110%;left:0;min-width:235px;background:#fff;border:1px solid #e5e7eb;
      border-radius:.65rem;box-shadow:0 16px 32px rgba(2,6,23,.10), 0 4px 10px rgba(2,6,23,.06);
      padding:.4rem;z-index:20;display:block;opacity:0;visibility:hidden;transform:translateY(6px) scale(.98);
      transition:opacity .18s ease, transform .2s cubic-bezier(.2,.7,.2,1), visibility 0s linear .18s
    }
    .dd.open .dd-menu{opacity:1;visibility:visible;transform:translateY(0) scale(1);transition-delay:0s}
    .dd-item{
      display:flex;align-items:center;gap:.65rem;padding:.5rem .6rem;border-radius:.5rem;cursor:pointer;font-weight:500
    }
    .dd-item i{font-size:18px}
    .dd-item:hover{background:#eef2ff}
    .dd-sep{height:1px;background:#e5e7eb;margin:.3rem 0}
    .dd-pending  i{color:#64748b}
    .dd-process  i{color:#0ea5e9}
    .dd-rejected i{color:#ef4444}
    .dd-verified i{color:#10b981}

    .muted{color:#6b7280}
    .badge.bg-warning{background:#fde68a!important;color:#1f2937!important}
    .badge.bg-info{background:#bae6fd!important;color:#111827!important}
.bg-purple {
  background-color:#6f42c1!important;
  color:#fff!important;
}

    /* === Pretty, animated modal (no Bootstrap JS needed) === */
    .modal{
      position:fixed; inset:0; display:flex; align-items:center; justify-content:center;
      visibility:hidden; opacity:0; pointer-events:none;
      background:rgba(2,6,23,.50); backdrop-filter:blur(2.5px);
      transition:opacity .22s ease, visibility 0s linear .22s; z-index:1055
    }
    .modal.open{visibility:visible; opacity:1; pointer-events:auto; transition-delay:0s}
    .modal .modal-content{
      width:min(720px, calc(100% - 32px));   /* default modal width */
      background:linear-gradient(180deg,#ffffff,#fdfdfd);
      border:1px solid #e5e7eb; border-radius:16px; overflow:hidden;
      transform:translateY(16px) scale(.985); opacity:.98;
      box-shadow:0 22px 70px rgba(2,6,23,.22), 0 8px 26px rgba(2,6,23,.12);
      transition:transform .24s cubic-bezier(.2,.7,.2,1), opacity .22s ease
    }
    .modal.open .modal-content{transform:translateY(0) scale(1); opacity:1}

    /* >>> Force wider Amounts modal (1200px) <<< */
    #amountsModal.modal .modal-content{
      width: 1200px !important;
      max-width: calc(100% - 32px) !important; /* keep 16px gutter on each side */
    }

    .modal-header{
      display:flex;align-items:center;justify-content:space-between;
      padding:14px 16px;border-bottom:1px solid #eef2f7;background:#f8fafc
    }
    .modal-title{margin:0;font-weight:700;font-size:1.05rem;display:flex;align-items:center;gap:.5rem}
    .modal-body{padding:16px}
    .modal-footer{padding:12px 16px;border-top:1px solid #eef2f7;background:#fbfbfb;display:flex;gap:.5rem;justify-content:flex-end}
    .btn-ghost{
      border:1px solid #e5e7eb;background:#fff;border-radius:.6rem;padding:.45rem .75rem;cursor:pointer
    }
    .btn-primary{
      border:1px solid #2563eb;background:#2563eb;color:#fff;border-radius:.6rem;padding:.45rem .75rem;cursor:pointer
    }
    .btn-primary:disabled{opacity:.5;cursor:not-allowed}
    .close, .close-amounts{border:none;background:transparent;font-size:22px;line-height:1;cursor:pointer}

    /* Amounts modal layout (single column now) */
    .am-card{
      border:1px solid #e5e7eb;border-radius:12px;padding:14px;background:#fff
    }
    .am-card h6{margin:0 0 8px 0;font-weight:700}
    .am-line{display:flex;justify-content:space-between;align-items:center;padding:6px 0;border-bottom:1px dashed #eef2f7}
    .am-line:last-child{border-bottom:0}
    .am-ask{font-weight:700}
    .am-highlight{
      border:1px solid #dbeafe;background:#eff6ff;border-radius:10px;padding:8px 10px
    }
    .am-caption{font-size:.85rem;color:#6b7280}
    .gap-8{gap:.5rem}
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>

    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">All Lend Details</h4>

                <div class="dt-scroll-wrap">
                  <table id="allloanTable" class="table table-hover table-striped" style="width:100%">
                    <thead>
                      <tr>
                        <th>Customer ID</th>
                        <th>Customer Name</th>
                        <th>Phone</th>
                        <th>Ongoing Loans</th>
                        <th>Status</th>
                        <th>Applied</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>

              </div>
            </div>
          </div>

          <!-- Modal: Response / Alerts -->
          <div class="modal" id="responseModal" aria-hidden="true">
            <div class="modal-content" role="dialog" aria-modal="true" aria-labelledby="respTitle">
              <div class="modal-header">
                <div class="modal-title" id="respTitle">
                  <i class="mdi mdi-information-outline"></i>
                  Notice
                </div>
                <button class="close" aria-label="Close">&times;</button>
              </div>
              <div class="modal-body">
                <div id="responseMsg" class="mt-2"></div>
              </div>
              <div class="modal-footer">
                <button class="btn-ghost js-close-response">Close</button>
              </div>
            </div>
          </div>

         

        </div><!-- content-wrapper -->
      </div><!-- main-panel -->
    </div><!-- page-body-wrapper -->

    <?php include '../../partials/footer.php'; ?>
  </div><!-- container-scroller -->

  <?php include '../../partials/loadjs.php'; ?>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- DataTables JS -->
  <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

 
</body>
</html>
