<?php include '../../partials/loadcss.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>EZY LEND</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    /* ---------- centered modal for Add/Edit ---------- */
    .xmodal{
      position:fixed; inset:0; z-index:1050; display:flex;
      align-items:center; justify-content:center;
      padding:24px;
      background:rgba(15,23,42,.32);
      opacity:0; visibility:hidden; transition:opacity .25s ease, visibility .25s ease;
      backdrop-filter: blur(1px);
    }
    .xmodal.show{ opacity:1; visibility:visible; }
    .xmodal .xpanel{
      width:min(760px, 96vw);
      background:#fff; border:1px solid #e5e7eb; border-radius:12px;
      box-shadow:0 22px 60px rgba(2,6,23,.20), 0 6px 16px rgba(2,6,23,.12);
      padding:16px 18px;
      max-height: calc(100vh - 80px);
      overflow:auto;
      transform: scale(.985) translateY(6px); opacity:0;
      transition: transform .22s cubic-bezier(.2,.8,.2,1), opacity .22s ease;
      position:relative;
    }
    .xmodal.show .xpanel{ transform: scale(1) translateY(0); opacity:1; }
    .x-close{
      position:absolute; top:10px; right:10px;
      border:none; background:#f1f5f9; color:#111827; border-radius:8px;
      padding:.3rem .5rem; line-height:1; cursor:pointer;
    }

    /* ---------- SAME SUCCESS MODAL STYLE AS YOUR FEES PAGE ---------- */
    .modal{ position:fixed; inset:0; display:none; align-items:center; justify-content:center; z-index:2000; }
    .modal.show{ display:flex; }
    .modal .modal-content{
      background:#fff; border:1px solid #e5e7eb; border-radius:10px;
      padding:16px 18px; max-width:600px; width:calc(100% - 32px);
      box-shadow:0 20px 50px rgba(2,6,23,.25), 0 6px 16px rgba(2,6,23,.15);
      text-align:center;
    }

    /* Badges in table */
    .badge-dot{ display:inline-flex; align-items:center; gap:6px; padding:2px 10px; border-radius:999px; font-size:12px; border:1px solid #e5e7eb; background:#fff; cursor:default; }
    .badge-active{ color:#065f46; border-color:#a7f3d0; background:#ecfdf5; }
    .badge-inactive{ color:#991b1b; border-color:#fecaca; background:#fff1f2; }
    .badge-click{ cursor:pointer; }

    /* tiny img thumb */
    .thumb{ width:40px; height:40px; border-radius:6px; object-fit:cover; border:1px solid #e5e7eb; }

    /* Uploader square */
    .uploader{
      width:140px; height:140px; border:2px dashed #cbd5e1; border-radius:12px;
      display:flex; align-items:center; justify-content:center; position:relative;
      background:#f8fafc; cursor:pointer; user-select:none;
      transition: border-color .15s ease, background .15s ease;
    }
    .uploader:hover{ border-color:#94a3b8; background:#f1f5f9; }
    .uploader .plus{ display:flex; flex-direction:column; align-items:center; gap:6px; color:#64748b; font-size:12px; }
    .uploader .plus i{ font-size:22px; }
    .uploader img{ position:absolute; inset:0; width:100%; height:100%; object-fit:cover; border-radius:10px; display:none; }
    .uploader .remove{
      position:absolute; top:6px; right:6px; border:none;
      background:rgba(255,255,255,.95); border-radius:999px; width:28px; height:28px;
      display:none; align-items:center; justify-content:center; cursor:pointer;
      box-shadow:0 2px 6px rgba(0,0,0,.18);
    }
    .uploader.has-image .plus{ display:none; }
    .uploader.has-image img{ display:block; }
    .uploader.has-image .remove{ display:flex; }

    .form-row .form-group{ margin-bottom:12px; }
    .form-inline-gap{ display:flex; flex-wrap:wrap; gap:8px; }

    /* pagination footer */
    .table-footer{
      display:flex; align-items:center; justify-content:space-between; gap:8px; padding-top:10px;
      flex-wrap:wrap;
    }
    .pagination{ margin:0; }
    .pagination .page-link{ line-height:1.1; padding:.35rem .6rem; }
  </style>
</head>
<body>
  <div class="container-scroller">
    <?php include '../../partials/navbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
      <?php include '../../partials/settings.php'; ?>
      <?php include '../../partials/sidebar.php'; ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <!-- spacer -->
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card"><div class="card-body"></div></div>
          </div>

          <!-- Controls + Add button -->
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-between mb-3">
                  <h4 class="card-title mb-0">Notifications</h4>
                  <button class="btn btn-sm btn-primary" id="btnAddNew">Add New Notification</button>
                </div>

                <form id="filterForm" class="form-inline-gap mb-3">
                  <select id="filterStatus" class="form-control" style="max-width:180px;">
                    <option value="all">All</option>
                    <option value="active" selected>Active</option>
                    <option value="inactive">Inactive</option>
                  </select>
                  <select id="filterAudience" class="form-control" style="max-width:200px;">
                    <option value="all" selected>All audiences</option>
                    <option value="backend">Backend</option>
                    <option value="consumer">Consumer</option>
                  </select>
                  <input type="text" id="filterSearch" class="form-control" placeholder="Search title/body…" style="max-width:300px;">
                  <button type="submit" class="btn btn-inverse-primary btn-sm">Apply</button>
                  <button type="button" class="btn btn-light btn-sm" id="btnReset">Reset</button>
                </form>

                <div class="table-responsive pt-1">
                  <table class="table table-bordered" id="notifTable">
                    <thead>
                      <tr>
                        <th style="width:48px;">Img</th>
                        <th>Title</th>
                        <th>Category</th>
                        <th>Audience</th>
                        <th>Body</th>
                        <th>Linked</th>
                        <th>Created</th>
                        <th style="width:110px;">Status</th>
                        <th style="width:90px;">Actions</th>
                      </tr>
                    </thead>
                    <tbody><!-- rows injected dynamically --></tbody>
                  </table>
                </div>

                <!-- footer: rows + pager -->
                <div class="table-footer">
                  <div>
                    <label class="mr-1 text-muted">Rows</label>
                    <select id="rowsSel" class="form-control d-inline-block" style="width:80px;">
                      <option>10</option><option>25</option><option>50</option>
                    </select>
                  </div>
                  <div id="tableMeta" class="text-muted small"></div>
                  <nav>
                    <ul id="pager" class="pagination pagination-sm mb-0"></ul>
                  </nav>
                </div>

              </div>
            </div>
          </div>

          <?php include '../../partials/footer.php'; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Add/Edit Modal -->
  <div class="xmodal" id="editModal" role="dialog" aria-modal="true">
    <div class="xpanel">
      <button type="button" class="x-close" id="editCloseBtn" title="Close">
        <i class="mdi mdi-close"></i>
      </button>

      <h5 id="modalTitle" class="mb-2">Add Notification</h5>

      <form id="editForm">
        <input type="hidden" id="notification_id" name="notification_id">

        <div class="form-row">
          <div class="form-group col-md-6">
            <label>Category</label>
            <select class="form-control" id="category" name="category" required></select>
          </div>
          <div class="form-group col-md-6">
            <label>Audience</label>
            <select class="form-control" id="audience" name="audience" required>
              <option value="backend">Backend</option>
              <option value="consumer">Consumer</option>
            </select>
          </div>
        </div>

        <div class="form-group">
          <label>Title</label>
          <input type="text" class="form-control" id="title" name="title" required>
        </div>

        <div class="form-group">
          <label>Body</label>
          <textarea class="form-control" id="body" name="body" rows="3" placeholder="Notification content"></textarea>
        </div>

        <div class="form-group">
          <label>Image</label><br>
          <div class="uploader" id="uploader">
            <div class="plus"><i class="mdi mdi-plus"></i><span>Add image</span></div>
            <img id="uploadPreview" alt="">
            <button type="button" class="remove" id="uploadRemove" title="Remove image"><i class="mdi mdi-close"></i></button>
            <input type="file" id="image_file" accept="image/png, image/jpeg" style="display:none;">
          </div>
          <small class="text-muted d-block">JPG or PNG, up to 3 MB.</small>
        </div>

        <div class="form-row">
          <div class="form-group col-md-6">
            <label>Ref Table (optional)</label>
            <input type="text" class="form-control" id="ref_table" name="ref_table" placeholder="e.g. loan_applications">
          </div>
          <div class="form-group col-md-6">
            <label>Ref ID (optional)</label>
            <input type="number" class="form-control" id="ref_id" name="ref_id" placeholder="e.g. 1023">
          </div>
        </div>

        <div class="d-flex justify-content-between mt-3">
          <button type="button" class="btn btn-light" id="btnCancelIcon" title="Cancel">
            <i class="mdi mdi-close"></i>
          </button>
          <div>
            <button type="button" class="btn btn-outline-primary mr-2" id="btnSave">Save</button>
            <button type="button" class="btn btn-primary" id="btnSend">Send</button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- EXACT SAME SUCCESS/ERROR MODAL PATTERN AS YOUR FEES PAGE -->
  <div class="modal" id="responseModal">
    <div class="modal-content">
      <div id="responseMsg" class="mt-2"></div>
    </div>
  </div>

  <?php include '../../partials/loadjs.php'; ?>

  <script>
  /* ===== Fees-page style success modal ===== */
  function showModal(message, type){
    const modal = document.getElementById('responseModal');
    const msg   = document.getElementById('responseMsg');
    msg.innerHTML = message;
    msg.className = type || '';
    modal.classList.add('show');
    setTimeout(()=> closeModal(), 3000); // same timing as your example
  }
  function closeModal(){ document.getElementById('responseModal').classList.remove('show'); }

  /* ===== Modal helpers ===== */
  function openEditModal(mode, data){
    document.getElementById('modalTitle').textContent = mode === 'add' ? 'Add Notification' : 'Edit Notification';
    document.getElementById('notification_id').value = data?.notification_id || '';
    document.getElementById('audience').value = data?.audience || 'backend';
    document.getElementById('title').value = data?.title || '';
    document.getElementById('body').value = data?.body || '';
    document.getElementById('ref_table').value = data?.ref_table || '';
    document.getElementById('ref_id').value = data?.ref_id || '';

    clearUpload();
    if (data?.image_path) setUploadPreviewFromSrc(data.image_path);

    document.getElementById('editModal').classList.add('show');
  }
  function closeEdit(){ document.getElementById('editModal').classList.remove('show'); }
  document.getElementById('editModal').addEventListener('click', e => { if(e.target === e.currentTarget) closeEdit(); });
  document.getElementById('editCloseBtn').addEventListener('click', closeEdit);
  document.getElementById('btnCancelIcon').addEventListener('click', closeEdit);
  document.addEventListener('keydown', e => { if(e.key==='Escape') closeEdit(); });

  /* ===== Table rendering + server-side pager ===== */
  const tbody   = document.querySelector('#notifTable tbody');
  const pagerEl = document.getElementById('pager');
  const rowsSel = document.getElementById('rowsSel');
  const metaEl  = document.getElementById('tableMeta');
  const defaultImg = 'images/icons/notification.png';

  const state = { page: 1, perPage: parseInt(rowsSel.value,10)||10, total: 0 };

  function renderRows(items){
    tbody.innerHTML = '';
    if(!Array.isArray(items) || !items.length){
      const tr = document.createElement('tr');
      const td = document.createElement('td');
      td.colSpan = 9; td.className = 'text-center text-muted';
      td.textContent = 'No notifications found.';
      tr.appendChild(td); tbody.appendChild(tr); return;
    }

    items.forEach(n=>{
      const tr = document.createElement('tr');

      const tdImg = document.createElement('td');
      const img   = document.createElement('img');
      img.className='thumb';
      img.src = (n.image_path && n.image_path.trim()) ? n.image_path : defaultImg;
      img.onerror = function(){ this.src = defaultImg; };
      tdImg.appendChild(img); tr.appendChild(tdImg);

      const tdTitle = document.createElement('td'); tdTitle.textContent = n.title || ''; tr.appendChild(tdTitle);
      const tdCat   = document.createElement('td'); tdCat.textContent   = n.category || 'General'; tr.appendChild(tdCat);
      const tdAud   = document.createElement('td'); tdAud.textContent   = n.audience || 'backend'; tr.appendChild(tdAud);
      const tdBody  = document.createElement('td'); tdBody.textContent  = (n.body || '').slice(0,120); tr.appendChild(tdBody);

      const tdLink = document.createElement('td');
      if(n.ref_table && n.ref_id) tdLink.textContent = `${n.ref_table} #${n.ref_id}`; else tdLink.innerHTML = '<span class="text-muted">—</span>';
      tr.appendChild(tdLink);

      const tdDate = document.createElement('td'); tdDate.textContent = n.created_at || ''; tr.appendChild(tdDate);

      const tdStatus = document.createElement('td');
      const badge = document.createElement('span');
      const on = Number(n.is_active) === 1;
      badge.className = 'badge-dot ' + (on ? 'badge-active' : 'badge-inactive') + ' badge-click';
      badge.innerHTML = `<span style="width:8px;height:8px;border-radius:999px;background:${on?'#10b981':'#ef4444'};display:inline-block"></span>${on?'Active':'Inactive'}`;
      badge.title = 'Click to toggle';
      badge.addEventListener('click', ()=> toggleStatus(n.notification_id, badge));
      tdStatus.appendChild(badge); tr.appendChild(tdStatus);

      const tdAct = document.createElement('td');
      const btnEdit = document.createElement('button');
      btnEdit.className = 'btn btn-sm btn-outline-primary'; btnEdit.textContent = 'Edit';
      btnEdit.addEventListener('click', ()=> editNotification(n.notification_id));
      tdAct.appendChild(btnEdit); tr.appendChild(tdAct);

      tbody.appendChild(tr);
    });
  }

  function renderPager(){
    const totalPages = Math.max(1, Math.ceil(state.total / state.perPage));
    pagerEl.innerHTML = '';
    function li(disabled, active, label, page){
      const li = document.createElement('li');
      li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
      const a = document.createElement('a');
      a.className = 'page-link'; a.href='#'; a.textContent=label;
      a.addEventListener('click', (e)=>{ e.preventDefault(); if(!disabled){ state.page = page; fetchList(); }});
      li.appendChild(a); return li;
    }
    pagerEl.appendChild(li(state.page<=1,false,'«',1));
    pagerEl.appendChild(li(state.page<=1,false,'‹',Math.max(1,state.page-1)));

    const windowSize = 5;
    let start = Math.max(1, state.page - Math.floor(windowSize/2));
    let end   = Math.min(totalPages, start + windowSize - 1);
    if(end-start+1<windowSize){ start = Math.max(1, end-windowSize+1); }

    for(let p=start; p<=end; p++){
      pagerEl.appendChild(li(false, p===state.page, String(p), p));
    }

    pagerEl.appendChild(li(state.page>=totalPages,false,'›',Math.min(totalPages,state.page+1)));
    pagerEl.appendChild(li(state.page>=totalPages,false,'»',totalPages));

    const from = state.total ? ((state.page-1)*state.perPage + 1) : 0;
    const to   = Math.min(state.total, state.page*state.perPage);
    metaEl.textContent = `Showing ${from}-${to} of ${state.total}`;
  }

  async function fetchList(){
    const status   = document.getElementById('filterStatus').value;
    const audience = document.getElementById('filterAudience').value;
    const q        = document.getElementById('filterSearch').value.trim();

    const params = new URLSearchParams();
    params.set('status', status);
    params.set('audience', audience);
    if(q) params.set('q', q);
    params.set('page', state.page);
    params.set('per_page', state.perPage);

    const res = await fetch('api/notifications_list.php?'+params.toString(), {cache:'no-store'});
    const data = await res.json();

    // expected: {items:[], total:int, page:int, per_page:int}
    const items = Array.isArray(data.items) ? data.items : (Array.isArray(data) ? data : []);
    state.total   = Number(data.total || items.length || 0);
    state.page    = Number(data.page || state.page);
    state.perPage = Number(data.per_page || state.perPage);

    renderRows(items);
    renderPager();
  }

  /* filters / rows / add */
  document.getElementById('filterForm').addEventListener('submit', function(e){ e.preventDefault(); state.page=1; fetchList(); });
  document.getElementById('btnReset').addEventListener('click', function(){
    document.getElementById('filterStatus').value='active';
    document.getElementById('filterAudience').value='all';
    document.getElementById('filterSearch').value='';
    state.page=1; fetchList();
  });
  rowsSel.addEventListener('change', ()=>{ state.perPage=parseInt(rowsSel.value,10)||10; state.page=1; fetchList(); });
  document.getElementById('btnAddNew').addEventListener('click', ()=> openEditModal('add', null));

  /* toggle status -> use showModal like your fees page */
  async function toggleStatus(id, badgeEl){
    try{
      badgeEl.style.pointerEvents='none';
      const res = await fetch('api/notification_toggle.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ notification_id: id })
      });
      const j = await res.json();
      if(j && j.success){
        const on = Number(j.is_active) === 1;
        badgeEl.className = 'badge-dot ' + (on ? 'badge-active' : 'badge-inactive') + ' badge-click';
        badgeEl.innerHTML = `<span style="width:8px;height:8px;border-radius:999px;background:${on?'#10b981':'#ef4444'};display:inline-block"></span>${on?'Active':'Inactive'}`;
        showModal('Status updated', 'text-success');
      }else{
        showModal(j?.error || 'Failed to toggle status', 'text-danger');
      }
    }catch(e){
      showModal('Failed to toggle status', 'text-danger');
    }finally{
      badgeEl.style.pointerEvents='';
    }
  }

  /* edit */
  async function editNotification(id){
    try{
      const res = await fetch('api/notification_get.php?id='+encodeURIComponent(id), {cache:'no-store'});
      const j = await res.json();
      if(j && !j.error){
        openEditModal('edit', j);
        setTimeout(()=>{ const sel=document.getElementById('category'); if(j.category) sel.value=j.category; }, 50);
      }else{
        showModal(j?.error || 'Unable to load notification', 'text-danger');
      }
    }catch(e){ showModal('Unable to load notification', 'text-danger'); }
  }

  /* categories */
  async function loadCategories(){
    const sel = document.getElementById('category');
    sel.innerHTML = '<option value="">Loading…</option>';
    try{
      const r = await fetch('api/notification_categories.php',{cache:'no-store'});
      if(r.ok){
        const arr = await r.json();
        if(Array.isArray(arr) && arr.length){
          sel.innerHTML = '<option value="" disabled selected>Select category</option>';
          arr.forEach(c=> sel.appendChild(new Option(c, c)));
          return;
        }
      }
      throw new Error('fallback');
    }catch(_){
      const fallback = ['General','System','New Requests'];
      sel.innerHTML = '<option value="" disabled selected>Select category</option>';
      fallback.forEach(c=> sel.appendChild(new Option(c, c)));
    }
  }
  loadCategories();

  /* uploader */
  const uploader = document.getElementById('uploader');
  const fileInput = document.getElementById('image_file');
  const imgPrev   = document.getElementById('uploadPreview');
  const btnRemove = document.getElementById('uploadRemove');

  function clearUpload(){ fileInput.value=''; imgPrev.removeAttribute('src'); uploader.classList.remove('has-image'); }
  function setUploadPreviewFromSrc(src){ imgPrev.src = src; uploader.classList.add('has-image'); }

  uploader.addEventListener('click', (e)=>{ if(e.target === btnRemove) return; fileInput.click(); });
  btnRemove.addEventListener('click', (e)=>{ e.stopPropagation(); clearUpload(); });

  fileInput.addEventListener('change', (e)=>{
    const f = e.target.files[0];
    if(!f){ clearUpload(); return; }
    const ok = ['image/png','image/jpeg'];
    if(!ok.includes(f.type)){ showModal('Only JPG/PNG allowed.', 'text-danger'); clearUpload(); return; }
    if(f.size > 3*1024*1024){ showModal('Image must be ≤ 3MB.', 'text-danger'); clearUpload(); return; }
    const reader = new FileReader();
    reader.onload = ev => { imgPrev.src = ev.target.result; uploader.classList.add('has-image'); };
    reader.readAsDataURL(f);
  });

  /* save / send (Save = inactive, Send = active) */
  async function submitForm(isActive){
    const imageFile = fileInput.files[0];
    if (imageFile){
      const ok = ['image/png','image/jpeg'];
      if(!ok.includes(imageFile.type)){ showModal('Only JPG/PNG allowed.', 'text-danger'); return; }
      if(imageFile.size > 3*1024*1024){ showModal('Image must be ≤ 3MB.', 'text-danger'); return; }
    }
    const fd = new FormData();
    fd.append('notification_id', (document.getElementById('notification_id').value || '').trim());
    fd.append('category', (document.getElementById('category').value || '').trim());
    fd.append('audience', (document.getElementById('audience').value || '').trim());
    fd.append('title', (document.getElementById('title').value || '').trim());
    fd.append('body', (document.getElementById('body').value || '').trim());
    fd.append('ref_table', (document.getElementById('ref_table').value || '').trim());
    fd.append('ref_id', (document.getElementById('ref_id').value || '').trim());
    fd.append('is_active', isActive ? '1' : '0');
    if (imageFile) fd.append('image_file', imageFile);

    try{
      const res = await fetch('api/notification_save.php', { method:'POST', body: fd });
      const j = await res.json();
      if(j && j.success){
        showModal(isActive ? 'Sent (active)!' : 'Saved (inactive).', 'text-success');
        closeEdit();
        fetchList(); // refresh table, same page
      }else{
        showModal(j?.error || 'Save failed', 'text-danger');
      }
    }catch(e){ showModal('Save failed', 'text-danger'); }
  }
  document.getElementById('btnSave').addEventListener('click', ()=> submitForm(false));
  document.getElementById('btnSend').addEventListener('click', ()=> submitForm(true));

  /* first load */
  fetchList();
  </script>
</body>
</html>
