<?php
header('Content-Type: application/json');
require_once 'db_connection.php';

// Get the JSON data sent from the form
$data = json_decode(file_get_contents('php://input'), true);

// Basic validation
if (empty($data['customerId']) || empty($data['firstName']) || empty($data['lastName'])) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
    exit;
}

$sql = "UPDATE customer_details SET
            prefix = ?,
            first_name = ?,
            last_name = ?,
            phone_number = ?,
            customer_email = ?,
            dob = ?,
            gender = ?,
            apt_no = ?,
            address_line1 = ?,
            postcode = ?
        WHERE customer_id = ?";

try {
    $stmt = $pdo->prepare($sql);
    $success = $stmt->execute([
        $data['prefix'],
        $data['firstName'],
        $data['lastName'],
        $data['phoneNumber'],
        $data['customerEmail'],
        $data['dob'],
        $data['gender'],
        $data['aptNo'],
        $data['addressLine1'],
        $data['postcode'],
        $data['customerId']
    ]);

    if ($success) {
        echo json_encode(['status' => 'success', 'message' => 'Customer details updated successfully!']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update customer details.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>