<?php
header('Content-Type: application/json');

require_once 'db_connection.php'; // This path is now incorrect, see below
require_once 'generate_id.php'; // Assuming generate.php is also in 'includes/'

// --- HANDLE FILE UPLOAD ---
$imagePath = null;
if (isset($_FILES['staffimage']) && $_FILES['staffimage']['error'] === UPLOAD_ERR_OK) {
    
    // === CHANGE 1: The directory to save the file ===
    // Because this script is in 'includes/', the upload dir is a direct subdirectory.
    $uploadDir = 'uploads/staff/'; 
    
    // This will now correctly create the folder at: includes/uploads/staff/
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $fileTmpPath = $_FILES['staffimage']['tmp_name'];
    $fileName = $_FILES['staffimage']['name'];
    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
    
    // This path is where the file will be moved to on the server.
    $destPath = $uploadDir . $newFileName;

    $allowedfileExtensions = ['jpg', 'jpeg', 'png', 'gif'];
    if (in_array($fileExtension, $allowedfileExtensions)) {
        if (move_uploaded_file($fileTmpPath, $destPath)) {
            // === CHANGE 2: The path to store in the database ===
            // This path must be what the browser uses from the main page (e.g., index.php)
            $imagePath = 'includes/uploads/staff/' . $newFileName;
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error moving uploaded file. Check folder permissions.']);
            exit;
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Upload failed. Allowed file types: ' . implode(',', $allowedfileExtensions)]);
        exit;
    }
}

// --- PROCESS TEXT DATA ---
// ... (rest of the script)
$username = $_POST['username'] ?? null;
$email = $_POST['email'] ?? null;
$password = $_POST['password'] ?? null;
$firstname = $_POST['firstname'] ?? null;
$lastname = $_POST['lastname'] ?? null;

// ... (Validation and duplicate checks remain the same) ...

// --- DATABASE INSERTION ---
try {
    // ... (Your database insertion logic remains the same) ...
    $staffDetailsId = generateUniquestaffdetialsId();
    $staffAuthId = generateUniquestaffauthId();
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    $pdo->beginTransaction();

    $sql1 = "INSERT INTO staff_details (staffdetails_ID, firstname, lastname, email, staffimage) VALUES (?, ?, ?, ?, ?)";
    $stmt1 = $pdo->prepare($sql1);
    $stmt1->execute([$staffDetailsId, $firstname, $lastname, $email, $imagePath]);

    $sql2 = "INSERT INTO staff_auth (staffauth_id, staffdetails_ID, username, password) VALUES (?, ?, ?, ?)";
    $stmt2 = $pdo->prepare($sql2);
    $stmt2->execute([$staffAuthId, $staffDetailsId, $username, $hashedPassword]);

    $pdo->commit();
    echo json_encode(['status' => 'success', 'message' => 'Registration successful!']);

} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Registration failed. Error: ' . $e->getMessage()]);
}
?>