<?php
// This must be at the very top.
session_start();
header('Content-Type: application/json');

// === THE ONLY CHANGE IS HERE ===
// Ensure the path correctly goes up one directory from 'api/' to the project root.
require_once 'db_connection.php';

// This JSON decoding is correct for the data sent by your form.
$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['username']) || empty($data['password'])) {
    echo json_encode(['status' => 'error', 'message' => 'Username and password are required.']);
    exit;
}
$usernameOrEmail = $data['username'];
$password = $data['password'];

try {
    // This SQL query is excellent. It correctly joins the tables and selects all the data we need.
    $sql = "SELECT 
                sa.staffdetails_ID, 
                sa.username, 
                sa.password, 
                sd.email,
                sd.firstname,
                sd.lastname,
                sd.staffimage 
            FROM staff_auth sa 
            JOIN staff_details sd ON sa.staffdetails_ID = sd.staffdetails_ID 
            WHERE sa.username = ? OR sd.email = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$usernameOrEmail, $usernameOrEmail]);
    $user = $stmt->fetch();

    // The password_verify and session creation logic is secure and correct.
    if ($user && password_verify($password, $user['password'])) {
        session_regenerate_id(true);

        // All necessary user data is being correctly stored in the session.
        $_SESSION['is_logged_in'] = true;
        $_SESSION['staff_id'] = $user['staffdetails_ID'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['firstname'] = $user['firstname'];
        $_SESSION['lastname'] = $user['lastname'];
        $_SESSION['staffimage'] = $user['staffimage'];

        // The success response is perfect.
        echo json_encode(['status' => 'success', 'redirect' => 'index.php']);
        exit;
    } else {
        // The error response is secure and user-friendly.
        echo json_encode(['status' => 'error', 'message' => 'Invalid username or password.']);
        exit;
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>