<?php
header('Content-Type: application/json');

// Check if an ID is provided in the URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode(['error' => 'Customer ID is missing.']);
    exit;
}

require_once 'db_connection.php'; // Go up one directory to find the connection

$customerId = $_GET['id'];

try {
    // Use a prepared statement to prevent SQL injection
    $sql = "SELECT * FROM customer_details WHERE customer_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$customerId]);

    $customer = $stmt->fetch();

    if ($customer) {
        echo json_encode($customer);
    } else {
        echo json_encode(['error' => 'No customer found with that ID.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database query failed.']);
}
?>