<?php

// Function to generate a unique ID (16-byte string)
function generateUniqueCustomerId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'CUS'
    $final_id = substr($base64_string, 0, 6) . 'CUS' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueUserId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'USE'
    $final_id = substr($base64_string, 0, 6) . 'USE' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueLoginId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LOG'
    $final_id = substr($base64_string, 0, 6) . 'LOG' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueLoginDeviceId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LDE'
    $final_id = substr($base64_string, 0, 6) . 'LDE' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueSecurityId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'SEC'
    $final_id = substr($base64_string, 0, 6) . 'SEC' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueLoginotpId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'LTP' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueBankDetailsId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'BID' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueCustomerConsentId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'CCI' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueEmploymentDetailsId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'EID' . substr($base64_string, 9, 15);
    
    return $final_id;
}



/**
 * Formats a number into the EZY... ID format.
 * Automatically handles padding for numbers below 10000.
 *
 * @param int $number The number to format (e.g., from the database auto-increment).
 * @return string The formatted ID (e.g., "EZY0001" or "EZY10000").
 */
function formatApplicationId(int $number): string
{
    if ($number < 10000) {
        // For numbers less than 10000, pad with leading zeros to 4 digits.
        return 'EZY' . str_pad($number, 4, '0', STR_PAD_LEFT);
    } else {
        // For numbers 10000 and above, just use the number directly.
        return 'EZY' . $number;
    }
}

// ... your other ID generation functions ...

function generateUniqueLoanApplicationStatusId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'LAS' . substr($base64_string, 9, 15);
    
    return $final_id;
}


function generateUniqueLoanLmitsId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'LLM' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniqueVerificationDocumentsId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'VDI' . substr($base64_string, 9, 15);
    
    return $final_id;
}


function generateUniquestaffauthId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'STA' . substr($base64_string, 9, 15);
    
    return $final_id;
}

function generateUniquestaffdetialsId() {
    // Generate a random 24-byte string
    $random_bytes = random_bytes(24);
    
    // Convert the random bytes to a string (base64 encoding)
    $base64_string = base64_encode($random_bytes);

    // Replace the 7th, 8th, and 9th characters with 'LTP'
    $final_id = substr($base64_string, 0, 6) . 'SDI' . substr($base64_string, 9, 15);
    
    return $final_id;
}

?>


