<?php


header('Content-Type: application/json');

require_once 'db_connection.php';

$sql = "SELECT
            la.application_id,
            cd.customer_id,
            CONCAT(cd.prefix, ' ', cd.first_name, ' ', cd.last_name) AS client_name,
            la.loan_type,
            la.loan_amount,
            las.status,
            la.createdat
        FROM
            loan_application AS la
        LEFT JOIN
            customer_details AS cd ON la.customer_id = cd.customer_id
        LEFT JOIN
            loan_application_status AS las ON la.application_id = las.application_id
            WHERE
            la.loan_type LIKE ? 
        ORDER BY
            la.createdat DESC";

try {
    // Use a prepared statement to prevent SQL injection
    $stmt = $pdo->prepare($sql);
    
    // We bind the value '%Minutes%' to the placeholder.
    // The '%' wildcards mean it will match "Minutes", "Minutes Loan", etc.
    $stmt->execute(['%Instant%']);

    $data = $stmt->fetchAll();

    // Wrap the data array into an object with a "data" key, as expected by DataTables.
    $response = [
        'data' => $data
    ];
    
    echo json_encode($response);

} catch (PDOException $e) {
    http_response_code(500);
    // Send back an empty data set in case of an error, so DataTables doesn't hang.
    echo json_encode([
        'data' => [],
        'error' => 'Failed to fetch data from the database.',
        'details' => $e->getMessage()
    ]);
}
?>