<?php
// Include the database connection file
require_once 'db_connection.php';  // Ensure the path to your connection file is correct

// SQL Query to get sales data grouped by month
$sql = "
    SELECT 
        DATE_FORMAT(la.createdat, '%Y-%m') AS month, 
        SUM(la.loan_amount) AS total_amount
    FROM loan_application la
    WHERE la.createdat BETWEEN '2025-01-01' AND '2025-12-31'  -- You can adjust the date range here
    GROUP BY month
    ORDER BY month DESC
";

try {
    // Prepare and execute the SQL query
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $data = [];

    // Fetch the results
    while ($row = $stmt->fetch()) {
        $data[] = [
            "month" => $row["month"],
            "total_amount" => $row["total_amount"]
        ];
    }

    // Return data as JSON response
    echo json_encode($data);

} catch (PDOException $e) {
    // Handle error if the query fails
    error_log('SQL Query Error: ' . $e->getMessage(), 3, 'errors.log');
    echo json_encode(['error' => 'Unable to fetch data']);
}
?>
