<?php
/**
 * logout.php
 * This script securely terminates the user's session.
 */

// Step 1: Initialize the session
// You must start the session to be able to access and destroy it.
session_start();

// Step 2: Unset all of the session variables.
// Overwriting the $_SESSION array with an empty array is a thorough way to clear all session data.
$_SESSION = array();

// Step 3: Destroy the session.
// This removes the session data from the server.
session_destroy();

// Step 4: Redirect to the login page.
// After the session is destroyed, send the user back to the login screen.
header("Location: ../pages/login/login.php");

// Step 5: Ensure no further code is executed after the redirect.
exit;
?>