<?php
header('Content-Type: application/json');
session_start();
require 'db_connection.php'; // your PDO connection file

try {
    // Get the input JSON data
    $inputJSON = file_get_contents('php://input');
    $input = json_decode($inputJSON, true);

    // Check if username and password are set in the request
    if (!$input || !isset($input['username']) || !isset($input['password'])) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
        exit;
    }

    $username = trim($input['username']);
    $password = $input['password'];

    // Check if username or password is empty
    if (empty($username) || empty($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Username and password are required']);
        exit;
    }

    // Function to get the user from the database
    function getUser($pdo, $table, $username) {
        if ($table === 'admin') {
            $sql = "SELECT * FROM admin WHERE username = ? LIMIT 1";
        } else {
            $sql = "SELECT * FROM users WHERE username = ? LIMIT 1";
        }
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$username]);
        return $stmt->fetch();
    }

    // First check if user exists in the admin table
    $user = getUser($pdo, 'admin', $username);
    $login_type = 'admin';

    // If not found, check in the users table
    if (!$user) {
        $user = getUser($pdo, 'users', $username);
        $login_type = 'user';
    }

    // If no user found, return an error
    if (!$user) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid username or password']);
        exit;
    }

    // Check the password
    $passwordHash = ($login_type === 'admin') ? $user['password'] : $user['password_hash'];

    if (!password_verify($password, $passwordHash)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid username or password']);
        exit;
    }

    if ($login_type === 'admin') {
    $_SESSION['admin_id'] = $user['admin_id'];
    $_SESSION['admin_ref_Id'] = $user['admin_ref_Id'];  // Set the reference ID for admin
    $_SESSION['login_type'] = 'admin';
} else {
    $_SESSION['user_id'] = $user['user_id'];
    $_SESSION['user_ref_Id'] = $user['user_ref_Id'];    // Set the reference ID for user
    $_SESSION['login_type'] = 'user';
}
    $_SESSION['login_type'] = $login_type;
    $_SESSION['username'] = $user['username']; // Store the username in the session

    // Return success response with redirect location
    echo json_encode(['status' => 'success', 'redirect' => 'index.php']);

} catch (Exception $e) {
    // Log any exceptions for debugging purposes
    error_log('Login error: ' . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Connection error. Please try again.']);
}
?>
