<?php
// Include database connection file
include('db_connection.php');

session_start();

// Function to check the logged-in user and return the user type and ID
function getLoggedInUser() {
    if (isset($_SESSION['admin_id'])) {
        return ['id' => $_SESSION['admin_id'], 'type' => 'admin', 'ref_id' => $_SESSION['admin_ref_Id'] ?? null];
    } elseif (isset($_SESSION['user_id'])) {
        return ['id' => $_SESSION['user_id'], 'type' => 'user', 'ref_id' => $_SESSION['user_ref_Id'] ?? null];
    }
    return null;
}

// Check if user is logged in
$user = getLoggedInUser();
if (!$user) {
    echo "Unauthorized access.";
    exit;
}

// Assign the user ID, type, and ref_id
$updated_by = $user['ref_id'];  // Ref ID will be used for updated_by
$user_type = $user['type'];  // 'admin' or 'user'

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check if form data and file are set
        if (!isset($_POST['prefix'], $_POST['firstName'], $_POST['lastName'], $_POST['gender'], $_POST['dob'], $_POST['mobile'], $_POST['email'], $_POST['apt'], $_POST['address'], $_POST['postcode'], $_POST['country'], $_POST['role'])) {
            throw new Exception('Required form data is missing.');
        }

        // Form data
        $prefix = $_POST['prefix'];
        $first_name = $_POST['firstName'];
        $last_name = $_POST['lastName'];
        $gender = $_POST['gender'];
        $dob = $_POST['dob'];
        $mobilecountry = $_POST['mobileCountry'];
        $mobile = $_POST['mobile'];
        $email = $_POST['email'];
        $apt = $_POST['apt'];
        $address = $_POST['address'];
        $postcode = $_POST['postcode'];
        $country = $_POST['country'];
        $role = $_POST['role'];
        $created_by =  $user['ref_id'];  // The user who is creating this entry (set accordingly)

        // Check if the phone number or email already exists
        if (checkPhoneNumberOrEmailExists($pdo, $mobile, $email)) {
            throw new Exception('User Already Exists.');
        }

        // Handle file upload
        if (isset($_FILES['img']) && $_FILES['img']['error'] === UPLOAD_ERR_OK) {
            // File upload handling
            $upload_dir = 'uploads/staff_images/';
            $file_name = $_FILES['img']['name'];
            $file_tmp_name = $_FILES['img']['tmp_name'];
            $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            $allowed_ext = ['jpg', 'jpeg', 'png', 'gif'];
            if (in_array($file_ext, $allowed_ext)) {
                $new_file_name = uniqid('staff_', true) . '.' . $file_ext;
                $file_path = $upload_dir . $new_file_name;

                if (move_uploaded_file($file_tmp_name, $file_path)) {
                    $staff_image = $new_file_name;
                } else {
                    throw new Exception('Error uploading the file.');
                }
            } else {
                throw new Exception('Invalid file type.');
            }
        } else {
            throw new Exception('No file uploaded.');
        }

        // Generate unique staff_ref_id
        $staff_ref_id = generateStaffRefId($pdo);

        // Insert staff into `staff` table
        $query = "INSERT INTO staff (staff_ref_id, prefix, first_name, second_name, phone_number, email, apt_no, address, postcode, country_code, country, dob, gender, staff_image, role, is_active, created_at, created_by) 
                  VALUES (:staff_ref_id, :prefix, :first_name, :last_name, :mobile, :email, :apt, :address, :postcode, :countrycode, :country, :dob, :gender, :staff_image, :role, 1, NOW(), :created_by)";
        
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            ':staff_ref_id' => $staff_ref_id,
            ':prefix' => $prefix,
            ':first_name' => $first_name,
            ':last_name' => $last_name,
            ':countrycode' => $mobilecountry,
            ':mobile' => $mobile,
            ':email' => $email,
            ':apt' => $apt,
            ':address' => $address,
            ':postcode' => $postcode,
            ':country' => $country,
            ':dob' => $dob,
            ':gender' => $gender,
            ':staff_image' => $staff_image,
            ':role' => $role,
            ':created_by' => $created_by
        ]);

        // Get the last inserted staff ID
        $staff_id = $pdo->lastInsertId();

        // Generate username (lowercase and remove spaces)
        $username = strtolower($first_name . $last_name);

        // Ensure username is unique
        $username = getUniqueUsername($pdo, $username);

        // Set default password
        $password = 'EZY@1234';
        $password_hash = password_hash($password, PASSWORD_DEFAULT);

        // Insert User data into the `users` table
        $user_ref_id = 'STA' . str_pad($staff_id, 5, '0', STR_PAD_LEFT);  // Generate the user_ref_id (STA00001)

        $user_query = "INSERT INTO users (user_ref_Id, username, password_hash, user_type, created_by, created_at) 
                       VALUES (:user_ref_id, :username, :password_hash, 'Staff', :created_by, NOW())";

        $user_stmt = $pdo->prepare($user_query);
        $user_stmt->execute([
            ':user_ref_id' => $user_ref_id,
            ':username' => $username,
            ':password_hash' => $password_hash,
            ':created_by' => $created_by
        ]);

        // Return success message
        echo "Staff and User added successfully!";
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

// Function to check if the phone number or email already exists in the database
function checkPhoneNumberOrEmailExists($pdo, $mobile, $email) {
    $query = "SELECT COUNT(*) FROM staff WHERE phone_number = :mobile OR email = :email";
    $stmt = $pdo->prepare($query);
    $stmt->execute([':mobile' => $mobile, ':email' => $email]);

    // If the count is greater than 0, it means either phone number or email already exists
    return $stmt->fetchColumn() > 0;
}

// Function to generate the staff_ref_id
function generateStaffRefId($pdo) {
    $query = "SELECT staff_ref_id FROM staff ORDER BY staff_id DESC LIMIT 1";
    $stmt = $pdo->query($query);

    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch();
        $last_ref_id = $row['staff_ref_id'];
        $last_id_number = (int) substr($last_ref_id, 3);  // Assuming the prefix is 'STA'
        $new_ref_id = 'STA' . str_pad($last_id_number + 1, 5, '0', STR_PAD_LEFT);
    } else {
        $new_ref_id = 'STA00001';
    }

    return $new_ref_id;
}

// Function to ensure the username is unique
function getUniqueUsername($pdo, $username) {
    $counter = 1;
    $original_username = $username;

    // Check if the username exists in the database
    while (usernameExists($pdo, $username)) {
        // If the username exists, append a number to it
        $username = $original_username . $counter;
        $counter++;
    }

    return $username;
}

// Function to check if the username already exists
function usernameExists($pdo, $username) {
    $query = "SELECT COUNT(*) FROM users WHERE username = :username";
    $stmt = $pdo->prepare($query);
    $stmt->execute([':username' => $username]);

    // If the count is greater than 0, the username exists
    return $stmt->fetchColumn() > 0;
}
?>