<?php
// Include database connection
include 'db_connection.php';

// Check if staff_id is provided in the URL
if (isset($_GET['staff_id'])) {
    $staff_id = $_GET['staff_id'];

    try {
        // Prepare the SQL query to fetch the staff data
        $stmt = $pdo->prepare("SELECT * FROM staff WHERE staff_ref_id = ?");
        $stmt->execute([$staff_id]);
        $staffData = $stmt->fetch(PDO::FETCH_ASSOC);

        // Check if staff record is found
        if ($staffData) {
            echo json_encode($staffData);
        } else {
            echo json_encode(['error' => 'Staff not found']);
        }
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Failed to fetch data: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'No staff_ref_id provided']);
}
?>
