<?php
// get_staff_data.php

include 'db_connection.php';

try {
    // Fetch staff data from the database
    $stmt = $pdo->query("SELECT staff_ref_id, CONCAT(first_name, ' ', second_name) AS name, phone_number, role, is_active FROM staff"); // Adjust query as per your requirements

    // Fetch all data
    $staffData = $stmt->fetchAll();

    // Output the data as JSON
    echo json_encode($staffData);

} catch (PDOException $e) {
    error_log('Database Query Error: ' . $e->getMessage(), 3, 'errors.log');
    echo json_encode(["error" => "Failed to fetch staff data."]);
}

?>