<?php
include 'db_connection.php';
session_start();

// Check if user_id is passed via GET request
if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => 'user_id not provided']);
    exit;
}

$user_id = $_GET['user_id'];  // Get the user_id from the URL

// Fetch the username and password hash based on user_id
try {
    $stmt = $pdo->prepare("SELECT username, password_hash FROM users WHERE user_ref_id = :user_id");
    $stmt->execute(['user_id' => $user_id]);
    $userData = $stmt->fetch();

    if ($userData) {
        echo json_encode($userData);  // Return the data as JSON (password is hashed)
    } else {
        echo json_encode(['error' => 'User not found']);
    }
} catch (PDOException $e) {
    // Log the error for debugging purposes
    error_log('Database Error: ' . $e->getMessage(), 3, 'errors.log');
    echo json_encode(['error' => 'Error fetching user data. Please try again later.']);
}
?>
