<?php
// Include the database connection file
include 'db_connection.php';

// SQL query to join the tables and fetch data
$sql = "SELECT 
            la.application_id, 
            CONCAT(c.prefix, ' ', c.first_name, ' ', c.second_name) AS client_name, 
            la.loan_amount AS amount,
            lt.name AS loan_type,
            la.created_at AS created_at
        FROM 
            loan_applications la
        JOIN 
            customers c ON la.customer_id = c.customer_id
        JOIN 
            loantype lt ON la.loan_type_id = lt.loan_type_id";

try {
    // Prepare the SQL statement
    $stmt = $pdo->prepare($sql);
    // Execute the statement
    $stmt->execute();
    // Fetch the results as an associative array
    $loans = $stmt->fetchAll();

    // Return the data as JSON
    echo json_encode($loans);
} catch (PDOException $e) {
    // Log error and display a message
    error_log('Query Error: ' . $e->getMessage(), 3, 'errors.log');
    echo json_encode(['error' => 'Failed to fetch loan applications']);
}
?>
