<?php
// Include database connection
include 'db_connection.php';
session_start();

try {
    // SQL query to fetch loan fees along with their fee type and loan type
    $sql = "
        SELECT lf.loan_type_id, lt.name AS loan_type_name, ft.name AS fee_type_name, lf.amount
        FROM loanfee lf
        JOIN feetype ft ON lf.fee_type_id = ft.fee_type_id
        JOIN loantype lt ON lf.loan_type_id = lt.loan_type_id
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Initialize an array to group data by loan_type_id
    $groupedData = [];
    foreach ($data as $row) {
        $loan_type_id = $row['loan_type_id'];

        // Initialize loan type in the grouped array if not set
        if (!isset($groupedData[$loan_type_id])) {
            $groupedData[$loan_type_id] = [
                'loan_type_name' => $row['loan_type_name'],
                'Legal Charges' => '-',
                'Processing Fee' => '-',
                'Interest' => '-',
                'Paperwork' => '-',
                'Valuation' => '-'
            ];
        }

        // Assign the amount to the correct fee type column
        $groupedData[$loan_type_id][$row['fee_type_name']] = $row['amount'];
    }

    // Return the grouped data as JSON
    echo json_encode(array_values($groupedData));

} catch (PDOException $e) {
    // Error handling
    echo json_encode(['status' => 'error', 'message' => 'Error fetching data: ' . $e->getMessage()]);
}
?>
