<?php
// db_connection.php

// Database credentials (Consider storing these in a .env file for security)
$host = 'localhost';      // Database host (usually localhost)
$dbname = 'ezy';   // Replace with your database name
$username = 'root';       // Replace with your database username
$password = '';           // Replace with your database password
$charset = 'utf8mb4';     // Character set to use

// Set the DSN (Data Source Name)
$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

// Set PDO options (error mode to exception)
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    // Create a new PDO instance and set the connection options
    $pdo = new PDO($dsn, $username, $password, $options);
    // Optional: Uncomment to test the connection during development
    // echo "Connection successful!";
} catch (PDOException $e) {
    // Log the error to a file and display a generic message to the user
    error_log('Database Connection Error: ' . $e->getMessage(), 3, 'errors.log');  // Log error
    echo 'Connection failed: Please try again later.';  // Display generic message
    exit;
}
?>
