<?php
declare(strict_types=1);
require_once __DIR__.'/_audit.php';
/* … keep your existing helper functions exactly as-is … */

/** Save file + audit (reference_id = new document id). Returns doc id. */
function save_upload(PDO $pdo, int $cid, int $aid, string $docType, array $file, ?string $prefixForName=null, ?string $updated_by='SYSTEM'): int {
  if (!isset($file['error']) || $file['error'] !== UPLOAD_ERR_OK) {
    json_out(['status'=>'error','message'=>'upload error: '._upload_err_msg((int)($file['error']??-1))], 400);
  }
  if(!allowed_file($file['name'], (string)($file['type']??''))) {
    json_out(['status'=>'error','message'=>'Invalid file type'],400);
  }

  $projectRoot = dirname(__DIR__);
  $relDir = 'uploads';
  $absDir = $projectRoot.'/'.$relDir;
  ensure_dir($absDir); @chmod($absDir, 0775);

  $orig = $file['name']; $safe = safename($orig);
  $prefix = $prefixForName ?: $docType;
  $rel = $relDir."/{$aid}_{$prefix}_".time()."_".$safe;
  $abs = $projectRoot.'/'.$rel; ensure_dir(dirname($abs));

  $tmp = $file['tmp_name'];
  $moved = is_uploaded_file($tmp) ? @move_uploaded_file($tmp,$abs) : @rename($tmp,$abs);
  if(!$moved) $moved=@copy($tmp,$abs);
  if(!$moved) json_out(['status'=>'error','message'=>'move failed (check perms on '.$absDir.')'],500);

  $mimeStored = normalize_mime($abs, (string)($file['type']??'')); @chmod($abs,0664);

  $stmt = $pdo->prepare("INSERT INTO customer_documents
    (customer_id, application_id, doc_type, file_path, original_name, mime_type, size, verified, uploaded_at, expires_at)
    VALUES (?,?,?,?,?,?,?,0,NOW(),NULL)");
  $stmt->execute([$cid,$aid,$docType,$rel,$orig,$mimeStored,(int)$file['size']]);

  $docId = (int)$pdo->lastInsertId();

  // track_changes
  audit($pdo,'customer_documents',$docId,'upload',null,"{$docType}:{$rel}",$updated_by ?: 'SYSTEM','file uploaded');
  audit($pdo,'customer_documents',$docId,'verified',null,0,$updated_by ?: 'SYSTEM','initial status');

  return $docId;
}
