<?php
// api/toggle_doc_status.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php';
require __DIR__.'/_audit.php';
require __DIR__.'/_actor.php'; // uses session to fill updated_by

$in      = json_decode(file_get_contents('php://input'), true) ?: [];
$id      = (int)($in['id'] ?? 0);
$ver     = (int)($in['verified'] ?? -1);            // 0=pending, 1=verified, 2=rejected
$reason  = trim((string)($in['reason'] ?? ''));     // REQUIRED if rejected
$updated = current_updated_by();

if ($id <= 0 || !in_array($ver, [0,1,2], true)) {
  json_out(['status'=>'error','message'=>'invalid input'], 400);
}
if ($ver === 2 && $reason === '') { // enforce reason on rejection
  json_out(['status'=>'error','message'=>'Rejection reason is required'], 422);
}

// fetch current
$oldQ = $pdo->prepare("SELECT verified, expires_at FROM customer_documents WHERE id=?");
$oldQ->execute([$id]);
$old = $oldQ->fetch();
if (!$old) json_out(['status'=>'error','message'=>'Document not found'], 404);

$oldVer = (int)$old['verified'];
$oldExp = $old['expires_at'];
$newExp = $oldExp;

// update
if ($ver === 1) {
  // verified -> set/renew expiry (+6 months)
  $pdo->prepare("UPDATE customer_documents SET verified=1, expires_at = NOW() + INTERVAL 6 MONTH WHERE id=?")
      ->execute([$id]);
  $newExp = (new DateTimeImmutable('+6 months'))->format('Y-m-d H:i:s');

  // track expiry change (even if old was null)
  audit($pdo, 'customer_documents', $id, 'expires_at', $oldExp, $newExp, $updated, 'verified => set expiry +6 months');
} else {
  // pending or rejected -> only flip status, keep existing expiry
  $pdo->prepare("UPDATE customer_documents SET verified=? WHERE id=?")
      ->execute([$ver, $id]);
}

// reason message for track_changes
$changeReason = ($ver===2) ? $reason : (($ver===0) ? 'set pending' : 'set verified');

// track status change
audit($pdo, 'customer_documents', $id, 'verified', $oldVer, $ver, $updated, $changeReason);

json_out(['status'=>'success','new_verified'=>$ver,'expires_at'=>$newExp]);
