<?php
// api/opening_screens_update.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php'; // $pdo, json_out()
require __DIR__.'/_audit.php';     // audit()
require __DIR__.'/_actor.php';     // current_updated_by(), require_role_type()

$ALLOWED_ROLES = ['superadmin','admin','manager'];
require_role_type($ALLOWED_ROLES, $pdo);

$by = current_updated_by($pdo);

try{
  $j = json_decode(file_get_contents('php://input'), true);
  if (!is_array($j)) { json_out(['status'=>'error','message'=>'Bad JSON'], 400); exit; }

  $action = strtolower((string)($j['action'] ?? ''));
  $id     = (int)($j['screen_id'] ?? 0);
  if (!$id || !in_array($action, ['activate','deactivate','delete'], true)){
    json_out(['status'=>'error','message'=>'Invalid action or id'], 400); exit;
  }

  $st = $pdo->prepare("SELECT screen_id, is_active, is_deleted FROM opening_screens WHERE screen_id=:id");
  $st->execute([':id'=>$id]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row) { json_out(['status'=>'error','message'=>'Not found'], 404); exit; }

  if ($action==='activate'){
    if ((int)$row['is_deleted']===1){ json_out(['status'=>'error','message'=>'Cannot activate deleted item'], 400); exit; }

    $pdo->beginTransaction();
    try{
      // deactivate all active
      $a = $pdo->query("SELECT screen_id FROM opening_screens WHERE is_active=1 AND is_deleted=0 FOR UPDATE")->fetchAll(PDO::FETCH_COLUMN);
      if ($a){
        $in = implode(',', array_map('intval', $a));
        $pdo->exec("UPDATE opening_screens SET is_active=0, updated_at=NOW(), updated_by=".$pdo->quote($by)." WHERE screen_id IN ($in)");
        foreach($a as $aid){ audit($pdo,'opening_screens',(int)$aid,'is_active','1','0',$by,'Auto-deactivated'); }
      }
      // activate target
      $old = (int)$row['is_active'];
      $st = $pdo->prepare("UPDATE opening_screens SET is_active=1, updated_at=NOW(), updated_by=:by WHERE screen_id=:id AND is_deleted=0");
      $st->execute([':by'=>$by, ':id'=>$id]);
      if ($old!==1) audit($pdo,'opening_screens',$id,'is_active',(string)$old,'1',$by,'Activate');

      $pdo->commit();
      json_out(['status'=>'success']);
    }catch(Throwable $e){ $pdo->rollBack(); json_out(['status'=>'error','message'=>'Activate failed'], 500); }
    exit;
  }

  if ($action==='deactivate'){
    if ((int)$row['is_active']===0){ json_out(['status'=>'success']); exit; }
    $pdo->prepare("UPDATE opening_screens SET is_active=0, updated_at=NOW(), updated_by=:by WHERE screen_id=:id")
        ->execute([':by'=>$by, ':id'=>$id]);
    audit($pdo,'opening_screens',$id,'is_active','1','0',$by,'Deactivate');
    json_out(['status'=>'success']); exit;
  }

  if ($action==='delete'){
    $oldDel = (int)$row['is_deleted'];
    $oldAct = (int)$row['is_active'];
    $pdo->prepare("UPDATE opening_screens SET is_deleted=1, is_active=0, updated_at=NOW(), updated_by=:by WHERE screen_id=:id")
        ->execute([':by'=>$by, ':id'=>$id]);
    if ($oldDel!==1) audit($pdo,'opening_screens',$id,'is_deleted',(string)$oldDel,'1',$by,'Soft delete');
    if ($oldAct===1) audit($pdo,'opening_screens',$id,'is_active','1','0',$by,'Soft delete (auto-deactivate)');
    json_out(['status'=>'success']); exit;
  }

  json_out(['status'=>'error','message'=>'Unknown action'], 400);
} catch (Throwable $e){
  json_out(['status'=>'error','message'=>'Server error'], 500);
}
