<?php
// api/opening_screens_list.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php'; // $pdo, json_out()

function kind_from_path(string $p): string {
  $l = strtolower($p);
  if (str_ends_with($l, '.json')) return 'lottie';
  if (preg_match('~\.(mp4|webm|mov|m4v|ogg|ogv)$~', $l)) return 'video';
  if (str_ends_with($l, '.gif')) return 'gif';
  // default image
  return 'image';
}

try{
  $sql = "SELECT screen_id, label, file_path, is_active, is_deleted, created_at, created_by, updated_at, updated_by
          FROM opening_screens
          ORDER BY is_deleted ASC, is_active DESC, updated_at DESC, screen_id DESC";
  $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($rows as &$r) {
    $r['media_kind'] = kind_from_path((string)($r['file_path'] ?? ''));
  }

  json_out($rows);
} catch (Throwable $e){
  json_out(['error'=>'Server error'], 500);
}
