<?php
// api/notifications_list.php
declare(strict_types=1);
require __DIR__.'/_bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

/**
 * Query params:
 *   status=active|inactive|all   (default: active)
 *   audience=backend|consumer|all (default: all)
 *   q=free text (search title/body/category)
 *   limit=1..500 (default: 100)
 *   offset>=0    (default: 0)
 */

$status   = strtolower((string)($_GET['status']   ?? 'active'));
$audience = strtolower((string)($_GET['audience'] ?? 'all'));
$q        = trim((string)($_GET['q'] ?? ''));

$limit  = (int)($_GET['limit']  ?? 100);
$offset = (int)($_GET['offset'] ?? 0);
$limit  = max(1, min(500, $limit));
$offset = max(0, $offset);

$conds  = [];
$params = [];

if ($status === 'active')   { $conds[] = 'is_active = 1'; }
elseif ($status === 'inactive') { $conds[] = 'is_active = 0'; }

if ($audience === 'backend')  { $conds[] = 'audience = :aud'; $params[':aud'] = 'backend'; }
elseif ($audience === 'consumer') { $conds[] = 'audience = :aud'; $params[':aud'] = 'consumer'; }

if ($q !== '') {
  $conds[] = '(title LIKE :q OR body LIKE :q OR category LIKE :q)';
  $params[':q'] = '%'.$q.'%';
}

$sql = "SELECT notification_id, category, audience, title, body,
               image_path, ref_table, ref_id, is_active, created_at, updated_by
        FROM notifications";
if ($conds) $sql .= ' WHERE '.implode(' AND ', $conds);
$sql .= ' ORDER BY COALESCE(created_at, NOW()) DESC, notification_id DESC
          LIMIT :lim OFFSET :off';

$st = $pdo->prepare($sql);
foreach ($params as $k => $v) $st->bindValue($k, $v);
$st->bindValue(':lim',  $limit,  PDO::PARAM_INT);
$st->bindValue(':off',  $offset, PDO::PARAM_INT);
$st->execute();

echo json_encode($st->fetchAll(), JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
