<?php
// api/notification_sounds_list.php
declare(strict_types=1);
require __DIR__.'/_bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

$type = strtolower((string)($_GET['type'] ?? ''));
$allow = ['notice','new_request'];
if($type && !in_array($type,$allow,true)){
  echo json_encode(['success'=>false,'error'=>'Invalid type']); exit;
}

if($type){
  $stmt = $pdo->prepare('
    SELECT `id`,`type`,`label`,`src`,`volume`,`loop`,`enabled`,`created_at`,`created_by`
    FROM `notification_sounds`
    WHERE `type`=:t && `is_deleted` = 0
    ORDER BY `enabled` DESC, `id` DESC
  ');
  $stmt->execute([':t'=>$type]);
}else{
  $stmt = $pdo->query('
    SELECT `id`,`type`,`label`,`src`,`volume`,`loop`,`enabled`,`created_at`,`created_by`
    FROM `notification_sounds` WHERE `is_deleted` = 0
    ORDER BY `type`, `enabled` DESC, `id` DESC
  ');
}
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo json_encode(['success'=>true,'items'=>$rows], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
