<?php
// api/notification_sounds_disable.php — disable a sound (enabled=0)
declare(strict_types=1);
require __DIR__ . '/_bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }
$authed = (isset($_SESSION['login_type']) && (isset($_SESSION['admin_id']) || isset($_SESSION['user_id'])));
if (!$authed) { http_response_code(403); echo json_encode(['error'=>'forbidden']); exit; }

$id = (int)($_POST['id'] ?? 0);
try{
  $pdo->prepare("UPDATE notification_sounds SET enabled=0 WHERE id=:id")->execute([':id'=>$id]);
  echo json_encode(['success'=>true]);
}catch(Throwable $e){
  http_response_code(400);
  echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
