<?php
// api/notification_sounds.php — return active sounds in a flat shape the navbar expects
declare(strict_types=1);
require __DIR__ . '/_bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

// ---- auth (admin or user) ----
if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }
$authed = (isset($_SESSION['login_type']) && (isset($_SESSION['admin_id']) || isset($_SESSION['user_id'])));
if (!$authed) { http_response_code(403); echo json_encode(['error'=>'forbidden']); exit; }


$out = [
  'notice'      => null,
  'new_request' => null,
];

// Only enabled & not deleted (if you have is_deleted column)
$sql = "SELECT type, label, src, volume, `loop`, enabled
          FROM notification_sounds
         WHERE enabled = 1
           AND (CASE WHEN EXISTS (
                  SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS
                   WHERE TABLE_SCHEMA = DATABASE()
                     AND TABLE_NAME = 'notification_sounds'
                     AND COLUMN_NAME = 'is_deleted'
                )
                THEN IFNULL(is_deleted,0) = 0
                ELSE 1
               END)
       ";
$stmt = $pdo->query($sql);
$rows = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];

foreach ($rows as $r) {
  $type = (string)$r['type'];
  if ($type !== 'notice' && $type !== 'new_request') continue;

  // Keep first enabled row per type (should be only one anyway)
  if ($out[$type] === null) {
    $src = ltrim((string)$r['src'], '/'); // return relative; frontend prefixes correctly
    $out[$type] = [
      'label'   => (string)$r['label'],
      'src'     => $src,
      'volume'  => (float)$r['volume'],
      'loop'    => (int)$r['loop'] ? 1 : 0,
      'enabled' => 1,
    ];
  }
}

echo json_encode($out, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
