<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');

$pdo = new PDO('mysql:host=localhost;dbname=ezy;charset=utf8mb4', 'root', '', [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

function json_out($data, int $code=200){ http_response_code($code); echo json_encode($data, JSON_UNESCAPED_SLASHES); exit; }

function kind_from_path(string $p): string {
  $l = strtolower($p);
  if (str_ends_with($l, '.json')) return 'lottie';
  if (preg_match('~\.(mp4|webm|mov|m4v|ogg|ogv)$~', $l)) return 'video';
  if (str_ends_with($l, '.gif')) return 'gif';
  return 'image';
}
