<?php
// api/list_documents.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php';
require __DIR__.'/_audit.php';
require __DIR__.'/_actor.php';   // <- add

$customer_id    = isset($_GET['customer_id']) ? (int)$_GET['customer_id'] : 0;
$application_id = isset($_GET['application_id']) ? (int)$_GET['application_id'] : 0;
if ($customer_id <= 0 || $application_id <= 0) json_out(['error' => 'missing ids'], 400);

$stmt = $pdo->prepare("
  SELECT id, customer_id, application_id, doc_type, file_path, original_name,
         mime_type, size, verified, uploaded_at, expires_at
    FROM customer_documents
   WHERE customer_id = ? AND application_id = ?
   ORDER BY uploaded_at DESC, id DESC
");
$stmt->execute([$customer_id, $application_id]);
$items = $stmt->fetchAll();

$by  = current_updated_by();                    // <- session-based actor
$now = new DateTimeImmutable('now');
$markExpired = $pdo->prepare("UPDATE customer_documents SET verified = 3 WHERE id = ?");

foreach ($items as &$it) {
  if (!empty($it['expires_at'])) {
    try {
      $exp = new DateTimeImmutable($it['expires_at']);
      if ($exp < $now && (int)$it['verified'] !== 3) {
        $prev = (int)$it['verified'];
        $markExpired->execute([$it['id']]);
        $it['verified'] = 3;

        // track_changes: reference_id = document id, updated_by = session user
        audit($pdo, 'customer_documents', (int)$it['id'], 'verified', $prev, 3, $by, 'auto-expired');
      }
    } catch (\Throwable $e) {}
  }
  $it['id']             = (int)$it['id'];
  $it['customer_id']    = (int)$it['customer_id'];
  $it['application_id'] = (int)$it['application_id'];
  $it['size']           = isset($it['size']) ? (int)$it['size'] : null;
  $it['verified']       = (int)$it['verified'];
}

json_out(['items' => $items]);
