<?php
// api/get_header_info.php  (fits your schema; returns: application_id, customer_id, client_name, loan_type, bank{})
declare(strict_types=1);
require __DIR__.'/_bootstrap.php';

$appId = isset($_GET['application_id']) ? (int)$_GET['application_id'] : 0;
if ($appId <= 0) json_out(['error' => 'Invalid application_id'], 400);

// App + customer + loan type (your tables)
$sql = "
  SELECT la.application_id, la.application_ref_id,
         la.customer_id,
         TRIM(CONCAT(COALESCE(c.first_name,''),' ',COALESCE(c.second_name,''))) AS client_name,
         lt.name AS loan_type
    FROM loan_applications la
    LEFT JOIN customers c ON c.customer_id = la.customer_id
    LEFT JOIN loantype lt ON lt.loan_type_id = la.loantype
   WHERE la.application_id = ?
   LIMIT 1";
$st = $pdo->prepare($sql);
$st->execute([$appId]);
$row = $st->fetch();
if (!$row) json_out(['error' => 'Application not found'], 404);

// Bank (latest, prefer primary)
$bst = $pdo->prepare("
  SELECT account_holder_name, bank_name, account_number, sort_code, iban, swift_bic, account_type, is_primary_account
    FROM bank_details
   WHERE customer_id = ?
   ORDER BY is_primary_account DESC, created_at DESC
   LIMIT 1");
$bst->execute([(int)$row['customer_id']]);
$row['bank'] = $bst->fetch() ?: null;

json_out($row);
