<?php
// api/get_customer.php
declare(strict_types=1);

require __DIR__.'/_bootstrap.php'; // uses $pdo and json_out()

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  json_out(['error' => 'Invalid or missing customer id'], 400);
}

$sql = "
  SELECT
    customer_id,
    prefix,
    first_name,
    second_name,                    -- <== matches the page
    email,                          -- <== matches the page
    gender,
    phone_number,
    martial_status,                 -- keep DB spelling
    DATE_FORMAT(dob, '%Y-%m-%d') AS dob,
    address_line1,
    apt_no,
    postcode
  FROM customers
  WHERE customer_id = ?
  LIMIT 1
";
$st = $pdo->prepare($sql);
$st->execute([$id]);
$row = $st->fetch();

if (!$row) {
  json_out(['error' => 'Customer not found'], 404);
}

json_out($row);
